/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.execution.Location;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit2.PsiMemberParameterizedLocation;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import java.util.Iterator;

public class TestRunnerUtils {
    static Location<PsiMethod> getMethodLocation(Location contextLocation) {
        PsiClass containingClass;
        MethodLocation methodLocation = TestRunnerUtils.getTestMethod(contextLocation);
        if (methodLocation == null) {
            return null;
        }
        if (contextLocation instanceof PsiMemberParameterizedLocation && (containingClass = ((PsiMemberParameterizedLocation)contextLocation).getContainingClass()) != null) {
            methodLocation = MethodLocation.elementInClass((PsiMethod)((PsiMethod)methodLocation.getPsiElement()), (PsiClass)containingClass);
        }
        return methodLocation;
    }

    static Location<PsiMethod> getTestMethod(Location<?> location) {
        Iterator iterator = location.getAncestors(PsiMethod.class, false);
        while (iterator.hasNext()) {
            Location methodLocation = (Location)iterator.next();
            if (!JUnitUtil.isTestMethod((Location)methodLocation, (boolean)false)) continue;
            return methodLocation;
        }
        return null;
    }
}

