/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.properties;

import com.intellij.lang.Language;
import com.intellij.lang.properties.parsing.PropertiesElementTypes;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.psi.PropertyKeyIndex;
import com.intellij.lang.properties.psi.PropertyStub;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lang.properties.psi.impl.PropertyStubImpl;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;

public class PropertyStubElementType
extends IStubElementType<PropertyStub, Property> {
    public PropertyStubElementType() {
        super("PROPERTY", (Language)PropertiesElementTypes.LANG);
    }

    public Property createPsi(PropertyStub stub) {
        return new PropertyImpl(stub, (IStubElementType)this);
    }

    public PropertyStub createStub(Property psi, StubElement parentStub) {
        return new PropertyStubImpl(parentStub, psi.getKey());
    }

    public String getExternalId() {
        return "properties.prop";
    }

    public void serialize(PropertyStub stub, StubOutputStream dataStream) throws IOException {
        dataStream.writeName(stub.getKey());
    }

    public PropertyStub deserialize(StubInputStream dataStream, StubElement parentStub) throws IOException {
        StringRef ref = dataStream.readName();
        return new PropertyStubImpl(parentStub, ref.getString());
    }

    public void indexStub(PropertyStub stub, IndexSink sink) {
        sink.occurrence(PropertyKeyIndex.KEY, (Object)PropertyImpl.unescape(stub.getKey()));
    }
}

