/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.references;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.codeInsight.lookup.RealLookupElementPresentation;
import com.intellij.icons.AllIcons;
import com.intellij.lang.properties.EmptyResourceBundle;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesHighlighter;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.references.PropertiesPsiCompletionUtil;
import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.lang.properties.references.PropertyReferenceBase;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class PropertiesCompletionContributor
extends CompletionContributor {
    public static final LookupElementRenderer<LookupElement> LOOKUP_ELEMENT_RENDERER = new LookupElementRenderer<LookupElement>(){

        public void renderElement(LookupElement element, LookupElementPresentation presentation) {
            PropertiesFile defaultPropertiesFile;
            IProperty defaultProperty;
            boolean hasBundle;
            IProperty property = (IProperty)element.getObject();
            presentation.setIcon(PlatformIcons.PROPERTY_ICON);
            String key = StringUtil.notNullize((String)property.getUnescapedKey());
            presentation.setItemText(key);
            PropertiesFile propertiesFile = property.getPropertiesFile();
            ResourceBundle resourceBundle = propertiesFile.getResourceBundle();
            String value = property.getValue();
            boolean bl = hasBundle = resourceBundle != EmptyResourceBundle.getInstance();
            if (hasBundle && (defaultProperty = (defaultPropertiesFile = resourceBundle.getDefaultPropertiesFile(propertiesFile.getProject())).findPropertyByKey(key)) != null) {
                value = defaultProperty.getValue();
            }
            if (hasBundle) {
                presentation.setTypeText(resourceBundle.getBaseName(), AllIcons.FileTypes.Properties);
            }
            if (presentation instanceof RealLookupElementPresentation && value != null) {
                value = "=" + value;
                int limit = 1000;
                if (value.length() > limit || !((RealLookupElementPresentation)presentation).hasEnoughSpaceFor(value, false)) {
                    if (value.length() > limit) {
                        value = value.substring(0, limit);
                    }
                    while (value.length() > 0 && !((RealLookupElementPresentation)presentation).hasEnoughSpaceFor(value + "...", false)) {
                        value = value.substring(0, value.length() - 1);
                    }
                    value = value + "...";
                }
            }
            TextAttributes attrs = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(PropertiesHighlighter.PROPERTY_VALUE);
            presentation.setTailText(value, attrs.getForegroundColor());
        }
    };

    public PropertiesCompletionContributor() {
        this.extend(null, (ElementPattern)PlatformPatterns.psiElement(), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(CompletionParameters parameters, ProcessingContext context, CompletionResultSet result) {
                PropertiesCompletionContributor.doAdd(parameters, result);
            }
        });
    }

    private static void doAdd(CompletionParameters parameters, CompletionResultSet result) {
        TextRange range;
        PsiElement element;
        int startOffset;
        int offsetInElement;
        PsiElement position = parameters.getPosition();
        Object[] references = (PsiReference[])ArrayUtil.mergeArrays((Object[])position.getReferences(), (Object[])position.getParent().getReferences());
        PropertyReference propertyReference = (PropertyReference)ContainerUtil.findInstance((Object[])references, PropertyReference.class);
        if (propertyReference != null && !PropertiesCompletionContributor.hasMoreImportantReference((PsiReference[])references, propertyReference) && (offsetInElement = (startOffset = parameters.getOffset()) - (element = propertyReference.getElement()).getTextRange().getStartOffset()) >= (range = propertyReference.getRangeInElement()).getStartOffset()) {
            String prefix = element.getText().substring(range.getStartOffset(), offsetInElement);
            LookupElement[] variants = PropertiesCompletionContributor.getVariants(propertyReference);
            result.withPrefixMatcher(prefix).addAllElements(Arrays.asList(variants));
        }
    }

    public static boolean hasMoreImportantReference(PsiReference[] references, PropertyReference propertyReference) {
        return propertyReference.isSoft() && ContainerUtil.or((Object[])references, (Condition)new Condition<PsiReference>(){

            public boolean value(PsiReference reference) {
                return !reference.isSoft();
            }
        });
    }

    public static LookupElement[] getVariants(PropertyReferenceBase propertyReference) {
        Set<Object> variants = PropertiesPsiCompletionUtil.getPropertiesKeys(propertyReference);
        return PropertiesCompletionContributor.getVariants(variants);
    }

    public static LookupElement[] getVariants(Set<Object> variants) {
        List elements = ContainerUtil.mapNotNull(variants, (Function)new NullableFunction<Object, LookupElement>(){

            public LookupElement fun(Object o) {
                if (o instanceof String) {
                    return LookupElementBuilder.create((String)((String)o)).withIcon(PlatformIcons.PROPERTY_ICON);
                }
                return PropertiesCompletionContributor.createVariant((IProperty)o);
            }
        });
        return elements.toArray(new LookupElement[elements.size()]);
    }

    public static LookupElement createVariant(IProperty property) {
        String key = property.getKey();
        return key == null ? null : LookupElementBuilder.create((Object)property, (String)key).withRenderer(LOOKUP_ELEMENT_RENDERER);
    }

    public void beforeCompletion(CompletionInitializationContext context) {
        if (context.getFile() instanceof PropertiesFile) {
            context.setDummyIdentifier(CompletionUtil.DUMMY_IDENTIFIER_TRIMMED);
        }
    }
}

