/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.refactoring.rename;

import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.ResourceBundleManager;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;

public class ResourceBundleRenamer
extends AutomaticRenamer {
    private final ResourceBundleManager myResourceBundleManager;

    public ResourceBundleRenamer(PropertiesFile propertiesFile, String newName) {
        this.myResourceBundleManager = ResourceBundleManager.getInstance(propertiesFile.getProject());
        for (PropertiesFile file : propertiesFile.getResourceBundle().getPropertiesFiles()) {
            if (file.equals(propertiesFile)) continue;
            PsiFile containingFile = file.getContainingFile();
            this.myElements.add(containingFile);
        }
        this.suggestAllNames(propertiesFile.getName(), newName);
    }

    protected String nameToCanonicalName(String name, PsiNamedElement element) {
        return this.myResourceBundleManager.getBaseName((PsiFile)element);
    }

    protected String canonicalNameToName(String canonicalName, PsiNamedElement element) {
        String oldCanonicalName = this.myResourceBundleManager.getBaseName((PsiFile)element);
        String oldName = element.getName();
        assert (oldName != null);
        return canonicalName + oldName.substring(oldCanonicalName.length());
    }

    public boolean isSelectedByDefault() {
        return true;
    }

    public String getDialogTitle() {
        return PropertiesBundle.message("resource.bundle.renamer", new Object[0]);
    }

    public String getDialogDescription() {
        return PropertiesBundle.message("resource.bundle.renamer.dialog.description", new Object[0]);
    }

    public String entityName() {
        return PropertiesBundle.message("resource.bundle.renamer.entity.name", new Object[0]);
    }
}

