/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.parsing;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lang.properties.parsing.PropertiesElementTypes;
import com.intellij.lang.properties.parsing.PropertiesLexer;
import com.intellij.lang.properties.parsing.PropertiesParser;
import com.intellij.lang.properties.parsing.PropertiesTokenTypes;
import com.intellij.lang.properties.psi.impl.PropertiesFileImpl;
import com.intellij.lang.properties.psi.impl.PropertiesListImpl;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;

public class PropertiesParserDefinition
implements ParserDefinition {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.properties.PropertiesParserDefinition");

    public Lexer createLexer(Project project) {
        return new PropertiesLexer();
    }

    public IFileElementType getFileNodeType() {
        return PropertiesElementTypes.FILE;
    }

    public TokenSet getWhitespaceTokens() {
        return PropertiesTokenTypes.WHITESPACES;
    }

    public TokenSet getCommentTokens() {
        return PropertiesTokenTypes.COMMENTS;
    }

    public TokenSet getStringLiteralElements() {
        return TokenSet.EMPTY;
    }

    public PsiParser createParser(Project project) {
        return new PropertiesParser();
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new PropertiesFileImpl(viewProvider);
    }

    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return ParserDefinition.SpaceRequirements.MAY;
    }

    public PsiElement createElement(ASTNode node) {
        IElementType type = node.getElementType();
        if (type == PropertiesElementTypes.PROPERTY) {
            return new PropertyImpl(node);
        }
        if (type == PropertiesElementTypes.PROPERTIES_LIST) {
            return new PropertiesListImpl(node);
        }
        throw new AssertionError((Object)("Alien element type [" + type + "]. Can't create Property PsiElement for that."));
    }
}

