/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.FileEditorProvider;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.newStructureView.StructureViewComponent;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.ide.util.treeView.smartTree.CachingChildrenTreeNode;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.ChooseSubsequentPropertyValueEditorAction;
import com.intellij.lang.properties.editor.NoPropertySelectedPanel;
import com.intellij.lang.properties.editor.PropertiesValueHighlighter;
import com.intellij.lang.properties.editor.ResourceBundleEditorViewElement;
import com.intellij.lang.properties.editor.ResourceBundlePropertiesInsertManager;
import com.intellij.lang.properties.editor.ResourceBundlePropertiesInsertManagerImpl;
import com.intellij.lang.properties.editor.ResourceBundlePropertyStructureViewElement;
import com.intellij.lang.properties.editor.ResourceBundleStructureViewComponent;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.PropertiesResourceBundleUtil;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.Stack;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.Scrollable;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class ResourceBundleEditor
extends UserDataHolderBase
implements FileEditor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.properties.editor.ResourceBundleEditor");
    private static final String VALUES = "values";
    private static final String NO_PROPERTY_SELECTED = "noPropertySelected";
    public static final Key<ResourceBundleEditor> RESOURCE_BUNDLE_EDITOR_KEY = Key.create((String)"resourceBundleEditor");
    private final StructureViewComponent myStructureViewComponent;
    private final Map<PropertiesFile, Editor> myEditors;
    private final ResourceBundle myResourceBundle;
    private final ResourceBundlePropertiesInsertManager myPropertiesInsertDeleteManager;
    private final Map<PropertiesFile, JPanel> myTitledPanels;
    private final JComponent myNoPropertySelectedPanel = new NoPropertySelectedPanel().getComponent();
    private final Project myProject;
    private final DataProviderPanel myDataProviderPanel;
    private final Set<PropertiesFile> myBackSlashPressed = new THashSet();
    private final Alarm mySelectionChangeAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    private JPanel myValuesPanel;
    private JPanel myStructureViewPanel;
    private boolean myDisposed;
    private VirtualFileListener myVfsListener;
    private Editor mySelectedEditor;
    private String myPropertyToSelectWhenVisible;

    public ResourceBundleEditor(ResourceBundle resourceBundle) {
        this.myProject = resourceBundle.getProject();
        JPanel splitPanel = new JPanel();
        this.myValuesPanel = new JPanel();
        this.myStructureViewPanel = new JPanel();
        JBSplitter splitter = new JBSplitter(false);
        splitter.setFirstComponent((JComponent)this.myStructureViewPanel);
        splitter.setSecondComponent((JComponent)this.myValuesPanel);
        splitter.setShowDividerControls(true);
        splitter.setHonorComponentsMinimumSize(true);
        splitter.setAndLoadSplitterProportionKey(((Object)((Object)this)).getClass() + ".splitter");
        splitPanel.setLayout(new BorderLayout());
        splitPanel.add((Component)splitter, "Center");
        this.myResourceBundle = resourceBundle;
        this.myPropertiesInsertDeleteManager = ResourceBundlePropertiesInsertManagerImpl.create(resourceBundle);
        this.myStructureViewComponent = new ResourceBundleStructureViewComponent(this.myResourceBundle, this);
        this.myStructureViewPanel.setLayout(new BorderLayout());
        this.myStructureViewPanel.add((Component)this.myStructureViewComponent, "Center");
        this.myStructureViewComponent.getTree().getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){
            private IProperty selectedProperty;
            private PropertiesFile selectedPropertiesFile;

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (Comparing.equal((Object)e.getNewLeadSelectionPath(), (Object)e.getOldLeadSelectionPath()) || ResourceBundleEditor.this.getSelectedProperty() == null) {
                    return;
                }
                if (!this.arePropertiesEquivalent(this.selectedProperty, ResourceBundleEditor.this.getSelectedProperty()) || !Comparing.equal((Object)this.selectedPropertiesFile, (Object)ResourceBundleEditor.this.getSelectedPropertiesFile())) {
                    if (e.getOldLeadSelectionPath() != null) {
                        for (Map.Entry entry : ResourceBundleEditor.this.myEditors.entrySet()) {
                            if (entry.getValue() != ResourceBundleEditor.this.mySelectedEditor) continue;
                            ResourceBundleEditor.this.writeEditorPropertyValue(ResourceBundleEditor.this.mySelectedEditor, (PropertiesFile)entry.getKey(), this.selectedProperty.getName());
                            break;
                        }
                    }
                    this.selectedProperty = ResourceBundleEditor.this.getSelectedProperty();
                    this.selectedPropertiesFile = ResourceBundleEditor.this.getSelectedPropertiesFile();
                    ResourceBundleEditor.this.selectionChanged();
                }
            }

            private boolean arePropertiesEquivalent(IProperty p1, IProperty p2) {
                if (p1 == p2) {
                    return true;
                }
                if (p1 == null || p2 == null) {
                    return false;
                }
                return p1.getPsiElement().isEquivalentTo(p2.getPsiElement());
            }
        });
        this.installPropertiesChangeListeners();
        this.myEditors = new THashMap();
        this.myTitledPanels = new THashMap();
        this.recreateEditorsPanel();
        TreeElement[] children = this.myStructureViewComponent.getTreeModel().getRoot().getChildren();
        if (children.length != 0) {
            TreeElement child = children[0];
            String propName = ((ResourceBundlePropertyStructureViewElement)child).getProperty().getUnescapedKey();
            this.setState(new ResourceBundleEditorState(propName));
        }
        this.myDataProviderPanel = new DataProviderPanel(splitPanel);
        this.myProject.getMessageBus().connect((Disposable)this.myProject).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerAdapter(){

            public void selectionChanged(FileEditorManagerEvent event) {
                ResourceBundleEditor.this.onSelectionChanged(event);
            }
        });
    }

    public ResourceBundle getResourceBundle() {
        return this.myResourceBundle;
    }

    public void updateTreeRoot() {
        Object element = this.myStructureViewComponent.getTreeStructure().getRootElement();
        if (element instanceof CachingChildrenTreeNode) {
            ((CachingChildrenTreeNode)element).rebuildChildren();
        }
    }

    public ResourceBundlePropertiesInsertManager getPropertiesInsertDeleteManager() {
        return this.myPropertiesInsertDeleteManager;
    }

    private void onSelectionChanged(FileEditorManagerEvent event) {
        FileEditor oldEditor = event.getOldEditor();
        FileEditor newEditor = event.getNewEditor();
        if (oldEditor != this && newEditor != this) {
            return;
        }
        if (newEditor == this) {
            if (oldEditor instanceof TextEditor) {
                this.myPropertiesInsertDeleteManager.reload();
                this.setStructureViewSelectionFromPropertiesFile(((TextEditor)oldEditor).getEditor());
            } else if (this.myPropertyToSelectWhenVisible != null) {
                this.setStructureViewSelection(this.myPropertyToSelectWhenVisible);
                this.myPropertyToSelectWhenVisible = null;
            }
        } else if (newEditor instanceof TextEditor) {
            this.setPropertiesFileSelectionFromStructureView(((TextEditor)newEditor).getEditor());
        }
    }

    private void setStructureViewSelectionFromPropertiesFile(Editor propertiesFileEditor) {
        int line = propertiesFileEditor.getCaretModel().getLogicalPosition().line;
        Document document = propertiesFileEditor.getDocument();
        if (line >= document.getLineCount()) {
            return;
        }
        String propertyName = ResourceBundleEditor.getPropertyName(document, line);
        if (propertyName == null) {
            return;
        }
        this.setStructureViewSelection(propertyName);
    }

    private void setStructureViewSelection(final String propertyName) {
        if (this.myStructureViewComponent.isDisposed()) {
            return;
        }
        JTree tree = this.myStructureViewComponent.getTree();
        if (tree == null) {
            return;
        }
        Object root = tree.getModel().getRoot();
        if (AbstractTreeUi.isLoadingChildrenFor((Object)root)) {
            boolean isEditorVisible = false;
            for (FileEditor editor : FileEditorManager.getInstance((Project)this.myProject).getSelectedEditors()) {
                if (editor != this) continue;
                isEditorVisible = true;
                break;
            }
            if (!isEditorVisible) {
                this.myPropertyToSelectWhenVisible = propertyName;
                return;
            }
            this.mySelectionChangeAlarm.cancelAllRequests();
            this.mySelectionChangeAlarm.addRequest(new Runnable(){

                @Override
                public void run() {
                    ResourceBundleEditor.this.mySelectionChangeAlarm.cancelAllRequests();
                    ResourceBundleEditor.this.setStructureViewSelection(propertyName);
                }
            }, 500);
            return;
        }
        Stack toCheck = ContainerUtilRt.newStack();
        toCheck.push((Object)this.myStructureViewComponent.getTreeModel().getRoot());
        while (!toCheck.isEmpty()) {
            PsiElement value;
            TreeElement element = (TreeElement)toCheck.pop();
            PsiElement psiElement = value = element instanceof ResourceBundlePropertyStructureViewElement ? ((ResourceBundlePropertyStructureViewElement)element).getValue() : null;
            if (value instanceof IProperty && propertyName.equals(((IProperty)value).getUnescapedKey())) {
                this.myStructureViewComponent.select((Object)value, true);
                this.selectionChanged();
                return;
            }
            for (TreeElement treeElement : element.getChildren()) {
                toCheck.push((Object)treeElement);
            }
        }
    }

    private static String getPropertyName(Document document, int line) {
        int startOffset = document.getLineStartOffset(line);
        int endOffset = StringUtil.indexOf((CharSequence)document.getCharsSequence(), (char)'=', (int)startOffset, (int)document.getLineEndOffset(line));
        if (endOffset <= startOffset) {
            return null;
        }
        String propertyName = ((Object)document.getCharsSequence().subSequence(startOffset, endOffset)).toString().trim();
        return propertyName.isEmpty() ? null : propertyName;
    }

    private void setPropertiesFileSelectionFromStructureView(Editor propertiesFileEditor) {
        String selectedPropertyName = this.getSelectedPropertyName();
        if (selectedPropertyName == null) {
            return;
        }
        Document document = propertiesFileEditor.getDocument();
        for (int i = 0; i < document.getLineCount(); ++i) {
            String propertyName = ResourceBundleEditor.getPropertyName(document, i);
            if (!selectedPropertyName.equals(propertyName)) continue;
            propertiesFileEditor.getCaretModel().moveToLogicalPosition(new LogicalPosition(i, 0));
            return;
        }
    }

    private static ResourceBundleEditorViewElement getSelectedElement(DefaultMutableTreeNode node) {
        Object userObject = node.getUserObject();
        if (!(userObject instanceof AbstractTreeNode)) {
            return null;
        }
        Object value = ((AbstractTreeNode)userObject).getValue();
        return value instanceof ResourceBundleEditorViewElement ? (ResourceBundleEditorViewElement)value : null;
    }

    private void writeEditorPropertyValue(Editor editor, final PropertiesFile propertiesFile, String propertyName) {
        String currentSelectedProperty;
        final String currentValue = editor.getDocument().getText();
        String string = currentSelectedProperty = propertyName == null ? this.getSelectedPropertyName() : propertyName;
        if (currentSelectedProperty == null) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                WriteCommandAction.runWriteCommandAction((Project)ResourceBundleEditor.this.myProject, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        IProperty property = propertiesFile.findPropertyByKey(currentSelectedProperty);
                        try {
                            if (property == null) {
                                ResourceBundleEditor.this.myPropertiesInsertDeleteManager.insertTranslation(currentSelectedProperty, currentValue, propertiesFile);
                            } else {
                                property.setValue(currentValue);
                            }
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                });
            }
        });
    }

    private void recreateEditorsPanel() {
        this.myValuesPanel.removeAll();
        this.myValuesPanel.setLayout(new CardLayout());
        if (!this.myProject.isOpen()) {
            return;
        }
        MyJPanel valuesPanelComponent = new MyJPanel(new GridBagLayout());
        this.myValuesPanel.add((Component)new JBScrollPane(valuesPanelComponent){

            public void updateUI() {
                super.updateUI();
                this.getViewport().setBackground(UIUtil.getPanelBackground());
            }
        }, VALUES);
        this.myValuesPanel.add((Component)this.myNoPropertySelectedPanel, NO_PROPERTY_SELECTED);
        List<PropertiesFile> propertiesFiles = this.myResourceBundle.getPropertiesFiles();
        GridBagConstraints gc = new GridBagConstraints(0, 0, 0, 0, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0);
        this.releaseAllEditors();
        this.myTitledPanels.clear();
        int y = 0;
        Editor previousEditor = null;
        Editor firstEditor = null;
        for (final PropertiesFile propertiesFile : propertiesFiles) {
            final Editor editor = this.createEditor();
            Editor oldEditor = this.myEditors.put(propertiesFile, editor);
            if (firstEditor == null) {
                firstEditor = editor;
            }
            if (previousEditor != null) {
                editor.putUserData(ChooseSubsequentPropertyValueEditorAction.PREV_EDITOR_KEY, (Object)previousEditor);
                previousEditor.putUserData(ChooseSubsequentPropertyValueEditorAction.NEXT_EDITOR_KEY, (Object)editor);
            }
            previousEditor = editor;
            if (oldEditor != null) {
                EditorFactory.getInstance().releaseEditor(oldEditor);
            }
            ((EditorEx)editor).addFocusListener(new FocusChangeListener(){

                public void focusGained(Editor editor2) {
                    ResourceBundleEditor.this.mySelectedEditor = editor2;
                }

                public void focusLost(Editor eventEditor) {
                    ResourceBundleEditor.this.writeEditorPropertyValue(editor, propertiesFile, null);
                }
            });
            gc.gridx = 0;
            gc.gridy = y++;
            gc.gridheight = 1;
            gc.gridwidth = 0;
            gc.weightx = 1.0;
            gc.weighty = 1.0;
            gc.anchor = 10;
            Locale locale = propertiesFile.getLocale();
            ArrayList<String> names = new ArrayList<String>();
            if (!Comparing.strEqual((String)locale.getDisplayLanguage(), null)) {
                names.add(locale.getDisplayLanguage());
            }
            if (!Comparing.strEqual((String)locale.getDisplayCountry(), null)) {
                names.add(locale.getDisplayCountry());
            }
            if (!Comparing.strEqual((String)locale.getDisplayVariant(), null)) {
                names.add(locale.getDisplayVariant());
            }
            String title = propertiesFile.getName();
            if (!names.isEmpty()) {
                title = title + " (" + StringUtil.join(names, (String)"/") + ")";
            }
            JPanel comp = new JPanel(new BorderLayout()){

                @Override
                public Dimension getPreferredSize() {
                    Insets insets = this.getBorder().getBorderInsets(this);
                    return new Dimension(100, editor.getLineHeight() * 4 + insets.top + insets.bottom);
                }
            };
            comp.add((Component)editor.getComponent(), "Center");
            comp.setBorder((Border)IdeBorderFactory.createTitledBorder((String)title, (boolean)true));
            this.myTitledPanels.put(propertiesFile, comp);
            valuesPanelComponent.add((Component)comp, gc);
        }
        if (previousEditor != null) {
            previousEditor.putUserData(ChooseSubsequentPropertyValueEditorAction.NEXT_EDITOR_KEY, firstEditor);
            firstEditor.putUserData(ChooseSubsequentPropertyValueEditorAction.PREV_EDITOR_KEY, previousEditor);
        }
        gc.gridx = 0;
        gc.gridy = y;
        gc.gridheight = 0;
        gc.gridwidth = 0;
        gc.weightx = 10.0;
        gc.weighty = 1.0;
        valuesPanelComponent.add((Component)new JPanel(), gc);
        this.selectionChanged();
        this.myValuesPanel.repaint();
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                ResourceBundleEditor.this.updateEditorsFromProperties();
            }
        });
    }

    public static String getPropertyEditorValue(IProperty property) {
        if (property == null) {
            return "";
        }
        String rawValue = property.getValue();
        return rawValue == null ? "" : PropertiesResourceBundleUtil.fromPropertyValueToValueEditor(rawValue);
    }

    private void updateEditorsFromProperties() {
        String propertyName = this.getSelectedPropertyName();
        ((CardLayout)this.myValuesPanel.getLayout()).show(this.myValuesPanel, propertyName == null ? NO_PROPERTY_SELECTED : VALUES);
        if (propertyName == null) {
            return;
        }
        for (PropertiesFile propertiesFile : this.myResourceBundle.getPropertiesFiles(this.myProject)) {
            EditorEx editor = (EditorEx)this.myEditors.get(propertiesFile);
            if (editor == null) continue;
            final IProperty property = propertiesFile.findPropertyByKey(propertyName);
            DocumentEx document = editor.getDocument();
            CommandProcessor.getInstance().executeCommand(null, new Runnable((Document)document, propertiesFile){
                final /* synthetic */ Document val$document;
                final /* synthetic */ PropertiesFile val$propertiesFile;
                {
                    this.val$document = document;
                    this.val$propertiesFile = propertiesFile;
                }

                @Override
                public void run() {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            UndoManagerImpl undoManager = (UndoManagerImpl)UndoManager.getInstance((Project)ResourceBundleEditor.this.myProject);
                            if (!undoManager.isActive() || !undoManager.isRedoInProgress() && !undoManager.isUndoInProgress()) {
                                ResourceBundleEditor.this.updateDocumentFromPropertyValue(ResourceBundleEditor.getPropertyEditorValue(property), val$document, val$propertiesFile);
                            }
                        }
                    });
                }
            }, "", (Object)this);
            JPanel titledPanel = this.myTitledPanels.get(propertiesFile);
            ((TitledBorder)titledPanel.getBorder()).setTitleColor((Color)(property == null ? JBColor.RED : UIUtil.getLabelTextForeground()));
            titledPanel.repaint();
        }
    }

    private void installPropertiesChangeListeners() {
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        if (this.myVfsListener != null) {
            assert (false);
            virtualFileManager.removeVirtualFileListener(this.myVfsListener);
        }
        this.myVfsListener = new VirtualFileAdapter(){

            public void fileCreated(VirtualFileEvent event) {
                if (PropertiesImplUtil.isPropertiesFile(event.getFile(), ResourceBundleEditor.this.myProject)) {
                    ResourceBundleEditor.this.recreateEditorsPanel();
                }
            }

            public void fileDeleted(VirtualFileEvent event) {
                for (PropertiesFile file : ResourceBundleEditor.this.myEditors.keySet()) {
                    if (!Comparing.equal((Object)file.getVirtualFile(), (Object)event.getFile())) continue;
                    ResourceBundleEditor.this.recreateEditorsPanel();
                    return;
                }
            }

            public void propertyChanged(VirtualFilePropertyEvent event) {
                if (PropertiesImplUtil.isPropertiesFile(event.getFile(), ResourceBundleEditor.this.myProject)) {
                    if ("name".equals(event.getPropertyName())) {
                        ResourceBundleEditor.this.recreateEditorsPanel();
                    } else {
                        ResourceBundleEditor.this.updateEditorsFromProperties();
                    }
                }
            }
        };
        virtualFileManager.addVirtualFileListener(this.myVfsListener, (Disposable)this);
        PsiTreeChangeAdapter psiTreeChangeAdapter = new PsiTreeChangeAdapter(){

            public void childAdded(PsiTreeChangeEvent event) {
                this.childrenChanged(event);
            }

            public void childRemoved(PsiTreeChangeEvent event) {
                this.childrenChanged(event);
            }

            private String getPropertyKey(PsiElement element) {
                if (!(element instanceof PropertyKeyImpl)) {
                    return null;
                }
                IProperty property = (IProperty)PsiTreeUtil.findFirstParent((PsiElement)element, (Condition)new Condition<PsiElement>(){

                    public boolean value(PsiElement element) {
                        return element instanceof IProperty;
                    }
                });
                return property == null ? null : property.getKey();
            }

            public void childReplaced(PsiTreeChangeEvent event) {
                String oldKey = this.getPropertyKey(event.getOldChild());
                if (oldKey == null || !oldKey.equals(ResourceBundleEditor.this.getSelectedPropertyName())) {
                    return;
                }
                String newKey = this.getPropertyKey(event.getNewChild());
                this.childrenChanged(event);
            }

            public void childMoved(PsiTreeChangeEvent event) {
                this.childrenChanged(event);
            }

            public void childrenChanged(PsiTreeChangeEvent event) {
                PsiFile file = event.getFile();
                PropertiesFile propertiesFile = PropertiesImplUtil.getPropertiesFile(file);
                if (propertiesFile == null) {
                    return;
                }
                if (!propertiesFile.getResourceBundle().equals(ResourceBundleEditor.this.myResourceBundle)) {
                    return;
                }
                ResourceBundleEditor.this.updateEditorsFromProperties();
            }
        };
        PsiManager.getInstance((Project)this.myProject).addPsiTreeChangeListener((PsiTreeChangeListener)psiTreeChangeAdapter, (Disposable)this);
    }

    private void selectionChanged() {
        this.myBackSlashPressed.clear();
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                ResourceBundleEditor.this.updateEditorsFromProperties();
            }
        });
    }

    private void updateDocumentFromPropertyValue(String value, Document document, PropertiesFile propertiesFile) {
        String text = value;
        if (this.myBackSlashPressed.contains(propertiesFile)) {
            text = text + "\\";
        }
        document.putUserData(UndoConstants.DONT_RECORD_UNDO, (Object)Boolean.TRUE);
        document.replaceString(0, document.getTextLength(), (CharSequence)text);
        document.putUserData(UndoConstants.DONT_RECORD_UNDO, (Object)Boolean.FALSE);
    }

    private Collection<DefaultMutableTreeNode> getSelectedNodes() {
        if (!this.isValid()) {
            return Collections.emptyList();
        }
        JTree tree = this.myStructureViewComponent.getTree();
        if (tree == null) {
            return Collections.emptyList();
        }
        Object[] selected = tree.getSelectionModel().getSelectionPaths();
        if (selected == null || selected.length == 0) {
            return Collections.emptyList();
        }
        return ContainerUtil.map((Object[])selected, (Function)new Function<TreePath, DefaultMutableTreeNode>(){

            public DefaultMutableTreeNode fun(TreePath treePath) {
                return (DefaultMutableTreeNode)treePath.getLastPathComponent();
            }
        });
    }

    private String getSelectedPropertyName() {
        IProperty selectedProperty = this.getSelectedProperty();
        return selectedProperty == null ? null : selectedProperty.getName();
    }

    private IProperty getSelectedProperty() {
        Collection<DefaultMutableTreeNode> selectedNode = this.getSelectedNodes();
        if (selectedNode.isEmpty()) {
            return null;
        }
        ResourceBundleEditorViewElement element = ResourceBundleEditor.getSelectedElement((DefaultMutableTreeNode)ContainerUtil.getFirstItem(selectedNode));
        return element instanceof ResourceBundlePropertyStructureViewElement ? ((ResourceBundlePropertyStructureViewElement)element).getProperty() : null;
    }

    public Collection<ResourceBundleEditorViewElement> getSelectedElements() {
        Collection<DefaultMutableTreeNode> selectedNodes = this.getSelectedNodes();
        return ContainerUtil.mapNotNull(selectedNodes, (Function)new NullableFunction<DefaultMutableTreeNode, ResourceBundleEditorViewElement>(){

            public ResourceBundleEditorViewElement fun(DefaultMutableTreeNode selectedNode) {
                Object userObject = selectedNode.getUserObject();
                if (!(userObject instanceof AbstractTreeNode)) {
                    return null;
                }
                Object value = ((AbstractTreeNode)userObject).getValue();
                return value instanceof ResourceBundleEditorViewElement ? (ResourceBundleEditorViewElement)value : null;
            }
        });
    }

    public ResourceBundleEditorViewElement getSelectedElementIfOnlyOne() {
        Collection<ResourceBundleEditorViewElement> selectedElements = this.getSelectedElements();
        return selectedElements.size() == 1 ? (ResourceBundleEditorViewElement)ContainerUtil.getFirstItem(selectedElements) : null;
    }

    public JComponent getComponent() {
        return this.myDataProviderPanel;
    }

    private Object getData(String dataId) {
        if (SelectInContext.DATA_KEY.is(dataId)) {
            return new SelectInContext(){

                public Project getProject() {
                    return ResourceBundleEditor.this.myProject;
                }

                public VirtualFile getVirtualFile() {
                    VirtualFile virtualFile;
                    PropertiesFile selectedFile = ResourceBundleEditor.this.getSelectedPropertiesFile();
                    VirtualFile virtualFile2 = virtualFile = selectedFile == null ? null : selectedFile.getVirtualFile();
                    assert (virtualFile != null);
                    return virtualFile;
                }

                public Object getSelectorInFile() {
                    return ResourceBundleEditor.this.getSelectedPropertiesFile();
                }

                public FileEditorProvider getFileEditorProvider() {
                    final PropertiesFile selectedPropertiesFile = ResourceBundleEditor.this.getSelectedPropertiesFile();
                    if (selectedPropertiesFile == null) {
                        return null;
                    }
                    return new FileEditorProvider(){

                        public FileEditor openFileEditor() {
                            VirtualFile file = selectedPropertiesFile.getVirtualFile();
                            if (file == null) {
                                return null;
                            }
                            return FileEditorManager.getInstance((Project)this.getProject()).openFile(file, false)[0];
                        }
                    };
                }
            };
        }
        return null;
    }

    private PropertiesFile getSelectedPropertiesFile() {
        if (this.mySelectedEditor == null) {
            return null;
        }
        PropertiesFile selectedFile = null;
        for (Map.Entry<PropertiesFile, Editor> entry : this.myEditors.entrySet()) {
            Editor editor = entry.getValue();
            if (editor != this.mySelectedEditor) continue;
            selectedFile = entry.getKey();
            break;
        }
        return selectedFile;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myStructureViewPanel;
    }

    public String getName() {
        return "Resource Bundle";
    }

    public ResourceBundleEditorState getState(FileEditorStateLevel level) {
        return new ResourceBundleEditorState(this.getSelectedPropertyName());
    }

    public void selectProperty(String propertyName) {
        if (propertyName != null) {
            this.setStructureViewSelection(propertyName);
        }
    }

    public void setState(FileEditorState state) {
        this.selectProperty(((ResourceBundleEditorState)state).getPropertyName());
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return !this.myDisposed && !this.myProject.isDisposed();
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }

    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
        if (this.mySelectedEditor != null) {
            for (Map.Entry<PropertiesFile, Editor> entry : this.myEditors.entrySet()) {
                if (!this.mySelectedEditor.equals(entry.getValue())) continue;
                this.writeEditorPropertyValue(this.mySelectedEditor, entry.getKey(), null);
            }
        }
        VirtualFileManager.getInstance().removeVirtualFileListener(this.myVfsListener);
        this.myDisposed = true;
        Disposer.dispose((Disposable)this.myStructureViewComponent);
        this.releaseAllEditors();
    }

    private void releaseAllEditors() {
        for (Editor editor : this.myEditors.values()) {
            if (editor.isDisposed()) continue;
            EditorFactory.getInstance().releaseEditor(editor);
        }
        this.myEditors.clear();
    }

    private Editor createEditor() {
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document document = editorFactory.createDocument((CharSequence)"");
        EditorEx editor = (EditorEx)editorFactory.createEditor(document);
        ResourceBundleEditor.reinitSettings(editor);
        editor.putUserData(RESOURCE_BUNDLE_EDITOR_KEY, (Object)this);
        return editor;
    }

    private static void reinitSettings(EditorEx editor) {
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        editor.setColorsScheme(scheme);
        EditorSettings settings = editor.getSettings();
        settings.setLineNumbersShown(false);
        settings.setWhitespacesShown(false);
        settings.setLineMarkerAreaShown(false);
        settings.setIndentGuidesShown(false);
        settings.setFoldingOutlineShown(false);
        settings.setAdditionalColumnsCount(0);
        settings.setAdditionalLinesCount(0);
        settings.setRightMarginShown(true);
        settings.setRightMargin(60);
        settings.setVirtualSpace(false);
        editor.setHighlighter((EditorHighlighter)new LexerEditorHighlighter((SyntaxHighlighter)new PropertiesValueHighlighter(), scheme));
        editor.setVerticalScrollbarVisible(true);
    }

    private class MyJPanel
    extends JPanel
    implements Scrollable {
        private MyJPanel(LayoutManager layout) {
            super(layout);
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            Editor editor = (Editor)ResourceBundleEditor.this.myEditors.values().iterator().next();
            return editor.getLineHeight() * 4;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return visibleRect.height;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }

    private class DataProviderPanel
    extends JPanel
    implements DataProvider {
        private DataProviderPanel(JPanel panel) {
            super(new BorderLayout());
            this.add((Component)panel, "Center");
        }

        public Object getData(String dataId) {
            return ResourceBundleEditor.this.getData(dataId);
        }
    }

    public static class ResourceBundleEditorState
    implements FileEditorState {
        private final String myPropertyName;

        public ResourceBundleEditorState(String propertyName) {
            this.myPropertyName = propertyName;
        }

        public boolean canBeMergedWith(FileEditorState otherState, FileEditorStateLevel level) {
            return false;
        }

        public String getPropertyName() {
            return this.myPropertyName;
        }
    }
}

