/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.ide.presentation.Presentation;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@Presentation(icon="AllIcons.Nodes.ResourceBundle")
public class ResourceBundleAsVirtualFile
extends VirtualFile {
    private final ResourceBundle myResourceBundle;

    public ResourceBundleAsVirtualFile(ResourceBundle resourceBundle) {
        this.myResourceBundle = resourceBundle;
    }

    public ResourceBundle getResourceBundle() {
        return this.myResourceBundle;
    }

    public VirtualFileSystem getFileSystem() {
        return LocalFileSystem.getInstance();
    }

    public String getPath() {
        return this.getName();
    }

    public String getName() {
        return this.myResourceBundle.getBaseName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ResourceBundleAsVirtualFile resourceBundleAsVirtualFile = (ResourceBundleAsVirtualFile)((Object)o);
        return this.myResourceBundle.equals(resourceBundleAsVirtualFile.myResourceBundle);
    }

    public int hashCode() {
        return this.myResourceBundle.hashCode();
    }

    public void rename(Object requestor, String newName) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean isWritable() {
        return true;
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public VirtualFile getParent() {
        return this.myResourceBundle.getBaseDirectory();
    }

    public VirtualFile[] getChildren() {
        return EMPTY_ARRAY;
    }

    public VirtualFile createChildDirectory(Object requestor, String name) throws IOException {
        throw new UnsupportedOperationException();
    }

    public VirtualFile createChildData(Object requestor, String name) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void delete(Object requestor) throws IOException {
    }

    public void move(Object requestor, VirtualFile newParent) throws IOException {
    }

    public InputStream getInputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        throw new UnsupportedOperationException();
    }

    public byte[] contentsToByteArray() throws IOException {
        throw new UnsupportedOperationException();
    }

    public long getModificationStamp() {
        return 0L;
    }

    public long getTimeStamp() {
        return 0L;
    }

    public long getLength() {
        return 0L;
    }

    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
    }
}

