/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.ResourceBundleEditor;
import com.intellij.lang.properties.editor.ResourceBundleEditorViewElement;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class GotoPropertyDeclarationsProvider
extends GotoRelatedProvider {
    public List<? extends GotoRelatedItem> getItems(DataContext context) {
        FileEditor editor = (FileEditor)PlatformDataKeys.FILE_EDITOR.getData(context);
        if (!(editor instanceof ResourceBundleEditor)) {
            return Collections.emptyList();
        }
        ResourceBundleEditor resourceBundleEditor = (ResourceBundleEditor)editor;
        Collection<ResourceBundleEditorViewElement> elements = resourceBundleEditor.getSelectedElements();
        if (elements.size() != 1) {
            return Collections.emptyList();
        }
        PsiElement[] psiElements = ((ResourceBundleEditorViewElement)ContainerUtil.getFirstItem(elements)).getPsiElements();
        if (psiElements.length != 1 || !(psiElements[0] instanceof Property)) {
            return Collections.emptyList();
        }
        Property property = (Property)psiElements[0];
        final String propertyKey = property.getKey();
        PropertiesFile file = PropertiesImplUtil.getPropertiesFile(property.getContainingFile());
        assert (file != null);
        ResourceBundle resourceBundle = file.getResourceBundle();
        return ContainerUtil.mapNotNull(resourceBundle.getPropertiesFiles(), (Function)new NullableFunction<PropertiesFile, GotoRelatedItem>(){

            public GotoRelatedItem fun(PropertiesFile f) {
                IProperty foundProperty = f.findPropertyByKey(propertyKey);
                return foundProperty == null ? null : new GotoRelatedItem(foundProperty.getPsiElement(), "Property Declarations");
            }
        });
    }
}

