/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.lang.properties.BundleNameEvaluator;
import com.intellij.lang.properties.PropertiesFileProcessor;
import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.lang.properties.ResourceBundleManager;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolvingHint;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class ResourceBundleReference
extends PsiReferenceBase<PsiElement>
implements PsiPolyVariantReference,
BundleNameEvaluator,
ResolvingHint {
    private static final Function<PropertiesFile, PsiElement> PROPERTIES_FILE_PSI_ELEMENT_FUNCTION = new Function<PropertiesFile, PsiElement>(){

        public PsiElement fun(PropertiesFile propertiesFile) {
            return propertiesFile.getContainingFile();
        }
    };
    private final String myBundleName = StringUtil.replaceChar((String)this.getValue(), (char)'/', (char)'.');

    public ResourceBundleReference(PsiElement element) {
        this(element, false);
    }

    public ResourceBundleReference(PsiElement element, boolean soft) {
        super(element, soft);
    }

    public boolean canResolveTo(Class<? extends PsiElement> elementClass) {
        return ReflectionUtil.isAssignable(PsiFile.class, elementClass);
    }

    public PsiElement resolve() {
        ResolveResult[] resolveResults = this.multiResolve(false);
        return resolveResults.length == 1 ? resolveResults[0].getElement() : null;
    }

    public ResolveResult[] multiResolve(boolean incompleteCode) {
        PropertiesReferenceManager referenceManager = PropertiesReferenceManager.getInstance(this.myElement.getProject());
        List<PropertiesFile> propertiesFiles = referenceManager.findPropertiesFiles(this.myElement.getResolveScope(), this.myBundleName, this);
        return PsiElementResolveResult.createResults((Collection)ContainerUtil.map(propertiesFiles, PROPERTIES_FILE_PSI_ELEMENT_FUNCTION));
    }

    public String getCanonicalText() {
        return this.myBundleName;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        char packageDelimiter;
        String currentValue;
        int index;
        if (newElementName.endsWith(".properties")) {
            newElementName = newElementName.substring(0, newElementName.lastIndexOf(".properties"));
        }
        if ((index = (currentValue = this.getValue()).lastIndexOf(packageDelimiter = this.getPackageDelimiter())) != -1) {
            newElementName = currentValue.substring(0, index) + packageDelimiter + newElementName;
        }
        return super.handleElementRename(newElementName);
    }

    private char getPackageDelimiter() {
        return StringUtil.indexOf((CharSequence)this.getValue(), (char)'/') != -1 ? (char)'/' : '.';
    }

    public PsiElement bindToElement(PsiElement element) throws IncorrectOperationException {
        if (!(element instanceof PropertiesFile)) {
            throw new IncorrectOperationException();
        }
        String name = ResourceBundleManager.getInstance(element.getProject()).getFullName((PropertiesFile)element);
        return super.handleElementRename(name);
    }

    public boolean isReferenceTo(PsiElement element) {
        String name;
        return element instanceof PropertiesFile && (name = ResourceBundleManager.getInstance(element.getProject()).getFullName((PropertiesFile)element)) != null && name.equals(this.myBundleName);
    }

    public Object[] getVariants() {
        final ProjectFileIndex projectFileIndex = ProjectFileIndex.SERVICE.getInstance((Project)this.getElement().getProject());
        PropertiesReferenceManager referenceManager = PropertiesReferenceManager.getInstance(this.getElement().getProject());
        final HashSet bundleNames = new HashSet();
        SmartList variants = new SmartList();
        PropertiesFileProcessor processor = new PropertiesFileProcessor((List)variants){
            final /* synthetic */ List val$variants;
            {
                this.val$variants = list;
            }

            @Override
            public boolean process(String baseName, PropertiesFile propertiesFile) {
                if (!bundleNames.add(baseName)) {
                    return true;
                }
                LookupElementBuilder builder = LookupElementBuilder.create((String)baseName).withIcon(AllIcons.Nodes.ResourceBundle);
                boolean isInContent = projectFileIndex.isInContent(propertiesFile.getVirtualFile());
                this.val$variants.add(isInContent ? PrioritizedLookupElement.withPriority((LookupElement)builder, (double)Double.MAX_VALUE) : builder);
                return true;
            }
        };
        referenceManager.processPropertiesFiles(this.myElement.getResolveScope(), processor, this);
        return variants.toArray(new LookupElement[variants.size()]);
    }

    @Override
    public String evaluateBundleName(PsiFile psiFile) {
        return BundleNameEvaluator.DEFAULT.evaluateBundleName(psiFile);
    }
}

