/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.properties.CustomResourceBundle;
import com.intellij.lang.properties.CustomResourceBundleState;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.ResourceBundleManagerState;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;

@State(name="ResourceBundleManager", storages={@Storage(file="$PROJECT_FILE$"), @Storage(file="$PROJECT_CONFIG_DIR$/resourceBundles.xml", scheme=StorageScheme.DIRECTORY_BASED)})
public class ResourceBundleManager
implements PersistentStateComponent<ResourceBundleManagerState> {
    private static final Logger LOG = Logger.getInstance(ResourceBundleManager.class);
    public static final Locale DEFAULT_LOCALE = new Locale("", "", "");
    private ResourceBundleManagerState myState = new ResourceBundleManagerState();

    public ResourceBundleManager(PsiManager manager) {
        manager.addPsiTreeChangeListener((PsiTreeChangeListener)new PsiTreeChangeAdapter(){

            public void childMoved(PsiTreeChangeEvent event) {
                PsiElement child = event.getChild();
                if (!(child instanceof PsiFile)) {
                    return;
                }
                final PropertiesFile propertiesFile = PropertiesImplUtil.getPropertiesFile((PsiFile)child);
                if (propertiesFile == null) {
                    return;
                }
                final String oldParentUrl = this.getUrl(event.getOldParent());
                if (oldParentUrl == null) {
                    return;
                }
                final String newParentUrl = this.getUrl(event.getNewParent());
                if (newParentUrl == null) {
                    return;
                }
                NotNullLazyValue<Pair<String, String>> oldAndNewUrls = new NotNullLazyValue<Pair<String, String>>(){

                    protected Pair<String, String> compute() {
                        String newUrl = propertiesFile.getVirtualFile().getUrl();
                        return Pair.create((Object)(oldParentUrl + newUrl.substring(newParentUrl.length())), (Object)newUrl);
                    }
                };
                if (!ResourceBundleManager.this.myState.getDissociatedFiles().isEmpty() && ResourceBundleManager.this.myState.getDissociatedFiles().remove(((Pair)oldAndNewUrls.getValue()).getFirst())) {
                    ResourceBundleManager.this.myState.getDissociatedFiles().add((String)((Pair)oldAndNewUrls.getValue()).getSecond());
                }
                for (CustomResourceBundleState customResourceBundleState : ResourceBundleManager.this.myState.getCustomResourceBundles()) {
                    if (!customResourceBundleState.getFileUrls().remove(((Pair)oldAndNewUrls.getValue()).getFirst())) continue;
                    customResourceBundleState.getFileUrls().add((String)((Pair)oldAndNewUrls.getValue()).getSecond());
                    break;
                }
            }

            private String getUrl(PsiElement element) {
                return !(element instanceof PsiDirectory) ? null : ((PsiDirectory)element).getVirtualFile().getUrl();
            }

            public void beforeChildRemoval(PsiTreeChangeEvent event) {
                PsiElement child = event.getChild();
                if (!(child instanceof PsiFile)) {
                    return;
                }
                PropertiesFile file = PropertiesImplUtil.getPropertiesFile((PsiFile)child);
                if (file == null) {
                    return;
                }
                final VirtualFile virtualFile = file.getVirtualFile();
                NotNullLazyValue<String> url = new NotNullLazyValue<String>(){

                    protected String compute() {
                        return virtualFile.getUrl();
                    }
                };
                if (!ResourceBundleManager.this.myState.getDissociatedFiles().isEmpty()) {
                    ResourceBundleManager.this.myState.getDissociatedFiles().remove(url.getValue());
                }
                for (CustomResourceBundleState customResourceBundleState : ResourceBundleManager.this.myState.getCustomResourceBundles()) {
                    Set<String> urls = customResourceBundleState.getFileUrls();
                    if (!urls.remove(url.getValue())) continue;
                    if (urls.size() >= 2) break;
                    ResourceBundleManager.this.myState.getCustomResourceBundles().remove(customResourceBundleState);
                    break;
                }
            }
        });
    }

    public static ResourceBundleManager getInstance(Project project) {
        return (ResourceBundleManager)ServiceManager.getService((Project)project, ResourceBundleManager.class);
    }

    public String getFullName(final PropertiesFile propertiesFile) {
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new NullableComputable<String>(){

            public String compute() {
                PsiDirectory directory = propertiesFile.getParent();
                String packageQualifiedName = PropertiesUtil.getPackageQualifiedName(directory);
                if (packageQualifiedName == null) {
                    return null;
                }
                StringBuilder qName = new StringBuilder(packageQualifiedName);
                if (qName.length() > 0) {
                    qName.append(".");
                }
                qName.append(ResourceBundleManager.this.getBaseName(propertiesFile.getContainingFile()));
                return qName.toString();
            }
        });
    }

    public Locale getLocale(VirtualFile propertiesFile) {
        String customResourceBundleName = this.getCustomResourceBundleName(propertiesFile);
        String name = propertiesFile.getName();
        if (!StringUtil.containsChar((String)name, (char)'_')) {
            return DEFAULT_LOCALE;
        }
        if (customResourceBundleName != null) {
            name = name.substring(customResourceBundleName.length());
        }
        return ResourceBundleManager.extractLocale(name);
    }

    public static Locale extractLocale(String suffix) {
        String rawLocale;
        String[] splittedRawLocale;
        Matcher matcher = PropertiesUtil.LOCALE_PATTERN.matcher(suffix);
        if (matcher.find() && (splittedRawLocale = (rawLocale = matcher.group(1)).split("_")).length > 1 && splittedRawLocale[1].length() >= 2) {
            String language = splittedRawLocale[1];
            String country = splittedRawLocale.length > 2 ? splittedRawLocale[2] : "";
            String variant = splittedRawLocale.length > 3 ? splittedRawLocale[3] : "";
            return new Locale(language, country, variant);
        }
        return DEFAULT_LOCALE;
    }

    public String getBaseName(PsiFile file) {
        return this.getBaseName(file.getVirtualFile());
    }

    private String getBaseName(VirtualFile file) {
        CustomResourceBundleState customResourceBundle = this.getCustomResourceBundleState(file);
        if (customResourceBundle != null) {
            return customResourceBundle.getBaseName();
        }
        if (this.isDefaultDissociated(file)) {
            return file.getNameWithoutExtension();
        }
        return PropertiesUtil.getDefaultBaseName(file);
    }

    public void dissociateResourceBundle(ResourceBundle resourceBundle) {
        if (resourceBundle instanceof CustomResourceBundle) {
            CustomResourceBundleState state = this.getCustomResourceBundleState(resourceBundle.getDefaultPropertiesFile().getVirtualFile());
            LOG.assertTrue(state != null);
            this.myState.getCustomResourceBundles().remove(state);
        } else {
            for (PropertiesFile propertiesFile : resourceBundle.getPropertiesFiles()) {
                VirtualFile file = propertiesFile.getContainingFile().getVirtualFile();
                this.myState.getDissociatedFiles().add(file.getUrl());
            }
        }
    }

    public void combineToResourceBundle(List<PropertiesFile> propertiesFiles, String baseName) {
        this.myState.getCustomResourceBundles().add(new CustomResourceBundleState().addAll(ContainerUtil.map(propertiesFiles, (Function)new Function<PropertiesFile, String>(){

            public String fun(PropertiesFile file) {
                return file.getVirtualFile().getUrl();
            }
        })).setBaseName(baseName));
    }

    public CustomResourceBundle getCustomResourceBundle(PropertiesFile file) {
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        CustomResourceBundleState state = this.getCustomResourceBundleState(virtualFile);
        return state == null ? null : CustomResourceBundle.fromState(state, file.getProject());
    }

    public boolean isDefaultDissociated(VirtualFile virtualFile) {
        if (this.myState.getDissociatedFiles().isEmpty() && this.myState.getCustomResourceBundles().isEmpty()) {
            return false;
        }
        String url = virtualFile.getUrl();
        return this.myState.getDissociatedFiles().contains(url) || this.getCustomResourceBundleState(virtualFile) != null;
    }

    private String getCustomResourceBundleName(VirtualFile virtualFile) {
        CustomResourceBundleState customResourceBundle = this.getCustomResourceBundleState(virtualFile);
        return customResourceBundle == null ? null : customResourceBundle.getBaseName();
    }

    private CustomResourceBundleState getCustomResourceBundleState(VirtualFile virtualFile) {
        if (this.myState.getCustomResourceBundles().isEmpty()) {
            return null;
        }
        String url = virtualFile.getUrl();
        for (CustomResourceBundleState customResourceBundleState : this.myState.getCustomResourceBundles()) {
            if (!customResourceBundleState.getFileUrls().contains(url)) continue;
            return customResourceBundleState;
        }
        return null;
    }

    public ResourceBundleManagerState getState() {
        return this.myState.isEmpty() ? null : this.myState;
    }

    public void loadState(ResourceBundleManagerState state) {
        this.myState = state.removeNonExistentFiles();
    }
}

