/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;

public class RemovePropertyFix
implements IntentionAction {
    private final Property myProperty;

    public RemovePropertyFix(Property origProperty) {
        this.myProperty = origProperty;
    }

    public String getText() {
        return PropertiesBundle.message("remove.property.intention.text", new Object[0]);
    }

    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(Project project, Editor editor, PsiFile file) {
        return file.isValid() && this.myProperty != null && this.myProperty.isValid() && this.myProperty.getManager().isInProject((PsiElement)this.myProperty);
    }

    public void invoke(Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        this.myProperty.delete();
    }

    public boolean startInWriteAction() {
        return true;
    }
}

