/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.properties.CustomResourceBundle;
import com.intellij.lang.properties.EmptyResourceBundle;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.ResourceBundleImpl;
import com.intellij.lang.properties.ResourceBundleManager;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.PropertyKeyIndex;
import com.intellij.lang.properties.xml.XmlPropertiesFileImpl;
import com.intellij.lang.properties.xml.XmlPropertiesIndex;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class PropertiesImplUtil
extends PropertiesUtil {
    public static ResourceBundle getResourceBundle(PropertiesFile representative) {
        final PsiFile containingFile = representative.getContainingFile();
        if (!containingFile.isValid()) {
            return EmptyResourceBundle.getInstance();
        }
        ResourceBundleManager manager = ResourceBundleManager.getInstance(representative.getProject());
        CustomResourceBundle customResourceBundle = manager.getCustomResourceBundle(representative);
        if (customResourceBundle != null) {
            return customResourceBundle;
        }
        VirtualFile virtualFile = representative.getVirtualFile();
        if (virtualFile == null) {
            return EmptyResourceBundle.getInstance();
        }
        if (manager.isDefaultDissociated(virtualFile)) {
            return new ResourceBundleImpl(representative);
        }
        String baseName = manager.getBaseName(containingFile);
        PsiDirectory directory = (PsiDirectory)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiDirectory>(){

            public PsiDirectory compute() {
                return containingFile.getContainingDirectory();
            }
        });
        if (directory == null) {
            return EmptyResourceBundle.getInstance();
        }
        ResourceBundle bundle = PropertiesImplUtil.getResourceBundle(baseName, directory);
        return bundle == null ? new ResourceBundleImpl(representative) : bundle;
    }

    private static ResourceBundle getResourceBundle(String baseName, final PsiDirectory baseDirectory) {
        PsiFile[] psiFiles;
        PropertiesFile defaultPropertiesFile = null;
        ResourceBundleManager bundleBaseNameManager = ResourceBundleManager.getInstance(baseDirectory.getProject());
        for (PsiFile psiFile : psiFiles = (PsiFile[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiFile[]>(){

            public PsiFile[] compute() {
                return baseDirectory.getFiles();
            }
        })) {
            PropertiesFile propertiesFile;
            if (!baseName.equals(bundleBaseNameManager.getBaseName(psiFile)) || (propertiesFile = PropertiesImplUtil.getPropertiesFile(psiFile)) == null) continue;
            if (defaultPropertiesFile == null) {
                defaultPropertiesFile = propertiesFile;
                continue;
            }
            int nameDiff = FileUtil.getNameWithoutExtension((String)defaultPropertiesFile.getName()).compareTo(FileUtil.getNameWithoutExtension((String)propertiesFile.getName()));
            if (nameDiff > 0) {
                defaultPropertiesFile = propertiesFile;
                continue;
            }
            if (nameDiff != 0) continue;
            return null;
        }
        if (defaultPropertiesFile == null) {
            return null;
        }
        return new ResourceBundleImpl(defaultPropertiesFile);
    }

    public static boolean isPropertiesFile(VirtualFile file, Project project) {
        return PropertiesImplUtil.getPropertiesFile(PsiManager.getInstance((Project)project).findFile(file)) != null;
    }

    public static boolean isPropertiesFile(PsiFile file) {
        return PropertiesImplUtil.getPropertiesFile(file) != null;
    }

    public static PropertiesFile getPropertiesFile(PsiFile file) {
        if (file == null) {
            return null;
        }
        return file instanceof PropertiesFile ? (PropertiesFile)file : XmlPropertiesFileImpl.getPropertiesFile(file);
    }

    public static List<IProperty> findPropertiesByKey(final Project project, final String key) {
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        final ArrayList<IProperty> properties = new ArrayList<IProperty>(PropertyKeyIndex.getInstance().get(key, project, scope));
        final HashSet files = new HashSet();
        FileBasedIndex.getInstance().processValues(XmlPropertiesIndex.NAME, (Object)new XmlPropertiesIndex.Key(key), null, (FileBasedIndex.ValueProcessor)new FileBasedIndex.ValueProcessor<String>(){

            public boolean process(VirtualFile file, String value) {
                PsiFile psiFile;
                PropertiesFile propertiesFile;
                if (files.add(file) && (propertiesFile = XmlPropertiesFileImpl.getPropertiesFile(psiFile = PsiManager.getInstance((Project)project).findFile(file))) != null) {
                    properties.addAll(propertiesFile.findPropertiesByKey(key));
                }
                return false;
            }
        }, scope);
        return properties;
    }

    public static ResourceBundle createByUrl(String url, Project project) {
        int idx = url.lastIndexOf(47);
        if (idx == -1) {
            return null;
        }
        String baseDirectoryName = url.substring(0, idx);
        String baseName = url.substring(idx + 1);
        VirtualFile baseDirectoryVirtualFile = VirtualFileManager.getInstance().findFileByUrl(baseDirectoryName);
        if (baseDirectoryVirtualFile == null) {
            return null;
        }
        PsiDirectory baseDirectory = PsiManager.getInstance((Project)project).findDirectory(baseDirectoryVirtualFile);
        if (baseDirectory == null) {
            return null;
        }
        return PropertiesImplUtil.getResourceBundle(baseName, baseDirectory);
    }

    public static boolean isAlphaSorted(Collection<? extends IProperty> properties) {
        String previousKey = null;
        for (IProperty iProperty : properties) {
            String key = iProperty.getKey();
            if (key == null) {
                return false;
            }
            if (previousKey != null && previousKey.compareTo(key) > 0) {
                return false;
            }
            previousKey = key;
        }
        return true;
    }
}

