/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.util;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.lib.cvsclient.util.IStringPattern;

public final class SimpleStringPattern
implements IStringPattern {
    private static final char MATCH_EACH = '*';
    private static final char MATCH_ONE = '?';
    private final List<SubPattern> subPatterns = new ArrayList<SubPattern>();

    public SimpleStringPattern(String definition) {
        this.splitInSubPattern(definition);
    }

    @Override
    public boolean doesMatch(String string) {
        int index = 0;
        SubPattern subPattern = null;
        int length = this.subPatterns.size();
        for (int i = 0; i < length; ++i) {
            subPattern = this.subPatterns.get(i);
            index = subPattern.doesMatch(string, index);
            if (index >= 0) continue;
            return false;
        }
        if (index == string.length()) {
            return true;
        }
        if (subPattern == null) {
            return false;
        }
        return subPattern.checkEnding(string);
    }

    private void splitInSubPattern(String definition) {
        int prevSubPattern = 32;
        int prevIndex = 0;
        int index = 0;
        while (index >= 0) {
            String match;
            prevIndex = index;
            if ((index = definition.indexOf(42, prevIndex)) >= 0) {
                match = definition.substring(prevIndex, index);
                this.addSubPattern(match, (char)prevSubPattern);
                prevSubPattern = 42;
                ++index;
                continue;
            }
            index = definition.indexOf(63, prevIndex);
            if (index < 0) continue;
            match = definition.substring(prevIndex, index);
            this.addSubPattern(match, (char)prevSubPattern);
            prevSubPattern = 63;
            ++index;
        }
        String match = definition.substring(prevIndex);
        this.addSubPattern(match, (char)prevSubPattern);
    }

    private void addSubPattern(String match, char subPatternMode) {
        SubPattern subPattern;
        switch (subPatternMode) {
            case '*': {
                subPattern = new MatchEachCharPattern(match);
                break;
            }
            case '?': {
                subPattern = new MatchOneCharPattern(match);
                break;
            }
            default: {
                subPattern = new MatchExactSubPattern(match);
            }
        }
        this.subPatterns.add(subPattern);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        int length = this.subPatterns.size();
        for (int i = 0; i < length; ++i) {
            SubPattern subPattern = this.subPatterns.get(i);
            buffer.append(subPattern.toString());
        }
        return buffer.toString();
    }

    private static final class MatchOneCharPattern
    extends MatchExactSubPattern {
        private MatchOneCharPattern(String match) {
            super(match);
        }

        @Override
        public int doesMatch(String string, int index) {
            if (string.length() < ++index) {
                return -1;
            }
            return super.doesMatch(string, index);
        }

        @Override
        public String toString() {
            return '?' + this.match;
        }
    }

    private static final class MatchEachCharPattern
    extends SubPattern {
        private MatchEachCharPattern(String match) {
            super(match);
        }

        @Override
        public int doesMatch(String string, int index) {
            int matchIndex = string.indexOf(this.match, index);
            if (matchIndex < 0) {
                return -1;
            }
            return matchIndex + this.match.length();
        }

        @Override
        public boolean checkEnding(String string) {
            return string.endsWith(this.match);
        }

        public String toString() {
            return '*' + this.match;
        }
    }

    private static class MatchExactSubPattern
    extends SubPattern {
        public MatchExactSubPattern(String match) {
            super(match);
        }

        @Override
        public int doesMatch(String string, int index) {
            if (!string.startsWith(this.match, index)) {
                return -1;
            }
            return index + this.match.length();
        }

        public String toString() {
            return this.match;
        }
    }

    private static abstract class SubPattern {
        protected final String match;

        protected SubPattern(String match) {
            this.match = match;
        }

        public abstract int doesMatch(String var1, int var2);

        public boolean checkEnding(String string) {
            return false;
        }
    }
}

