/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import org.netbeans.lib.cvsclient.JavaCvsSrcBundle;

public final class FileUtils {
    private static final String U_PREFIX = "u=";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File targetFile) throws IOException {
        if (sourceFile == null || targetFile == null) {
            throw new NullPointerException("sourceFile and targetFile must not be null");
        }
        File directory = targetFile.getParentFile();
        if (!directory.exists() && !directory.mkdirs()) {
            throw new IOException(JavaCvsSrcBundle.message("could.not.create.directory.error.message", directory));
        }
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(sourceFile));
            outputStream = new BufferedOutputStream(new FileOutputStream(targetFile));
            byte[] buffer = new byte[32768];
            int readBytes = inputStream.read(buffer);
            while (readBytes > 0) {
                outputStream.write(buffer, 0, readBytes);
                readBytes = inputStream.read(buffer);
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ex) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    public static String ensureLeadingSlash(String filePath) {
        if (filePath.startsWith("/")) {
            return filePath;
        }
        return '/' + filePath;
    }

    public static String removeLeadingSlash(String filePath) {
        if (filePath.startsWith("/")) {
            return filePath.substring(1);
        }
        return filePath;
    }

    public static String ensureTrailingSlash(String pathName) {
        if (pathName.endsWith("/")) {
            return pathName;
        }
        return pathName + '/';
    }

    public static String removeTrailingSlash(String pathName) {
        if (pathName.endsWith("/")) {
            return pathName.substring(0, pathName.length() - 1);
        }
        return pathName;
    }

    public static boolean isReadOnlyMode(String mode) {
        StringTokenizer tokenizer = new StringTokenizer(mode, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (!token.startsWith(U_PREFIX)) continue;
            return token.indexOf(119) < 0;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readLineFromFile(File file) throws IOException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            String string = reader.readLine();
            return string;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLine(File file, String line) throws IOException {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(file));
            writer.write(line);
            writer.newLine();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private FileUtils() {
    }
}

