/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.tag;

import java.io.IOException;
import org.netbeans.lib.cvsclient.IClientEnvironment;
import org.netbeans.lib.cvsclient.IRequestProcessor;
import org.netbeans.lib.cvsclient.command.AbstractCommand;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.ICvsFiles;
import org.netbeans.lib.cvsclient.command.IOCommandException;
import org.netbeans.lib.cvsclient.command.tag.TagParser;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.DualListener;
import org.netbeans.lib.cvsclient.event.ICvsListenerRegistry;
import org.netbeans.lib.cvsclient.event.IEventSender;
import org.netbeans.lib.cvsclient.progress.IProgressViewer;
import org.netbeans.lib.cvsclient.progress.RangeProgressViewer;
import org.netbeans.lib.cvsclient.progress.receiving.FileInfoAndMessageResponseProgressHandler;
import org.netbeans.lib.cvsclient.progress.sending.FileStateRequestsProgressHandler;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.request.Requests;

public final class TagCommand
extends AbstractCommand {
    public static final String EXAM_DIR_TAG = "server: Tagging ";
    public static final String EXAM_DIR_UNTAG = "server: Untagging ";
    private String tag;
    private boolean checkThatUnmodified;
    private boolean deleteTag;
    private boolean allowMoveDeleteBranchTag;
    private boolean makeBranchTag;
    private boolean overrideExistingTag;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(IRequestProcessor requestProcessor, IEventSender eventManager, ICvsListenerRegistry listenerRegistry, IClientEnvironment clientEnvironment, IProgressViewer progressViewer) throws CommandException, AuthenticationException {
        ICvsFiles cvsFiles;
        try {
            cvsFiles = this.scanFileSystem(clientEnvironment);
        }
        catch (IOException ex) {
            throw new IOCommandException(ex);
        }
        Requests requests = new Requests(CommandRequest.TAG, clientEnvironment);
        this.addFileRequests(cvsFiles, requests, clientEnvironment);
        requests.addArgumentRequest(this.isDeleteTag(), "-d");
        requests.addArgumentRequest(this.isMakeBranchTag(), "-b");
        requests.addArgumentRequest(this.isCheckThatUnmodified(), "-c");
        requests.addArgumentRequest(this.isOverrideExistingTag(), "-F");
        requests.addArgumentRequest(this.isAllowMoveDeleteBranchTag(), "-B");
        requests.addArgumentRequest(true, this.getTag());
        requests.addLocalPathDirectoryRequest();
        this.addArgumentRequests(requests);
        FileStateRequestsProgressHandler requestsProgressHandler = new FileStateRequestsProgressHandler(new RangeProgressViewer(progressViewer, 0.0, 0.5), cvsFiles);
        FileInfoAndMessageResponseProgressHandler responseProgressHandler = new FileInfoAndMessageResponseProgressHandler(new RangeProgressViewer(progressViewer, 0.5, 1.0), cvsFiles, this.isDeleteTag() ? EXAM_DIR_UNTAG : EXAM_DIR_TAG);
        TagParser tagParser = new TagParser(eventManager, clientEnvironment.getCvsFileSystem());
        DualListener listener = new DualListener(tagParser, responseProgressHandler);
        listener.registerListeners(listenerRegistry);
        try {
            boolean bl = requestProcessor.processRequests(requests, requestsProgressHandler);
            return bl;
        }
        finally {
            listener.unregisterListeners(listenerRegistry);
        }
    }

    @Override
    public String getCvsCommandLine() {
        StringBuffer cvsCommandLine = new StringBuffer("tag ");
        cvsCommandLine.append(this.getCvsArguments());
        if (this.getTag() != null) {
            cvsCommandLine.append(this.getTag());
            cvsCommandLine.append(" ");
        }
        this.appendFileArguments(cvsCommandLine);
        return cvsCommandLine.toString();
    }

    @Override
    public void resetCvsCommand() {
        super.resetCvsCommand();
        this.setRecursive(true);
        this.setCheckThatUnmodified(false);
        this.setDeleteTag(false);
        this.setAllowMoveDeleteBranchTag(false);
        this.setMakeBranchTag(false);
        this.setOverrideExistingTag(false);
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    private boolean isCheckThatUnmodified() {
        return this.checkThatUnmodified;
    }

    public void setCheckThatUnmodified(boolean checkThatUnmodified) {
        this.checkThatUnmodified = checkThatUnmodified;
    }

    private boolean isDeleteTag() {
        return this.deleteTag;
    }

    public void setDeleteTag(boolean deleteTag) {
        this.deleteTag = deleteTag;
    }

    public boolean isAllowMoveDeleteBranchTag() {
        return this.allowMoveDeleteBranchTag;
    }

    public void setAllowMoveDeleteBranchTag(boolean allowMoveDeleteBranchTag) {
        this.allowMoveDeleteBranchTag = allowMoveDeleteBranchTag;
    }

    private boolean isMakeBranchTag() {
        return this.makeBranchTag;
    }

    public void setMakeBranchTag(boolean makeBranchTag) {
        this.makeBranchTag = makeBranchTag;
    }

    private boolean isOverrideExistingTag() {
        return this.overrideExistingTag;
    }

    public void setOverrideExistingTag(boolean overrideExistingTag) {
        this.overrideExistingTag = overrideExistingTag;
    }

    private String getCvsArguments() {
        StringBuilder arguments = new StringBuilder();
        if (!this.isRecursive()) {
            arguments.append("-l ");
        }
        if (this.isDeleteTag()) {
            arguments.append("-d ");
        }
        if (this.isMakeBranchTag()) {
            arguments.append("-b ");
        }
        if (this.isCheckThatUnmodified()) {
            arguments.append("-c ");
        }
        if (this.isOverrideExistingTag()) {
            arguments.append("-F ");
        }
        if (this.isAllowMoveDeleteBranchTag()) {
            arguments.append("-B ");
        }
        return arguments.toString();
    }
}

