/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.status;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.lib.cvsclient.command.AbstractMessageParser;
import org.netbeans.lib.cvsclient.command.status.StatusInformation;
import org.netbeans.lib.cvsclient.event.IEventSender;
import org.netbeans.lib.cvsclient.file.AbstractFileObject;
import org.netbeans.lib.cvsclient.file.FileObject;
import org.netbeans.lib.cvsclient.file.FileStatus;
import org.netbeans.lib.cvsclient.file.ICvsFileSystem;
import org.netbeans.lib.cvsclient.util.BugLog;

final class StatusMessageParser
extends AbstractMessageParser {
    private static final String NO_REVISION_CONTROL_FILE = "No revision control file";
    private static final String SEPARATOR = "===================================================================";
    private static final String FILE = "File: ";
    private static final String STATUS = "\tStatus: ";
    private static final String NO_FILE = "no file ";
    private static final String WORK_REVISION = "   Working revision:\t";
    private static final String REPOSITORY_REVISION = "   Repository revision:\t";
    private static final String STICKY_TAG = "   Sticky Tag:";
    private static final String STICKY_DATE = "   Sticky Date:";
    private static final String STICKY_OPTIONS = "   Sticky Options:";
    private static final String EXISTING_TAGS = "   Existing Tags:";
    private static final String NO_TAGS = "   No Tags Exist";
    private static final String NO_ENTRY_FOR = "No entry for ";
    private static final String QUESTION_MARK = "? ";
    private final List fileObjects = new ArrayList();
    private final ICvsFileSystem cvsFileSystem;
    private final IEventSender eventSender;
    private StatusInformation statusInformation;
    private String relativeDirectory;
    private boolean beginning;
    private boolean readingTags;

    public StatusMessageParser(IEventSender eventSender, List fileObjects, ICvsFileSystem cvsFileSystem) {
        BugLog.getInstance().assertNotNull(eventSender);
        this.eventSender = eventSender;
        this.fileObjects.addAll(fileObjects);
        this.cvsFileSystem = cvsFileSystem;
        this.beginning = true;
    }

    @Override
    protected void outputDone() {
        if (this.statusInformation != null) {
            this.eventSender.notifyFileInfoListeners(this.statusInformation);
            this.statusInformation = null;
            this.beginning = true;
            this.readingTags = false;
        }
    }

    @Override
    public void parseLine(String line, boolean isErrorMessage) {
        if (this.readingTags) {
            if (line.startsWith(NO_TAGS)) {
                this.outputDone();
                return;
            }
            int bracket = line.indexOf(40);
            if (bracket > 0) {
                String tag = line.substring(0, bracket - 1).trim();
                String rev = line.substring(bracket + 1, line.length() - 1);
                if (this.statusInformation == null) {
                    this.statusInformation = new StatusInformation();
                }
                this.statusInformation.addExistingTag(tag, rev);
            } else {
                this.outputDone();
                return;
            }
        }
        if (isErrorMessage) {
            int index = line.indexOf("server: Examining ");
            if (index >= 0) {
                this.relativeDirectory = line.substring(index + "server: Examining ".length()).trim();
                this.beginning = true;
            }
            return;
        }
        if (this.beginning) {
            if (line.startsWith(QUESTION_MARK)) {
                File file = this.cvsFileSystem.getLocalFileSystem().getFile(line.substring(QUESTION_MARK.length()));
                this.statusInformation = new StatusInformation();
                this.statusInformation.setFile(file);
                this.statusInformation.setStatus(FileStatus.UNKNOWN);
                this.outputDone();
            }
            if (line.startsWith(FILE)) {
                int statusIndex = line.lastIndexOf(STATUS);
                String statusString = line.substring(statusIndex + STATUS.length());
                FileStatus status = FileStatus.getStatusForString(statusString);
                String fileName = line.substring(FILE.length(), statusIndex).trim();
                if (fileName.startsWith(NO_FILE)) {
                    fileName = fileName.substring(NO_FILE.length());
                }
                this.outputDone();
                this.statusInformation = new StatusInformation();
                this.statusInformation.setFile(this.createFile(fileName));
                this.statusInformation.setStatus(status);
                this.beginning = false;
                return;
            }
        } else if (line.startsWith(WORK_REVISION)) {
            String workingRevision = line.substring(WORK_REVISION.length());
            if (workingRevision.startsWith(NO_ENTRY_FOR)) {
                workingRevision = "";
            }
            this.statusInformation.setWorkingRevision(workingRevision);
        } else if (line.startsWith(REPOSITORY_REVISION)) {
            int separatorIndex;
            String repositoryRevision = line.substring(REPOSITORY_REVISION.length());
            this.statusInformation.setRepositoryRevision("");
            this.statusInformation.setRepositoryFileName("");
            if (!repositoryRevision.equals(NO_REVISION_CONTROL_FILE) && (separatorIndex = repositoryRevision.indexOf(9)) > 0) {
                this.statusInformation.setRepositoryRevision(repositoryRevision.substring(0, separatorIndex).trim());
                this.statusInformation.setRepositoryFileName(repositoryRevision.substring(separatorIndex).trim());
            }
        } else if (line.startsWith(STICKY_TAG)) {
            String stickyTag = line.substring(STICKY_TAG.length()).trim();
            this.statusInformation.setStickyTag(stickyTag);
        } else if (line.startsWith(STICKY_DATE)) {
            String stickyDate = line.substring(STICKY_DATE.length()).trim();
            this.statusInformation.setStickyDate(stickyDate);
        } else if (line.startsWith(STICKY_OPTIONS)) {
            String stickyOptions = line.substring(STICKY_OPTIONS.length()).trim();
            this.statusInformation.setStickyOptions(stickyOptions);
        } else if (line.startsWith(EXISTING_TAGS)) {
            this.readingTags = true;
        } else if (line.equals(SEPARATOR)) {
            this.outputDone();
        }
    }

    private File createFile(String fileName) {
        File file = null;
        if (this.relativeDirectory != null) {
            file = this.relativeDirectory.trim().equals(".") ? this.cvsFileSystem.getLocalFileSystem().getFile(fileName) : this.cvsFileSystem.getLocalFileSystem().getFile(this.relativeDirectory + '/' + fileName);
        } else {
            Iterator it = this.fileObjects.iterator();
            while (it.hasNext()) {
                AbstractFileObject abstractFileObject = (AbstractFileObject)it.next();
                if (abstractFileObject instanceof FileObject) {
                    FileObject fileObject = (FileObject)abstractFileObject;
                    if (!fileObject.getName().equals(fileName)) continue;
                    it.remove();
                    return this.cvsFileSystem.getLocalFileSystem().getFile(fileObject);
                }
                it.remove();
            }
        }
        BugLog.getInstance().assertTrue(file != null, "Wrong algorithm for detecting file name (" + fileName + ")");
        return file;
    }

    @Override
    public void binaryMessageSent(byte[] bytes) {
    }
}

