/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.android.ide.common.resources.LocaleManager;
import com.android.ide.common.resources.configuration.CountryCodeQualifier;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.KeyboardStateQualifier;
import com.android.ide.common.resources.configuration.LayoutDirectionQualifier;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.ide.common.resources.configuration.NavigationMethodQualifier;
import com.android.ide.common.resources.configuration.NavigationStateQualifier;
import com.android.ide.common.resources.configuration.NetworkCodeQualifier;
import com.android.ide.common.resources.configuration.NightModeQualifier;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.ide.common.resources.configuration.ScreenDimensionQualifier;
import com.android.ide.common.resources.configuration.ScreenHeightQualifier;
import com.android.ide.common.resources.configuration.ScreenOrientationQualifier;
import com.android.ide.common.resources.configuration.ScreenRatioQualifier;
import com.android.ide.common.resources.configuration.ScreenSizeQualifier;
import com.android.ide.common.resources.configuration.ScreenWidthQualifier;
import com.android.ide.common.resources.configuration.SmallestScreenWidthQualifier;
import com.android.ide.common.resources.configuration.TextInputMethodQualifier;
import com.android.ide.common.resources.configuration.TouchScreenQualifier;
import com.android.ide.common.resources.configuration.UiModeQualifier;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.resources.Density;
import com.android.resources.Keyboard;
import com.android.resources.KeyboardState;
import com.android.resources.LayoutDirection;
import com.android.resources.Navigation;
import com.android.resources.NavigationState;
import com.android.resources.NightMode;
import com.android.resources.ResourceEnum;
import com.android.resources.ScreenOrientation;
import com.android.resources.ScreenRatio;
import com.android.resources.ScreenSize;
import com.android.resources.TouchScreen;
import com.android.resources.UiMode;
import com.android.tools.idea.rendering.FlagManager;
import com.google.common.collect.Maps;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.SortedListModel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.JBUI;
import icons.AndroidIcons;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.android.uipreview.InvalidOptionValueException;
import org.jetbrains.android.util.AndroidBundle;

public abstract class DeviceConfiguratorPanel
extends JPanel {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.uipreview.DeviceConfiguratorPanel");
    private JBList myAvailableQualifiersList;
    private JButton myAddQualifierButton;
    private JButton myRemoveQualifierButton;
    private JPanel myQualifierOptionsPanel;
    private final Map<String, MyQualifierEditor> myEditors = new HashMap();
    private final FolderConfiguration myAvailableQualifiersConfig = new FolderConfiguration();
    private final FolderConfiguration myChosenQualifiersConfig = new FolderConfiguration();
    private FolderConfiguration myActualQualifiersConfig = new FolderConfiguration();
    private JBList myChosenQualifiersList;
    private final DocumentListener myUpdatingDocumentListener = new DocumentAdapter(){

        protected void textChanged(DocumentEvent e) {
            DeviceConfiguratorPanel.this.applyEditors();
        }
    };
    public final ListSelectionListener myUpdatingListListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            DeviceConfiguratorPanel.this.applyEditors();
        }
    };
    private static final Map<String, Icon> ourIcons = Maps.newHashMapWithExpectedSize((int)25);

    public DeviceConfiguratorPanel() {
        super(new BorderLayout());
        this.createUIComponents();
        this.createDefaultConfig(this.myAvailableQualifiersConfig);
        this.myChosenQualifiersConfig.reset();
        for (ResourceQualifier qualifier : this.myAvailableQualifiersConfig.getQualifiers()) {
            String name = qualifier.getShortName();
            if (qualifier instanceof CountryCodeQualifier) {
                this.myEditors.put(name, new MyCountryCodeEditor());
                continue;
            }
            if (qualifier instanceof NetworkCodeQualifier) {
                this.myEditors.put(name, new MyNetworkCodeEditor());
                continue;
            }
            if (qualifier instanceof KeyboardStateQualifier) {
                this.myEditors.put(name, new MyKeyboardStateEditor());
                continue;
            }
            if (qualifier instanceof NavigationMethodQualifier) {
                this.myEditors.put(name, new MyNavigationMethodEditor());
                continue;
            }
            if (qualifier instanceof NavigationStateQualifier) {
                this.myEditors.put(name, new MyNavigationStateEditor());
                continue;
            }
            if (qualifier instanceof DensityQualifier) {
                this.myEditors.put(name, new MyDensityEditor());
                continue;
            }
            if (qualifier instanceof ScreenDimensionQualifier) {
                this.myEditors.put(name, new MyScreenDimensionEditor());
                continue;
            }
            if (qualifier instanceof ScreenOrientationQualifier) {
                this.myEditors.put(name, new MyScreenOrientationEditor());
                continue;
            }
            if (qualifier instanceof ScreenRatioQualifier) {
                this.myEditors.put(name, new MyScreenRatioEditor());
                continue;
            }
            if (qualifier instanceof ScreenSizeQualifier) {
                this.myEditors.put(name, new MyScreenSizeEditor());
                continue;
            }
            if (qualifier instanceof TextInputMethodQualifier) {
                this.myEditors.put(name, new MyTextInputMethodEditor());
                continue;
            }
            if (qualifier instanceof TouchScreenQualifier) {
                this.myEditors.put(name, new MyTouchScreenEditor());
                continue;
            }
            if (qualifier instanceof VersionQualifier) {
                this.myEditors.put(name, new MyVersionEditor());
                continue;
            }
            if (qualifier instanceof NightModeQualifier) {
                this.myEditors.put(name, new MyNightModeEditor());
                continue;
            }
            if (qualifier instanceof UiModeQualifier) {
                this.myEditors.put(name, new MyUiModeEditor());
                continue;
            }
            if (qualifier instanceof LocaleQualifier) {
                this.myEditors.put(name, new MyLocaleEditor());
                continue;
            }
            if (qualifier instanceof SmallestScreenWidthQualifier) {
                this.myEditors.put(name, new MySmallestScreenWidthEditor());
                continue;
            }
            if (qualifier instanceof ScreenWidthQualifier) {
                this.myEditors.put(name, new MyScreenWidthEditor());
                continue;
            }
            if (qualifier instanceof ScreenHeightQualifier) {
                this.myEditors.put(name, new MyScreenHeightEditor());
                continue;
            }
            if (qualifier instanceof LayoutDirectionQualifier) {
                this.myEditors.put(name, new MyLayoutDirectionEditor());
                continue;
            }
            LOG.info("Missing editor for qualifier " + qualifier);
        }
        for (String name : this.myEditors.keySet()) {
            MyQualifierEditor editor = this.myEditors.get(name);
            this.myQualifierOptionsPanel.add((Component)editor.getComponent(), name);
        }
        this.myAvailableQualifiersList.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer(){

            protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value instanceof ResourceQualifier) {
                    ResourceQualifier qualifier = (ResourceQualifier)value;
                    this.append(qualifier.getShortName());
                    this.setIcon(DeviceConfiguratorPanel.getResourceIcon(qualifier));
                }
            }
        });
        this.myChosenQualifiersList.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer(){

            protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value instanceof ResourceQualifier) {
                    ResourceQualifier qualifier = DeviceConfiguratorPanel.this.getActualQualifier((ResourceQualifier)value);
                    String shortDisplayValue = qualifier.getShortDisplayValue();
                    if (shortDisplayValue != null && !shortDisplayValue.isEmpty()) {
                        this.append(shortDisplayValue);
                    } else {
                        this.append(qualifier.getShortName() + " (?)");
                    }
                    this.setIcon(DeviceConfiguratorPanel.getResourceIcon(qualifier));
                }
            }
        });
        this.myAddQualifierButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceQualifier selectedQualifier = (ResourceQualifier)DeviceConfiguratorPanel.this.myAvailableQualifiersList.getSelectedValue();
                if (selectedQualifier != null) {
                    int index = DeviceConfiguratorPanel.this.myAvailableQualifiersList.getSelectedIndex();
                    DeviceConfiguratorPanel.this.myAvailableQualifiersConfig.removeQualifier(selectedQualifier);
                    DeviceConfiguratorPanel.this.myChosenQualifiersConfig.addQualifier(selectedQualifier);
                    DeviceConfiguratorPanel.this.updateLists();
                    DeviceConfiguratorPanel.this.applyEditors();
                    if (index >= 0) {
                        DeviceConfiguratorPanel.this.myAvailableQualifiersList.setSelectedIndex(Math.min(index, DeviceConfiguratorPanel.this.myAvailableQualifiersList.getItemsCount() - 1));
                    }
                    DeviceConfiguratorPanel.this.myChosenQualifiersList.setSelectedValue((Object)selectedQualifier, true);
                }
            }
        });
        this.myRemoveQualifierButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceQualifier selectedQualifier = (ResourceQualifier)DeviceConfiguratorPanel.this.myChosenQualifiersList.getSelectedValue();
                if (selectedQualifier != null) {
                    int index = DeviceConfiguratorPanel.this.myChosenQualifiersList.getSelectedIndex();
                    DeviceConfiguratorPanel.this.myChosenQualifiersConfig.removeQualifier(selectedQualifier);
                    DeviceConfiguratorPanel.this.myAvailableQualifiersConfig.addQualifier(selectedQualifier);
                    DeviceConfiguratorPanel.this.updateLists();
                    DeviceConfiguratorPanel.this.applyEditors();
                    if (index >= 0) {
                        DeviceConfiguratorPanel.this.myChosenQualifiersList.setSelectedIndex(Math.min(index, DeviceConfiguratorPanel.this.myChosenQualifiersList.getItemsCount() - 1));
                    }
                }
            }
        });
        this.myAvailableQualifiersList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DeviceConfiguratorPanel.this.updateButtons();
            }
        });
        this.myChosenQualifiersList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DeviceConfiguratorPanel.this.updateButtons();
                DeviceConfiguratorPanel.this.updateQualifierEditor();
            }
        });
    }

    private static Icon getResourceIcon(ResourceQualifier qualifier) {
        return ourIcons.get(qualifier.getName());
    }

    public void init(FolderConfiguration config) {
        this.myChosenQualifiersConfig.set(config);
        this.myAvailableQualifiersConfig.substract(config);
        for (ResourceQualifier qualifier : config.getQualifiers()) {
            MyQualifierEditor editor = this.myEditors.get(qualifier.getShortName());
            if (editor == null) continue;
            editor.reset(qualifier);
        }
    }

    protected void createDefaultConfig(FolderConfiguration config) {
        config.createDefault();
    }

    public abstract void applyEditors();

    public void updateAll() {
        this.updateLists();
        this.updateButtons();
        this.updateQualifierEditor();
        this.applyEditors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doApplyEditors() throws InvalidOptionValueException {
        try {
            FolderConfiguration newConfig = new FolderConfiguration();
            for (ResourceQualifier qualifier : this.myChosenQualifiersConfig.getQualifiers()) {
                MyQualifierEditor editor = this.myEditors.get(qualifier.getShortName());
                if (editor == null) continue;
                newConfig.addQualifier(editor.apply());
            }
            this.myActualQualifiersConfig = newConfig;
        }
        finally {
            this.myAvailableQualifiersList.repaint();
            this.myChosenQualifiersList.repaint();
        }
    }

    public DocumentListener getUpdatingDocumentListener() {
        return this.myUpdatingDocumentListener;
    }

    private ResourceQualifier getActualQualifier(ResourceQualifier qualifier) {
        for (ResourceQualifier qualifier1 : this.myActualQualifiersConfig.getQualifiers()) {
            if (!Comparing.equal((String)qualifier1.getShortName(), (String)qualifier.getShortName())) continue;
            return qualifier1;
        }
        return qualifier;
    }

    private void updateQualifierEditor() {
        ResourceQualifier selectedQualifier = (ResourceQualifier)this.myChosenQualifiersList.getSelectedValue();
        if (selectedQualifier != null && this.myEditors.containsKey(selectedQualifier.getShortName())) {
            CardLayout layout = (CardLayout)this.myQualifierOptionsPanel.getLayout();
            layout.show(this.myQualifierOptionsPanel, selectedQualifier.getShortName());
            this.myQualifierOptionsPanel.setVisible(true);
        } else {
            this.myQualifierOptionsPanel.setVisible(false);
        }
    }

    private void updateButtons() {
        this.myAddQualifierButton.setEnabled(this.myAvailableQualifiersList.getSelectedIndex() >= 0);
        this.myRemoveQualifierButton.setEnabled(this.myChosenQualifiersList.getSelectedIndex() >= 0);
    }

    private void updateLists() {
        Object qualifier = this.myAvailableQualifiersList.getSelectedValue();
        Object[] availableQualifiers = this.filterUnsupportedQualifiers(this.myAvailableQualifiersConfig.getQualifiers());
        this.myAvailableQualifiersList.setModel((ListModel)new CollectionListModel(availableQualifiers));
        this.myAvailableQualifiersList.setSelectedValue(qualifier, true);
        if (this.myAvailableQualifiersList.getSelectedValue() == null && this.myAvailableQualifiersList.getItemsCount() > 0) {
            this.myAvailableQualifiersList.setSelectedIndex(0);
        }
        qualifier = this.myChosenQualifiersList.getSelectedValue();
        Object[] chosenQualifiers = this.filterUnsupportedQualifiers(this.myChosenQualifiersConfig.getQualifiers());
        this.myChosenQualifiersList.setModel((ListModel)new CollectionListModel(chosenQualifiers));
        this.myChosenQualifiersList.setSelectedValue(qualifier, true);
        if (this.myChosenQualifiersList.getSelectedValue() == null && this.myChosenQualifiersList.getItemsCount() > 0) {
            this.myChosenQualifiersList.setSelectedIndex(0);
        }
    }

    private ResourceQualifier[] filterUnsupportedQualifiers(ResourceQualifier[] qualifiers) {
        ArrayList<ResourceQualifier> result = new ArrayList<ResourceQualifier>();
        for (ResourceQualifier qualifier : qualifiers) {
            if (!this.myEditors.containsKey(qualifier.getShortName())) continue;
            result.add(qualifier);
        }
        return result.toArray(new ResourceQualifier[result.size()]);
    }

    public FolderConfiguration getConfiguration() {
        return this.myActualQualifiersConfig;
    }

    private void createUIComponents() {
        this.myQualifierOptionsPanel = new JPanel(new CardLayout());
        final JPanel leftPanel = new JPanel(new BorderLayout(JBUI.scale((int)5), JBUI.scale((int)5)));
        this.myAvailableQualifiersList = new JBList();
        this.myAvailableQualifiersList.setMinimumSize((Dimension)JBUI.size((int)10, (int)10));
        JBLabel label = new JBLabel(AndroidBundle.message("android.layout.preview.edit.configuration.available.qualifiers.label", new Object[0]));
        label.setLabelFor((Component)this.myAvailableQualifiersList);
        leftPanel.add((Component)label, "North");
        leftPanel.add((Component)new JBScrollPane((Component)this.myAvailableQualifiersList, 20, 31), "Center");
        final JPanel rightPanel = new JPanel(new BorderLayout(JBUI.scale((int)5), JBUI.scale((int)5)));
        this.myChosenQualifiersList = new JBList();
        this.myChosenQualifiersList.setMinimumSize((Dimension)JBUI.size((int)10, (int)10));
        label = new JBLabel(AndroidBundle.message("android.layout.preview.edit.configuration.choosen.qualifiers.label", new Object[0]));
        label.setLabelFor((Component)this.myChosenQualifiersList);
        rightPanel.add((Component)label, "North");
        rightPanel.add((Component)new JBScrollPane((Component)this.myChosenQualifiersList, 20, 31), "Center");
        final JPanel buttonsPanel = new JPanel((LayoutManager)new VerticalFlowLayout(1, 0, 0, true, false));
        this.myAddQualifierButton = new JButton(">>");
        buttonsPanel.add(this.myAddQualifierButton);
        this.myRemoveQualifierButton = new JButton("<<");
        buttonsPanel.add(this.myRemoveQualifierButton);
        int gap = 5;
        JPanel listsPanel = new JPanel((LayoutManager)new AbstractLayoutManager(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Dimension preferredLayoutSize(Container target) {
                Object object = target.getTreeLock();
                synchronized (object) {
                    Dimension leftPref = leftPanel.getPreferredSize();
                    Dimension rightPref = rightPanel.getPreferredSize();
                    Dimension middlePref = buttonsPanel.getPreferredSize();
                    Insets insets = target.getInsets();
                    int width = leftPref.width + middlePref.width + rightPref.width + insets.left + insets.right + 10;
                    int height = Math.max(leftPref.height, Math.max(rightPref.height, middlePref.height)) + insets.top + insets.bottom;
                    return new Dimension(width, height);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void layoutContainer(Container target) {
                Object object = target.getTreeLock();
                synchronized (object) {
                    Insets insets = target.getInsets();
                    int top = insets.top;
                    int bottom = target.getHeight() - insets.bottom;
                    int left = insets.left;
                    int right = target.getWidth() - insets.right;
                    int middleWidth = buttonsPanel.getPreferredSize().width + 10;
                    int listWidth = (right - left - middleWidth) / 2;
                    int height = bottom - top;
                    leftPanel.setSize(listWidth, height);
                    rightPanel.setSize(listWidth, height);
                    buttonsPanel.setSize(middleWidth, height);
                    leftPanel.setBounds(left, top, listWidth, height);
                    rightPanel.setBounds(right - listWidth, top, listWidth, height);
                    buttonsPanel.setBounds(left + listWidth + 5, top, middleWidth - 10, height);
                }
            }
        });
        listsPanel.add(leftPanel);
        listsPanel.add(buttonsPanel);
        listsPanel.add(rightPanel);
        this.add((Component)listsPanel, "Center");
        this.add((Component)this.myQualifierOptionsPanel, "East");
    }

    public JBList getAvailableQualifiersList() {
        return this.myAvailableQualifiersList;
    }

    static {
        ourIcons.put("UI Mode", AndroidIcons.Configs.Dock);
        ourIcons.put("Night Mode", AndroidIcons.Configs.Night);
        ourIcons.put("Screen Dimension", AndroidIcons.Configs.Dimension);
        ourIcons.put("Density", AndroidIcons.Configs.Dpi);
        ourIcons.put("Screen Height", AndroidIcons.Configs.Height);
        ourIcons.put("Keyboard State", AndroidIcons.Configs.Keyboard);
        ourIcons.put("Locale", AndroidIcons.Configs.Locale);
        ourIcons.put("Mobile Country Code", AndroidIcons.Configs.Mcc);
        ourIcons.put("Mobile Network Code", AndroidIcons.Configs.Mnc);
        ourIcons.put("Navigation State", AndroidIcons.Configs.Navpad);
        ourIcons.put("Navigation Method", AndroidIcons.Configs.NavpadMethod);
        ourIcons.put("Screen Orientation", AndroidIcons.Configs.Orientation);
        ourIcons.put("Screen Ratio", AndroidIcons.Configs.Ratio);
        ourIcons.put("Screen Size", AndroidIcons.Configs.Size);
        ourIcons.put("Smallest Screen Width", AndroidIcons.Configs.SmallestWidth);
        ourIcons.put("Screen Width", AndroidIcons.Configs.Width);
        ourIcons.put("Text Input Method", AndroidIcons.Configs.TextInput);
        ourIcons.put("Touch Screen", AndroidIcons.Configs.Touch);
        ourIcons.put("Layout Direction", AndroidIcons.Configs.LayoutDirection);
        ourIcons.put("Platform Version", AndroidIcons.Targets);
    }

    private class MyScreenHeightEditor
    extends MySizeEditorBase<ScreenHeightQualifier> {
        private MyScreenHeightEditor() {
            super("Screen height:");
        }

        @Override
        protected int getValue(ScreenHeightQualifier qualifier) {
            return qualifier.getValue();
        }

        @Override
        protected ScreenHeightQualifier createQualifier(int value) {
            return new ScreenHeightQualifier(value);
        }

        @Override
        protected String getErrorMessage() {
            return "Incorrect screen height";
        }
    }

    private class MyScreenWidthEditor
    extends MySizeEditorBase<ScreenWidthQualifier> {
        private MyScreenWidthEditor() {
            super("Screen width:");
        }

        @Override
        protected int getValue(ScreenWidthQualifier qualifier) {
            return qualifier.getValue();
        }

        @Override
        protected ScreenWidthQualifier createQualifier(int value) {
            return new ScreenWidthQualifier(value);
        }

        @Override
        protected String getErrorMessage() {
            return "Incorrect screen width";
        }
    }

    private class MySmallestScreenWidthEditor
    extends MySizeEditorBase<SmallestScreenWidthQualifier> {
        private MySmallestScreenWidthEditor() {
            super("Smallest screen width:");
        }

        @Override
        protected int getValue(SmallestScreenWidthQualifier qualifier) {
            return qualifier.getValue();
        }

        @Override
        protected SmallestScreenWidthQualifier createQualifier(int value) {
            return new SmallestScreenWidthQualifier(value);
        }

        @Override
        protected String getErrorMessage() {
            return "Incorrect smallest screen width";
        }
    }

    private abstract class MySizeEditorBase<T extends ResourceQualifier>
    extends MyQualifierEditor<T> {
        private final JTextField myTextField;
        private String myLabelText;

        protected MySizeEditorBase(String labelText) {
            this.myTextField = new JTextField(3);
            this.myLabelText = labelText;
        }

        @Override
        JComponent getComponent() {
            JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
            JBLabel label = new JBLabel(this.myLabelText);
            panel.add((Component)label);
            label.setLabelFor((Component)this.myTextField);
            this.myTextField.getDocument().addDocumentListener(DeviceConfiguratorPanel.this.myUpdatingDocumentListener);
            panel.add(this.myTextField);
            return panel;
        }

        @Override
        void reset(T qualifier) {
            this.myTextField.setText(Integer.toString(this.getValue(qualifier)));
        }

        protected abstract int getValue(T var1);

        protected abstract T createQualifier(int var1);

        protected abstract String getErrorMessage();

        @Override
        T apply() throws InvalidOptionValueException {
            try {
                int value = Integer.parseInt(this.myTextField.getText().trim());
                if (value < 0) {
                    throw new InvalidOptionValueException(this.getErrorMessage());
                }
                return this.createQualifier(value);
            }
            catch (NumberFormatException e) {
                throw new InvalidOptionValueException(this.getErrorMessage());
            }
        }
    }

    private class MyLocaleEditor
    extends MyQualifierEditor<LocaleQualifier> {
        private final JBList myLanguageList;
        private final JBList myRegionList;
        private JBCheckBox myShowAllRegions;
        private JBLabel myWarningsLabel;

        private MyLocaleEditor() {
            this.myLanguageList = new JBList();
            this.myRegionList = new JBList();
        }

        @Override
        JComponent getComponent() {
            JPanel pane = new JPanel(new GridBagLayout());
            pane.setBorder((Border)JBUI.Borders.empty((int)0, (int)20, (int)0, (int)0));
            this.myShowAllRegions = new JBCheckBox("Show All Regions", false);
            this.myWarningsLabel = new JBLabel("BCP 47 tags (3-letter languages or regions) will only match on API 21");
            this.myWarningsLabel.setIcon(AllIcons.General.BalloonWarning);
            this.myWarningsLabel.setVisible(false);
            JBLabel languageLabel = new JBLabel("Language:");
            JBLabel languageTip = new JBLabel("Tip: Type in list to filter");
            JBLabel regionLabel = new JBLabel("Specific Region Only:");
            SortedListModel languageModel = new SortedListModel((Comparator)new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    int delta = s1.length() - s2.length();
                    if (delta != 0) {
                        return delta;
                    }
                    return String.CASE_INSENSITIVE_ORDER.compare(s1, s2);
                }
            });
            languageModel.addAll((Collection)LocaleManager.getLanguageCodes((boolean)true));
            this.myLanguageList.setModel((ListModel)languageModel);
            this.myLanguageList.setSelectionMode(0);
            this.myLanguageList.setCellRenderer(FlagManager.get().getLanguageCodeCellRenderer());
            JBScrollPane scroll = new JBScrollPane((Component)this.myLanguageList);
            JComponent languagePane = ListWithFilter.wrap((JList)this.myLanguageList, (JScrollPane)scroll, FlagManager.getLanguageNameMapper());
            languageLabel.setLabelFor((Component)this.myLanguageList);
            languageTip.setFont((Font)JBUI.Fonts.miniFont());
            this.myRegionList.setSelectionMode(0);
            this.myRegionList.setCellRenderer(FlagManager.get().getRegionCodeCellRenderer());
            this.updateRegionList(null);
            JBScrollPane regionPane = new JBScrollPane((Component)this.myRegionList);
            Insets insets = new Insets(0, 20, 0, 0);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            pane.add((Component)languageLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.insets = insets;
            pane.add((Component)regionLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            pane.add((Component)languagePane, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = insets;
            pane.add((Component)regionPane, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 13;
            pane.add((Component)languageTip, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.insets = insets;
            pane.add((Component)this.myShowAllRegions, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 21;
            pane.add((Component)this.myWarningsLabel, gridBagConstraints);
            this.myLanguageList.addListSelectionListener(DeviceConfiguratorPanel.this.myUpdatingListListener);
            this.myRegionList.addListSelectionListener(DeviceConfiguratorPanel.this.myUpdatingListListener);
            this.myLanguageList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    MyLocaleEditor.this.updateRegionList((String)MyLocaleEditor.this.myLanguageList.getSelectedValue());
                }
            });
            this.myShowAllRegions.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    MyLocaleEditor.this.updateRegionList((String)MyLocaleEditor.this.myLanguageList.getSelectedValue());
                }
            });
            return pane;
        }

        private void updateRegionList(String languageCode) {
            final Ref preferred = new Ref(null);
            SortedListModel regionModel = new SortedListModel((Comparator)new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    if (s1.equals("__")) {
                        return -1;
                    }
                    if (s2.equals("__")) {
                        return 1;
                    }
                    if (s1.equals(preferred.get())) {
                        return -1;
                    }
                    if (s2.equals(preferred.get())) {
                        return 1;
                    }
                    int delta = s1.length() - s2.length();
                    if (delta != 0) {
                        return delta;
                    }
                    return String.CASE_INSENSITIVE_ORDER.compare(s1, s2);
                }
            });
            regionModel.add((Object)"__");
            if (!this.myShowAllRegions.isSelected() && languageCode != null) {
                preferred.set((Object)LocaleManager.getLanguageRegion((String)languageCode));
                List relevant = LocaleManager.getRelevantRegions((String)languageCode);
                for (String code : relevant) {
                    regionModel.add((Object)code);
                }
            } else {
                for (String code : LocaleManager.getRegionCodes((boolean)true)) {
                    regionModel.add((Object)code);
                }
            }
            this.myRegionList.setModel((ListModel)regionModel);
            if (languageCode != null && regionModel.getSize() > 0) {
                this.myRegionList.setSelectedIndex(0);
            }
        }

        @Override
        void reset(LocaleQualifier qualifier) {
            if (qualifier.isValid() && !qualifier.hasFakeValue()) {
                String language = qualifier.getLanguage();
                String region = qualifier.getRegion();
                ListModel languageModel = this.myLanguageList.getModel();
                ListModel regionModel = this.myRegionList.getModel();
                int n = languageModel.getSize();
                for (int i = 0; i < n; ++i) {
                    if (!language.equals(languageModel.getElementAt(i))) continue;
                    this.myLanguageList.setSelectedIndex(i);
                    break;
                }
                if (region != null) {
                    int i;
                    boolean found = false;
                    int n2 = regionModel.getSize();
                    for (i = 0; i < n2; ++i) {
                        if (!region.equals(regionModel.getElementAt(i))) continue;
                        this.myRegionList.setSelectedIndex(i);
                        found = true;
                        break;
                    }
                    if (!found && !this.myShowAllRegions.isSelected()) {
                        this.myShowAllRegions.setSelected(true);
                        n2 = regionModel.getSize();
                        for (i = 0; i < n2; ++i) {
                            if (!region.equals(regionModel.getElementAt(i))) continue;
                            this.myRegionList.setSelectedIndex(i);
                            break;
                        }
                    }
                } else {
                    this.myRegionList.setSelectedIndex(-1);
                }
            } else {
                this.myLanguageList.setSelectedIndex(-1);
                this.myRegionList.setSelectedIndex(-1);
            }
        }

        @Override
        LocaleQualifier apply() throws InvalidOptionValueException {
            String selectedLanguage = (String)this.myLanguageList.getSelectedValue();
            if (selectedLanguage == null) {
                throw new InvalidOptionValueException("Select a language tag");
            }
            String selectedRegion = (String)this.myRegionList.getSelectedValue();
            if ("__".equals(selectedRegion)) {
                selectedRegion = null;
            }
            this.myWarningsLabel.setVisible(selectedLanguage.length() > 2 || selectedRegion != null && selectedRegion.length() > 2);
            return new LocaleQualifier(null, selectedLanguage, selectedRegion, null);
        }
    }

    private class MyUiModeEditor
    extends MyEnumBasedEditor<UiModeQualifier, UiMode> {
        private MyUiModeEditor() {
            super(UiMode.class);
        }

        @Override
        protected String getCaption() {
            return "UI mode:";
        }

        @Override
        protected UiMode getValue(UiModeQualifier qualifier) {
            return qualifier.getValue();
        }

        @Override
        protected UiModeQualifier getQualifier(UiMode value) {
            return new UiModeQualifier(value);
        }

        @Override
        protected String getErrorMessage() {
            return "Specify UI mode";
        }
    }

    private class MyNightModeEditor
    extends MyEnumBasedEditor<NightModeQualifier, NightMode> {
        protected MyNightModeEditor() {
            super(NightMode.class);
        }

        @Override
        protected String getCaption() {
            return "Night mode:";
        }

        @Override
        protected NightMode getValue(NightModeQualifier qualifier) {
            return qualifier.getValue();
        }

        @Override
        protected NightModeQualifier getQualifier(NightMode value) {
            return new NightModeQualifier(value);
        }

        @Override
        protected String getErrorMessage() {
            return "Specify night mode";
        }
    }

    private class MyVersionEditor
    extends MyQualifierEditor<VersionQualifier> {
        private final JTextField myTextField;

        private MyVersionEditor() {
            this.myTextField = new JTextField(3);
        }

        @Override
        JComponent getComponent() {
            JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
            JBLabel label = new JBLabel("Platform API level:");
            panel.add((Component)label);
            label.setLabelFor((Component)this.myTextField);
            this.myTextField.getDocument().addDocumentListener(DeviceConfiguratorPanel.this.myUpdatingDocumentListener);
            panel.add(this.myTextField);
            return panel;
        }

        @Override
        void reset(VersionQualifier qualifier) {
            this.myTextField.setText(Integer.toString(qualifier.getVersion()));
        }

        @Override
        VersionQualifier apply() throws InvalidOptionValueException {
            try {
                int apiLevel = Integer.parseInt(this.myTextField.getText().trim());
                if (apiLevel < 0) {
                    throw new InvalidOptionValueException("Incorrect API level");
                }
                return new VersionQualifier(apiLevel);
            }
            catch (NumberFormatException e) {
                throw new InvalidOptionValueException("Incorrect API level");
            }
        }
    }

    private class MyScreenDimensionEditor
    extends MyQualifierEditor<ScreenDimensionQualifier> {
        private final JTextField mySizeField1;
        private final JTextField mySizeField2;

        private MyScreenDimensionEditor() {
            this.mySizeField1 = new JTextField();
            this.mySizeField2 = new JTextField();
        }

        @Override
        JComponent getComponent() {
            JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
            JBLabel label = new JBLabel("Screen dimension in dp:");
            label.setLabelFor((Component)this.mySizeField1);
            panel.add((Component)label);
            panel.add(this.mySizeField1);
            panel.add(this.mySizeField2);
            this.mySizeField1.getDocument().addDocumentListener(DeviceConfiguratorPanel.this.myUpdatingDocumentListener);
            this.mySizeField2.getDocument().addDocumentListener(DeviceConfiguratorPanel.this.myUpdatingDocumentListener);
            return panel;
        }

        @Override
        void reset(ScreenDimensionQualifier qualifier) {
            int value2;
            int value1 = qualifier.getValue1();
            if (value1 >= 0) {
                this.mySizeField1.setText(Integer.toString(value1));
            }
            if ((value2 = qualifier.getValue2()) >= 0) {
                this.mySizeField2.setText(Integer.toString(value2));
            }
        }

        @Override
        ScreenDimensionQualifier apply() throws InvalidOptionValueException {
            try {
                int size1 = Integer.parseInt(this.mySizeField1.getText());
                int size2 = Integer.parseInt(this.mySizeField2.getText());
                if (size1 <= 0 || size2 <= 0) {
                    throw new InvalidOptionValueException("Incorrect screen dimension");
                }
                return new ScreenDimensionQualifier(size1, size2);
            }
            catch (NumberFormatException e) {
                LOG.debug((Throwable)e);
                throw new InvalidOptionValueException("Incorrect screen dimension");
            }
        }
    }

    private class MyLayoutDirectionEditor
    extends MyEnumBasedEditor<LayoutDirectionQualifier, LayoutDirection> {
        private MyLayoutDirectionEditor() {
            super(LayoutDirection.class);
        }

        @Override
        protected String getCaption() {
            return "Layout direction:";
        }

        @Override
        protected LayoutDirection getValue(LayoutDirectionQualifier qualifier) {
            return qualifier.getValue();
        }

        @Override
        protected LayoutDirectionQualifier getQualifier(LayoutDirection value) {
            return new LayoutDirectionQualifier(value);
        }

        @Override
        protected String getErrorMessage() {
            return "Specify layout direction";
        }
    }

    private class MyNavigationMethodEditor
    extends MyEnumBasedEditor<NavigationMethodQualifier, Navigation> {
        private MyNavigationMethodEditor() {
            super(Navigation.class);
        }

        @Override
        protected String getCaption() {
            return "Navigation method:";
        }

        @Override
        protected Navigation getValue(NavigationMethodQualifier qualifier) {
            return qualifier.getValue();
        }

        @Override
        protected NavigationMethodQualifier getQualifier(Navigation value) {
            return new NavigationMethodQualifier(value);
        }

        @Override
        protected String getErrorMessage() {
            return "Specify navigation method";
        }
    }

    private class MyNavigationStateEditor
    extends MyEnumBasedEditor<NavigationStateQualifier, NavigationState> {
        private MyNavigationStateEditor() {
            super(NavigationState.class);
        }

        @Override
        protected String getCaption() {
            return "Navigation state:";
        }

        @Override
        protected NavigationState getValue(NavigationStateQualifier qualifier) {
            return qualifier.getValue();
        }

        @Override
        protected NavigationStateQualifier getQualifier(NavigationState value) {
            return new NavigationStateQualifier(value);
        }

        @Override
        protected String getErrorMessage() {
            return "Specify navigation state";
        }
    }

    private class MyTextInputMethodEditor
    extends MyEnumBasedEditor<TextInputMethodQualifier, Keyboard> {
        private MyTextInputMethodEditor() {
            super(Keyboard.class);
        }

        @Override
        protected String getCaption() {
            return "Text input method:";
        }

        @Override
        protected Keyboard getValue(TextInputMethodQualifier qualifier) {
            return qualifier.getValue();
        }

        @Override
        protected TextInputMethodQualifier getQualifier(Keyboard value) {
            return new TextInputMethodQualifier(value);
        }

        @Override
        protected String getErrorMessage() {
            return "Specify text input method";
        }
    }

    private class MyKeyboardStateEditor
    extends MyEnumBasedEditor<KeyboardStateQualifier, KeyboardState> {
        private MyKeyboardStateEditor() {
            super(KeyboardState.class);
        }

        @Override
        protected String getCaption() {
            return "Keyboard state:";
        }

        @Override
        protected KeyboardState getValue(KeyboardStateQualifier qualifier) {
            return qualifier.getValue();
        }

        @Override
        protected KeyboardStateQualifier getQualifier(KeyboardState value) {
            return new KeyboardStateQualifier(value);
        }

        @Override
        protected String getErrorMessage() {
            return "Specify keyboard state";
        }
    }

    private class MyTouchScreenEditor
    extends MyEnumBasedEditor<TouchScreenQualifier, TouchScreen> {
        private MyTouchScreenEditor() {
            super(TouchScreen.class);
        }

        @Override
        protected String getCaption() {
            return "Touch screen:";
        }

        @Override
        protected TouchScreen getValue(TouchScreenQualifier qualifier) {
            return qualifier.getValue();
        }

        @Override
        protected TouchScreenQualifier getQualifier(TouchScreen value) {
            return new TouchScreenQualifier(value);
        }

        @Override
        protected String getErrorMessage() {
            return "Specify touch screen";
        }
    }

    private class MyDensityEditor
    extends MyEnumBasedEditor<DensityQualifier, Density> {
        private MyDensityEditor() {
            super(Density.class);
        }

        @Override
        protected ComboBoxModel createModel() {
            return new DensityComboBoxModel();
        }

        @Override
        protected String getCaption() {
            return "Density:";
        }

        @Override
        protected Density getValue(DensityQualifier qualifier) {
            return qualifier.getValue();
        }

        @Override
        protected DensityQualifier getQualifier(Density value) {
            return new DensityQualifier(value);
        }

        @Override
        protected String getErrorMessage() {
            return "Specify density";
        }
    }

    private static class DensityComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private final List<Density> myList = new ArrayList<Density>();
        private Density mySelected = null;

        public DensityComboBoxModel() {
            for (Density density : Density.values()) {
                if (!density.isRecommended()) continue;
                this.myList.add(density);
            }
            this.mySelected = this.myList.get(0);
        }

        @Override
        public int getSize() {
            return this.myList.size();
        }

        @Override
        public Density getElementAt(int index) {
            return this.myList.get(index);
        }

        @Override
        public void setSelectedItem(Object item) {
            Density e = (Density)item;
            this.setSelectedItem(e);
        }

        public void setSelectedItem(Density item) {
            this.mySelected = item;
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public Density getSelectedItem() {
            return this.mySelected;
        }
    }

    private class MyScreenRatioEditor
    extends MyEnumBasedEditor<ScreenRatioQualifier, ScreenRatio> {
        private MyScreenRatioEditor() {
            super(ScreenRatio.class);
        }

        @Override
        protected String getCaption() {
            return "Screen ratio:";
        }

        @Override
        protected ScreenRatio getValue(ScreenRatioQualifier qualifier) {
            return qualifier.getValue();
        }

        @Override
        protected ScreenRatioQualifier getQualifier(ScreenRatio value) {
            return new ScreenRatioQualifier(value);
        }

        @Override
        protected String getErrorMessage() {
            return "Specify screen ratio";
        }
    }

    private class MyScreenOrientationEditor
    extends MyEnumBasedEditor<ScreenOrientationQualifier, ScreenOrientation> {
        private MyScreenOrientationEditor() {
            super(ScreenOrientation.class);
        }

        @Override
        protected String getCaption() {
            return "Screen orientation:";
        }

        @Override
        protected ScreenOrientation getValue(ScreenOrientationQualifier qualifier) {
            return qualifier.getValue();
        }

        @Override
        protected ScreenOrientationQualifier getQualifier(ScreenOrientation value) {
            return new ScreenOrientationQualifier(value);
        }

        @Override
        protected String getErrorMessage() {
            return "Specify screen orientation";
        }
    }

    private class MyScreenSizeEditor
    extends MyEnumBasedEditor<ScreenSizeQualifier, ScreenSize> {
        private MyScreenSizeEditor() {
            super(ScreenSize.class);
        }

        @Override
        protected String getCaption() {
            return "Screen size:";
        }

        @Override
        protected ScreenSize getValue(ScreenSizeQualifier qualifier) {
            return qualifier.getValue();
        }

        @Override
        protected ScreenSizeQualifier getQualifier(ScreenSize value) {
            return new ScreenSizeQualifier(value);
        }

        @Override
        protected String getErrorMessage() {
            return "Specify screen size";
        }
    }

    private abstract class MyEnumBasedEditor<T extends ResourceQualifier, U extends Enum<U>>
    extends MyQualifierEditor<T> {
        private final JComboBox myComboBox;
        private final Class<U> myEnumClass;

        protected MyEnumBasedEditor(Class<U> enumClass) {
            this.myComboBox = new JComboBox();
            this.myEnumClass = enumClass;
        }

        @Override
        JComponent getComponent() {
            this.myComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DeviceConfiguratorPanel.this.applyEditors();
                }
            });
            this.myComboBox.setRenderer(new ListCellRendererWrapper(){

                public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                    if (value instanceof ResourceEnum) {
                        this.setText(((ResourceEnum)value).getShortDisplayValue());
                    }
                }
            });
            JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
            JBLabel label = new JBLabel(this.getCaption());
            label.setLabelFor((Component)this.myComboBox);
            this.myComboBox.setModel(this.createModel());
            panel.add((Component)label);
            panel.add(this.myComboBox);
            return panel;
        }

        protected ComboBoxModel createModel() {
            return new EnumComboBoxModel(this.myEnumClass);
        }

        protected abstract String getCaption();

        @Override
        void reset(T qualifier) {
            U value = this.getValue(qualifier);
            if (value != null) {
                this.myComboBox.setSelectedItem(value);
            } else if (this.myComboBox.getItemCount() > 0) {
                this.myComboBox.setSelectedIndex(0);
            }
        }

        protected abstract U getValue(T var1);

        protected abstract T getQualifier(U var1);

        protected abstract String getErrorMessage();

        @Override
        T apply() throws InvalidOptionValueException {
            Enum selectedItem = (Enum)this.myComboBox.getSelectedItem();
            if (selectedItem == null) {
                throw new InvalidOptionValueException(this.getErrorMessage());
            }
            return this.getQualifier(selectedItem);
        }
    }

    private class MyNetworkCodeEditor
    extends MyQualifierEditor<NetworkCodeQualifier> {
        private final JTextField myTextField;

        private MyNetworkCodeEditor() {
            this.myTextField = new JTextField(3);
        }

        @Override
        JComponent getComponent() {
            JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
            JBLabel label = new JBLabel("<html><body>Mobile network code<br>(1-3 digits):</body></html>");
            panel.add((Component)label);
            label.setLabelFor((Component)this.myTextField);
            this.myTextField.getDocument().addDocumentListener(DeviceConfiguratorPanel.this.myUpdatingDocumentListener);
            panel.add(this.myTextField);
            return panel;
        }

        @Override
        void reset(NetworkCodeQualifier qualifier) {
            this.myTextField.setText(Integer.toString(qualifier.getCode()));
        }

        @Override
        NetworkCodeQualifier apply() throws InvalidOptionValueException {
            try {
                int code = Integer.parseInt(this.myTextField.getText());
                if (code <= 0 || code >= 1000) {
                    throw new InvalidOptionValueException("Incorrect network code");
                }
                return new NetworkCodeQualifier(code);
            }
            catch (NumberFormatException e) {
                throw new InvalidOptionValueException("Network code must be a number");
            }
        }
    }

    private class MyCountryCodeEditor
    extends MyQualifierEditor<CountryCodeQualifier> {
        private final JTextField myTextField;

        private MyCountryCodeEditor() {
            this.myTextField = new JTextField(3);
        }

        @Override
        JComponent getComponent() {
            JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
            JBLabel label = new JBLabel("<html><body>Mobile country code<br>(3 digits):</body></html>");
            label.setLabelFor((Component)this.myTextField);
            this.myTextField.setColumns(3);
            this.myTextField.getDocument().addDocumentListener(DeviceConfiguratorPanel.this.myUpdatingDocumentListener);
            panel.add((Component)label);
            panel.add(this.myTextField);
            return panel;
        }

        @Override
        void reset(CountryCodeQualifier qualifier) {
            this.myTextField.setText(Integer.toString(qualifier.getCode()));
        }

        @Override
        CountryCodeQualifier apply() throws InvalidOptionValueException {
            if (this.myTextField.getText().length() != 3) {
                throw new InvalidOptionValueException("Country code must contain 3 digits");
            }
            try {
                int code = Integer.parseInt(this.myTextField.getText());
                if (code < 100 || code > 999) {
                    throw new InvalidOptionValueException("Incorrect country code");
                }
                return new CountryCodeQualifier(code);
            }
            catch (NumberFormatException e) {
                throw new InvalidOptionValueException("Country code must be a number");
            }
        }
    }

    private static abstract class MyQualifierEditor<T extends ResourceQualifier> {
        private MyQualifierEditor() {
        }

        abstract JComponent getComponent();

        abstract void reset(T var1);

        abstract T apply() throws InvalidOptionValueException;
    }
}

