/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.resourceManagers;

import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.attrs.StyleableDefinition;

public abstract class FilteredAttributeDefinitions
implements AttributeDefinitions {
    private final AttributeDefinitions myWrappee;

    protected FilteredAttributeDefinitions(AttributeDefinitions wrappee) {
        this.myWrappee = wrappee;
    }

    protected abstract boolean isAttributeAcceptable(String var1);

    @Override
    public StyleableDefinition getStyleableByName(String name) {
        StyleableDefinition styleable = this.myWrappee.getStyleableByName(name);
        return styleable != null ? new MyStyleableDefinition(styleable) : null;
    }

    @Override
    public Set<String> getAttributeNames() {
        HashSet result = new HashSet();
        for (String name : this.myWrappee.getAttributeNames()) {
            if (!this.isAttributeAcceptable(name)) continue;
            result.add(name);
        }
        return result;
    }

    @Override
    public AttributeDefinition getAttrDefByName(String name) {
        return this.isAttributeAcceptable(name) ? this.myWrappee.getAttrDefByName(name) : null;
    }

    @Override
    public String getAttrGroupByName(String name) {
        return this.myWrappee.getAttrGroupByName(name);
    }

    @Override
    public StyleableDefinition[] getStateStyleables() {
        StyleableDefinition[] styleables = this.myWrappee.getStateStyleables();
        StyleableDefinition[] result = new StyleableDefinition[styleables.length];
        for (int i = 0; i < styleables.length; ++i) {
            result[i] = new MyStyleableDefinition(styleables[i]);
        }
        return result;
    }

    private class MyStyleableDefinition
    implements StyleableDefinition {
        private final StyleableDefinition myWrappee;

        private MyStyleableDefinition(StyleableDefinition wrappee) {
            this.myWrappee = wrappee;
        }

        @Override
        public List<StyleableDefinition> getChildren() {
            List<StyleableDefinition> styleables = this.myWrappee.getChildren();
            ArrayList<StyleableDefinition> result = new ArrayList<StyleableDefinition>(styleables.size());
            for (StyleableDefinition styleable : styleables) {
                result.add(new MyStyleableDefinition(styleable));
            }
            return result;
        }

        @Override
        public String getName() {
            return this.myWrappee.getName();
        }

        @Override
        public List<AttributeDefinition> getAttributes() {
            ArrayList<AttributeDefinition> result = new ArrayList<AttributeDefinition>();
            for (AttributeDefinition definition : this.myWrappee.getAttributes()) {
                if (!FilteredAttributeDefinitions.this.isAttributeAcceptable(definition.getName())) continue;
                result.add(definition);
            }
            return result;
        }
    }
}

