/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.converters.AndroidResourceReferenceBase;
import org.jetbrains.android.dom.layout.Include;
import org.jetbrains.android.dom.layout.LayoutViewElement;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.dom.resources.Style;
import org.jetbrains.android.dom.wrappers.LazyValueResourceElementWrapper;
import org.jetbrains.android.refactoring.AndroidAttributeInfo;
import org.jetbrains.android.refactoring.AndroidInlineAllStyleUsagesProcessor;
import org.jetbrains.android.refactoring.AndroidInlineLayoutDialog;
import org.jetbrains.android.refactoring.AndroidInlineLayoutProcessor;
import org.jetbrains.android.refactoring.AndroidInlineStyleDialog;
import org.jetbrains.android.refactoring.AndroidInlineTestConfig;
import org.jetbrains.android.refactoring.AndroidRefactoringUtil;
import org.jetbrains.android.refactoring.LayoutUsageData;
import org.jetbrains.android.refactoring.ParentStyleUsageData;
import org.jetbrains.android.refactoring.StyleRefData;
import org.jetbrains.android.refactoring.StyleUsageData;
import org.jetbrains.android.refactoring.ViewStyleUsageData;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.ErrorReporter;

class AndroidInlineUtil {
    private AndroidInlineUtil() {
    }

    static MyStyleData getInlinableStyleData(XmlTag tag) {
        DomElement domElement = DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag);
        if (!(domElement instanceof Style)) {
            return null;
        }
        Style style = (Style)domElement;
        XmlAttributeValue nameAttrValue = style.getName().getXmlAttributeValue();
        if (nameAttrValue == null) {
            return null;
        }
        String styleName = style.getName().getStringValue();
        if (styleName == null || styleName.length() == 0) {
            return null;
        }
        return new MyStyleData(styleName, style, (PsiElement)nameAttrValue);
    }

    static StyleUsageData getStyleUsageData(XmlTag tag) {
        AndroidResourceReferenceBase reference;
        DomElement domElement = DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag);
        if (domElement instanceof LayoutViewElement) {
            GenericAttributeValue<ResourceValue> styleAttribute = ((LayoutViewElement)domElement).getStyle();
            AndroidResourceReferenceBase reference2 = AndroidDomUtil.getAndroidResourceReference(styleAttribute, true);
            if (reference2 != null) {
                return new ViewStyleUsageData(tag, styleAttribute, reference2);
            }
        } else if (domElement instanceof Style && (reference = AndroidDomUtil.getAndroidResourceReference(((Style)domElement).getParentStyle(), true)) != null) {
            return new ParentStyleUsageData((Style)domElement, reference);
        }
        return null;
    }

    static LayoutUsageData getLayoutUsageData(XmlTag tag) {
        GenericAttributeValue<ResourceValue> layoutAttribute;
        AndroidResourceReferenceBase reference;
        Project project = tag.getProject();
        DomElement domElement = DomManager.getDomManager((Project)project).getDomElement(tag);
        if (domElement instanceof Include && (reference = AndroidDomUtil.getAndroidResourceReference(layoutAttribute = ((Include)domElement).getLayout(), true)) != null) {
            return new LayoutUsageData(project, tag, reference);
        }
        return null;
    }

    static void doInlineStyleDeclaration(Project project, MyStyleData data, final StyleUsageData usageData, ErrorReporter errorReporter, AndroidInlineTestConfig testConfig) {
        boolean inlineThisOnly;
        Style style = data.myStyleElement;
        final Map<AndroidAttributeInfo, String> attributeValues = AndroidRefactoringUtil.computeAttributeMap(style, errorReporter, AndroidBundle.message("android.inline.style.title", new Object[0]));
        if (attributeValues == null) {
            return;
        }
        final StyleRefData parentStyleRef = AndroidRefactoringUtil.getParentStyle(style);
        if (testConfig != null) {
            inlineThisOnly = testConfig.isInlineThisOnly();
        } else {
            boolean invokedOnReference = usageData != null;
            AndroidInlineStyleDialog dialog = new AndroidInlineStyleDialog(project, data.myReferredElement, style.getXmlTag(), data.myStyleName, attributeValues, parentStyleRef, invokedOnReference, invokedOnReference);
            if (!dialog.showAndGet()) {
                return;
            }
            inlineThisOnly = dialog.isInlineThisOnly();
        }
        if (inlineThisOnly) {
            assert (usageData != null);
            PsiFile file = usageData.getFile();
            if (file == null) {
                return;
            }
            new WriteCommandAction(project, AndroidBundle.message("android.inline.style.command.name", data.myStyleName), new PsiFile[]{file}){

                protected void run(Result result) throws Throwable {
                    usageData.inline(attributeValues, parentStyleRef);
                }

                protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
                    return UndoConfirmationPolicy.REQUEST_CONFIRMATION;
                }
            }.execute();
        } else if (testConfig != null) {
            AndroidInlineAllStyleUsagesProcessor processor = new AndroidInlineAllStyleUsagesProcessor(project, data.myReferredElement, style.getXmlTag(), data.myStyleName, attributeValues, parentStyleRef, testConfig);
            processor.setPreviewUsages(false);
            processor.run();
        }
    }

    static MyStyleData getInlinableStyleDataFromContext(PsiElement context) {
        XmlTag tag;
        if (context instanceof LazyValueResourceElementWrapper) {
            context = ((LazyValueResourceElementWrapper)context).computeElement();
        }
        if (context == null || !context.getManager().isInProject(context)) {
            return null;
        }
        XmlAttributeValue attrValue = (XmlAttributeValue)PsiTreeUtil.getParentOfType((PsiElement)context, XmlAttributeValue.class, (boolean)false);
        XmlTag xmlTag = tag = attrValue != null ? (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)attrValue, XmlTag.class) : null;
        if (tag == null) {
            return null;
        }
        MyStyleData data = AndroidInlineUtil.getInlinableStyleData(tag);
        return data != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)data.myReferredElement, (PsiElement)attrValue) ? data : null;
    }

    static void addReferences(PsiElement element, Collection<UsageInfo> result) {
        for (PsiReference reference : ReferencesSearch.search((PsiElement)element)) {
            result.add(new UsageInfo(reference.getElement()));
        }
    }

    static MultiMap<PsiElement, String> buildConflicts(Collection<PsiElement> nonXmlUsages, Collection<PsiElement> unambiguousUsages, Collection<PsiElement> unsupportedUsages, Collection<PsiElement> implicitlyInherited) {
        MultiMap result = new MultiMap();
        for (PsiElement usage : nonXmlUsages) {
            result.putValue((Object)usage, (Object)("Non-XML reference '" + AndroidInlineUtil.toString(usage) + "' won't be updated"));
        }
        for (PsiElement usage : unambiguousUsages) {
            result.putValue((Object)usage, (Object)("Unambiguous reference '" + AndroidInlineUtil.toString(usage) + "' won't be updated"));
        }
        for (PsiElement usage : unsupportedUsages) {
            result.putValue((Object)usage, (Object)("Unsupported reference '" + AndroidInlineUtil.toString(usage) + "' won't be updated"));
        }
        for (PsiElement usage : implicitlyInherited) {
            result.putValue((Object)usage, (Object)("The style has implicit inheritor '" + AndroidInlineUtil.toString(usage) + "' which won't be updated"));
        }
        return result;
    }

    private static String toString(PsiElement element) {
        return element instanceof XmlAttributeValue ? ((XmlAttributeValue)element).getValue() : element.getText();
    }

    static void doInlineLayoutFile(Project project, XmlFile layoutFile, PsiElement usageElement, AndroidInlineTestConfig testConfig) {
        XmlTag rootTag = layoutFile.getRootTag();
        assert (rootTag != null);
        if (testConfig == null) {
            AndroidInlineLayoutDialog dialog = new AndroidInlineLayoutDialog(project, layoutFile, rootTag, usageElement);
            dialog.show();
        } else {
            AndroidInlineLayoutProcessor processor = new AndroidInlineLayoutProcessor(project, layoutFile, rootTag, (PsiElement)(testConfig.isInlineThisOnly() ? usageElement : null), testConfig);
            processor.setPreviewUsages(false);
            processor.run();
        }
    }

    static class MyStyleData {
        private final String myStyleName;
        private final Style myStyleElement;
        private final PsiElement myReferredElement;

        MyStyleData(String styleName, Style styleElement, PsiElement referredElement) {
            this.myStyleName = styleName;
            this.myStyleElement = styleElement;
            this.myReferredElement = referredElement;
        }
    }
}

