/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.tools.lint.checks.TypographyDetector;
import com.android.tools.lint.detector.api.Issue;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import java.util.List;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.util.AndroidBundle;

class TypographyQuickFix
implements AndroidLintQuickFix {
    private final Issue myIssue;
    private final String myMessage;

    public TypographyQuickFix(Issue issue, String message) {
        this.myIssue = issue;
        this.myMessage = message;
    }

    @Override
    public void apply(PsiElement startElement, PsiElement endElement, AndroidQuickfixContexts.Context context) {
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class);
        if (tag == null) {
            return;
        }
        for (PsiElement child : tag.getChildren()) {
            XmlText xmlText;
            String value;
            if (!(child instanceof XmlText) || (value = (xmlText = (XmlText)child).getValue()) == null) continue;
            List edits = TypographyDetector.getEdits((String)this.myIssue.getId(), (String)this.myMessage, (String)value);
            StringBuilder builder = new StringBuilder(value);
            for (TypographyDetector.ReplaceEdit edit : edits) {
                String with = edit.replaceWith;
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    with = with.replace('\u2013', '~').replace('\u2018', '{').replace('\u2019', '}');
                }
                builder.replace(edit.offset, edit.offset + edit.length, with);
            }
            String newValue = builder.toString();
            if (newValue.equals(value)) continue;
            xmlText.setValue(newValue);
        }
    }

    @Override
    public boolean isApplicable(PsiElement startElement, PsiElement endElement, AndroidQuickfixContexts.ContextType contextType) {
        return PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class) != null;
    }

    @Override
    public String getName() {
        return AndroidBundle.message("android.lint.fix.replace.with.suggested.characters", new Object[0]);
    }
}

