/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import javax.swing.Icon;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.resourceManagers.SystemResourceManager;

class SetAttributeQuickFix
implements AndroidLintQuickFix {
    private final String myName;
    private final String myAttributeName;
    private final String myValue;

    SetAttributeQuickFix(String name, String attributeName, String value) {
        this.myName = name;
        this.myAttributeName = attributeName;
        this.myValue = value;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public void apply(PsiElement startElement, PsiElement endElement, AndroidQuickfixContexts.Context context) {
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class, (boolean)false);
        if (tag == null) {
            return;
        }
        String value = this.myValue;
        if (value == null && context instanceof AndroidQuickfixContexts.DesignerContext && (value = this.askForAttributeValue((PsiElement)tag)) == null) {
            return;
        }
        XmlAttribute attribute = tag.setAttribute(this.myAttributeName, "http://schemas.android.com/apk/res/android", "");
        if (attribute != null) {
            if (value != null) {
                attribute.setValue(value);
            }
            if (context instanceof AndroidQuickfixContexts.EditorContext) {
                Editor editor = ((AndroidQuickfixContexts.EditorContext)context).getEditor();
                XmlAttributeValue valueElement = attribute.getValueElement();
                TextRange valueTextRange = attribute.getValueTextRange();
                if (valueElement != null && valueTextRange != null) {
                    int valueElementStart = valueElement.getTextRange().getStartOffset();
                    editor.getCaretModel().moveToOffset(valueElementStart + valueTextRange.getStartOffset());
                    if (valueTextRange.getStartOffset() < valueTextRange.getEndOffset()) {
                        editor.getSelectionModel().setSelection(valueElementStart + valueTextRange.getStartOffset(), valueElementStart + valueTextRange.getEndOffset());
                    }
                }
            }
        }
    }

    private String askForAttributeValue(PsiElement context) {
        String[] variants;
        AttributeDefinition def;
        AttributeDefinitions attrDefs;
        SystemResourceManager srm;
        AndroidFacet facet = AndroidFacet.getInstance(context);
        String message = "Specify value of attribute '" + this.myAttributeName + "'";
        String title = "Set Attribute Value";
        if (facet != null && (srm = facet.getSystemResourceManager()) != null && (attrDefs = srm.getAttributeDefinitions()) != null && (def = attrDefs.getAttrDefByName(this.myAttributeName)) != null && (variants = def.getValues()).length > 0) {
            return Messages.showEditableChooseDialog((String)message, (String)"Set Attribute Value", (Icon)Messages.getQuestionIcon(), (String[])variants, (String)variants[0], null);
        }
        return Messages.showInputDialog((Project)context.getProject(), (String)message, (String)"Set Attribute Value", (Icon)Messages.getQuestionIcon());
    }

    @Override
    public boolean isApplicable(PsiElement startElement, PsiElement endElement, AndroidQuickfixContexts.ContextType contextType) {
        if (this.myValue == null && contextType == AndroidQuickfixContexts.BatchContext.TYPE) {
            return false;
        }
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class, (boolean)false);
        if (tag == null) {
            return false;
        }
        return tag.getAttribute(this.myAttributeName, "http://schemas.android.com/apk/res/android") == null;
    }
}

