/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.rendering.PsiProjectListener;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.LintRequest;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.utils.SdkUtils;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ex.CustomEditInspectionToolsSettingsAction;
import com.intellij.codeInspection.ex.DisableInspectionToolAction;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidLintUtil;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.inspections.lint.IntellijLintClient;
import org.jetbrains.android.inspections.lint.IntellijLintIssueRegistry;
import org.jetbrains.android.inspections.lint.IntellijLintProject;
import org.jetbrains.android.inspections.lint.IntellijLintRequest;
import org.jetbrains.android.inspections.lint.ProblemData;
import org.jetbrains.android.inspections.lint.State;
import org.jetbrains.android.inspections.lint.SuppressLintIntentionAction;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.plugins.groovy.GroovyFileType;

public class AndroidLintExternalAnnotator
extends ExternalAnnotator<State, State> {
    static final boolean INCLUDE_IDEA_SUPPRESS_ACTIONS = false;
    private static boolean ourCreateHtmlAnnotationMethodFailed;
    private static Method ourCreateHtmlAnnotationMethod;
    private String myShortcutText;

    public State collectInformation(PsiFile file) {
        List<Issue> issues;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            return null;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null && !IntellijLintProject.hasAndroidModule(module.getProject())) {
            return null;
        }
        VirtualFile vFile = file.getVirtualFile();
        if (vFile == null) {
            return null;
        }
        FileType fileType = file.getFileType();
        if (fileType == StdFileTypes.XML) {
            if (facet == null || facet.getLocalResourceManager().getFileResourceType(file) == null && !"AndroidManifest.xml".equals(vFile.getName())) {
                return null;
            }
        } else if (fileType == FileTypes.PLAIN_TEXT) {
            if (!"proguard-project.txt".equals(file.getName()) && !"proguard.cfg".equals(file.getName())) {
                return null;
            }
        } else if (fileType == GroovyFileType.GROOVY_FILE_TYPE) {
            if (!SdkUtils.endsWithIgnoreCase((String)file.getName(), (String)".gradle")) {
                return null;
            }
            Project project = file.getProject();
            if (Projects.requiresAndroidModel(project)) {
                PsiProjectListener.getInstance(project);
            }
        } else if (fileType != StdFileTypes.JAVA && fileType != StdFileTypes.PROPERTIES) {
            return null;
        }
        if ((issues = AndroidLintExternalAnnotator.getIssuesFromInspections(file.getProject(), (PsiElement)file)).size() == 0) {
            return null;
        }
        return new State(module, vFile, file.getText(), issues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State doAnnotate(State state) {
        IntellijLintClient client = IntellijLintClient.forEditor(state);
        try {
            EnumSet scope;
            LintDriver lint = new LintDriver((IssueRegistry)new IntellijLintIssueRegistry(), (LintClient)client);
            VirtualFile mainFile = state.getMainFile();
            FileType fileType = mainFile.getFileType();
            String name = mainFile.getName();
            if (fileType == StdFileTypes.XML) {
                scope = name.equals("AndroidManifest.xml") ? Scope.MANIFEST_SCOPE : Scope.RESOURCE_FILE_SCOPE;
            } else if (fileType == StdFileTypes.JAVA) {
                scope = Scope.JAVA_FILE_SCOPE;
            } else if (name.equals("proguard.cfg") || name.equals("proguard-project.txt")) {
                scope = EnumSet.of(Scope.PROGUARD_FILE);
            } else if (fileType == GroovyFileType.GROOVY_FILE_TYPE) {
                scope = Scope.GRADLE_SCOPE;
            } else if (fileType == StdFileTypes.PROPERTIES) {
                scope = Scope.PROPERTY_SCOPE;
            } else {
                assert (false);
                State state2 = state;
                return state2;
            }
            Project project = state.getModule().getProject();
            if (project.isDisposed()) {
                State state3 = state;
                return state3;
            }
            List<VirtualFile> files = Collections.singletonList(mainFile);
            IntellijLintRequest request = new IntellijLintRequest(client, project, files, Collections.singletonList(state.getModule()), true);
            request.setScope(scope);
            lint.analyze((LintRequest)request);
        }
        finally {
            Disposer.dispose((Disposable)client);
        }
        return state;
    }

    static List<Issue> getIssuesFromInspections(Project project, PsiElement context) {
        ArrayList<Issue> result = new ArrayList<Issue>();
        IntellijLintIssueRegistry fullRegistry = new IntellijLintIssueRegistry();
        for (Issue issue : fullRegistry.getIssues()) {
            HighlightDisplayKey key;
            String inspectionShortName = AndroidLintInspectionBase.getInspectionShortNameByIssue(project, issue);
            if (inspectionShortName == null || (key = HighlightDisplayKey.find((String)inspectionShortName)) == null) continue;
            InspectionProfile profile = InspectionProjectProfileManager.getInstance((Project)project).getInspectionProfile();
            boolean enabled = context != null ? profile.isToolEnabled(key, context) : profile.isToolEnabled(key);
            if (!enabled) continue;
            if (!issue.isEnabledByDefault()) {
                issue.setEnabledByDefault(true);
            }
            result.add(issue);
        }
        return result;
    }

    public void apply(PsiFile file, State state, AnnotationHolder holder) {
        if (state.isDirty()) {
            return;
        }
        Project project = file.getProject();
        for (ProblemData problemData : state.getProblems()) {
            HighlightDisplayLevel configuredLevel;
            HighlightDisplayKey key;
            Pair<AndroidLintInspectionBase, HighlightDisplayLevel> pair;
            Issue issue = problemData.getIssue();
            String message = problemData.getMessage();
            TextRange range = problemData.getTextRange();
            if (range.getStartOffset() == range.getEndOffset() || (pair = AndroidLintUtil.getHighlighLevelAndInspection(project, issue, (PsiElement)file)) == null) continue;
            AndroidLintInspectionBase inspection = (AndroidLintInspectionBase)((Object)pair.getFirst());
            HighlightDisplayLevel displayLevel = (HighlightDisplayLevel)pair.getSecond();
            if (inspection == null || (key = HighlightDisplayKey.find((String)inspection.getShortName())) == null) continue;
            PsiElement startElement = file.findElementAt(range.getStartOffset());
            PsiElement endElement = file.findElementAt(range.getEndOffset() - 1);
            if (startElement == null || endElement == null || inspection.isSuppressedFor(startElement)) continue;
            if (problemData.getConfiguredSeverity() != null && (configuredLevel = AndroidLintInspectionBase.toHighlightDisplayLevel(problemData.getConfiguredSeverity())) != null) {
                displayLevel = configuredLevel;
            }
            Annotation annotation = this.createAnnotation(holder, message, range, displayLevel, issue);
            for (AndroidLintQuickFix androidLintQuickFix : inspection.getQuickFixes(startElement, endElement, message)) {
                if (!androidLintQuickFix.isApplicable(startElement, endElement, AndroidQuickfixContexts.EditorContext.TYPE)) continue;
                annotation.registerFix((IntentionAction)new MyFixingIntention(androidLintQuickFix, startElement, endElement));
            }
            for (AndroidLintQuickFix androidLintQuickFix : inspection.getIntentions(startElement, endElement)) {
                annotation.registerFix((IntentionAction)androidLintQuickFix);
            }
            annotation.registerFix((IntentionAction)new SuppressLintIntentionAction(key.getID(), startElement));
            annotation.registerFix((IntentionAction)new MyDisableInspectionFix(key));
            annotation.registerFix((IntentionAction)new MyEditInspectionToolsSettingsAction(key, inspection));
        }
    }

    private Annotation createAnnotation(AnnotationHolder holder, String message, TextRange range, HighlightDisplayLevel displayLevel, Issue issue) {
        HighlightSeverity severity = displayLevel == HighlightDisplayLevel.ERROR ? HighlightSeverity.ERROR : (displayLevel == HighlightDisplayLevel.WARNING ? HighlightSeverity.WARNING : (displayLevel == HighlightDisplayLevel.WEAK_WARNING ? HighlightSeverity.WEAK_WARNING : (displayLevel == HighlightDisplayLevel.INFO ? HighlightSeverity.INFO : HighlightSeverity.WARNING)));
        Method createHtmlAnnotation = AndroidLintExternalAnnotator.getCreateHtmlAnnotation();
        if (createHtmlAnnotation != null) {
            String link = " <a href=\"#lint/" + issue.getId() + "\"" + (UIUtil.isUnderDarcula() ? " color=\"7AB4C9\" " : "") + ">" + DaemonBundle.message((String)"inspection.extended.description", (Object[])new Object[0]) + "</a> " + this.getShowMoreShortCut();
            String tooltip = XmlStringUtil.wrapInHtml((CharSequence)(TextFormat.RAW.convertTo(message, TextFormat.HTML) + link));
            try {
                return (Annotation)createHtmlAnnotation.invoke((Object)holder, severity, range, message, tooltip);
            }
            catch (IllegalAccessException ignored) {
                ourCreateHtmlAnnotationMethod = null;
                ourCreateHtmlAnnotationMethodFailed = true;
            }
            catch (InvocationTargetException e) {
                ourCreateHtmlAnnotationMethod = null;
                ourCreateHtmlAnnotationMethodFailed = true;
            }
        }
        return holder.createAnnotation(severity, range, message);
    }

    private static Method getCreateHtmlAnnotation() {
        if (ourCreateHtmlAnnotationMethod != null) {
            return ourCreateHtmlAnnotationMethod;
        }
        if (ourCreateHtmlAnnotationMethodFailed) {
            return null;
        }
        ourCreateHtmlAnnotationMethodFailed = true;
        try {
            ourCreateHtmlAnnotationMethod = AnnotationHolder.class.getMethod("createAnnotation", HighlightSeverity.class, TextRange.class, String.class, String.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return ourCreateHtmlAnnotationMethod;
    }

    private String getShowMoreShortCut() {
        if (this.myShortcutText == null) {
            Keymap keymap;
            KeymapManager keymapManager = KeymapManager.getInstance();
            this.myShortcutText = keymapManager != null ? ((keymap = keymapManager.getActiveKeymap()) == null ? "" : "(" + KeymapUtil.getShortcutsText((Shortcut[])keymap.getShortcuts("ShowErrorDescription")) + ")") : "";
        }
        return this.myShortcutText;
    }

    private static class MyEditInspectionToolsSettingsAction
    extends CustomEditInspectionToolsSettingsAction {
        private MyEditInspectionToolsSettingsAction(HighlightDisplayKey key, final AndroidLintInspectionBase inspection) {
            super(key, (Computable)new Computable<String>(){

                public String compute() {
                    return "Edit '" + inspection.getDisplayName() + "' inspection settings";
                }
            });
        }
    }

    public static class MyFixingIntention
    implements IntentionAction,
    HighPriorityAction {
        private final AndroidLintQuickFix myQuickFix;
        private final PsiElement myStartElement;
        private final PsiElement myEndElement;

        public MyFixingIntention(AndroidLintQuickFix quickFix, PsiElement startElement, PsiElement endElement) {
            this.myQuickFix = quickFix;
            this.myStartElement = startElement;
            this.myEndElement = endElement;
        }

        public String getText() {
            return this.myQuickFix.getName();
        }

        public String getFamilyName() {
            return AndroidBundle.message("android.lint.quickfixes.family", new Object[0]);
        }

        public boolean isAvailable(Project project, Editor editor, PsiFile file) {
            return true;
        }

        public void invoke(Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            FileModificationService.getInstance().prepareFileForWrite(file);
            this.myQuickFix.apply(this.myStartElement, this.myEndElement, AndroidQuickfixContexts.EditorContext.getInstance(editor));
        }

        public boolean startInWriteAction() {
            return true;
        }
    }

    private static class MyDisableInspectionFix
    implements IntentionAction,
    Iconable {
        private final DisableInspectionToolAction myDisableInspectionToolAction;

        private MyDisableInspectionFix(HighlightDisplayKey key) {
            this.myDisableInspectionToolAction = new DisableInspectionToolAction(key);
        }

        public String getText() {
            return "Disable inspection";
        }

        public String getFamilyName() {
            return this.getText();
        }

        public boolean isAvailable(Project project, Editor editor, PsiFile file) {
            return true;
        }

        public void invoke(Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            this.myDisableInspectionToolAction.invoke(project, editor, file);
        }

        public boolean startInWriteAction() {
            return this.myDisableInspectionToolAction.startInWriteAction();
        }

        public Icon getIcon(@Iconable.IconFlags int flags) {
            return this.myDisableInspectionToolAction.getIcon(flags);
        }
    }
}

