/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.sdklib.SdkVersionInfo;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.Locale;
import org.jetbrains.android.inspections.lint.AddTargetVersionCheckQuickFix;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.inspections.lint.SuppressLintIntentionAction;
import org.jetbrains.android.util.AndroidBundle;

class AddTargetApiQuickFix
implements AndroidLintQuickFix {
    private int myApi;
    private PsiElement myElement;

    AddTargetApiQuickFix(int api, PsiElement element) {
        this.myApi = api;
        this.myElement = element;
    }

    private String getAnnotationValue(boolean fullyQualified) {
        return AddTargetVersionCheckQuickFix.getVersionField(this.myApi, fullyQualified);
    }

    @Override
    public String getName() {
        String key = this.getAnnotationValue(false);
        PsiFile file = (PsiFile)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PsiFile.class);
        if (file instanceof XmlFile) {
            return "Suppress With tools:targetApi Attribute";
        }
        return AndroidBundle.message("android.lint.fix.add.target.api", key);
    }

    @Override
    public boolean isApplicable(PsiElement startElement, PsiElement endElement, AndroidQuickfixContexts.ContextType contextType) {
        return PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiModifierListOwner.class, (boolean)false) != null || PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class, (boolean)false) != null;
    }

    @Override
    public void apply(PsiElement startElement, PsiElement endElement, AndroidQuickfixContexts.Context context) {
        PsiModifierListOwner container = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)startElement, (Class[])new Class[]{PsiMethod.class, PsiClass.class});
        if (container == null) {
            XmlFile file;
            XmlTag element = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class, (boolean)false);
            if (element != null && (file = (XmlFile)PsiTreeUtil.getParentOfType((PsiElement)element, XmlFile.class, (boolean)false)) != null) {
                SuppressLintIntentionAction.ensureNamespaceImported(element.getProject(), file, "http://schemas.android.com/tools");
                String codeName = SdkVersionInfo.getBuildCode((int)this.myApi);
                codeName = codeName == null ? Integer.toString(this.myApi) : codeName.toLowerCase(Locale.US);
                element.setAttribute("targetApi", "http://schemas.android.com/tools", codeName);
            }
            return;
        }
        while (container != null && container instanceof PsiAnonymousClass) {
            container = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)container, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiClass.class});
        }
        if (container == null) {
            return;
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)container)) {
            return;
        }
        PsiModifierList modifierList = container.getModifierList();
        if (modifierList != null) {
            Project project = startElement.getProject();
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            String annotationText = "@android.annotation.TargetApi(" + this.getAnnotationValue(true) + ")";
            PsiAnnotation newAnnotation = elementFactory.createAnnotationFromText(annotationText, (PsiElement)container);
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)container, (String[])new String[]{"android.annotation.TargetApi"});
            if (annotation != null && annotation.isPhysical()) {
                annotation.replace((PsiElement)newAnnotation);
            } else {
                PsiNameValuePair[] attributes = newAnnotation.getParameterList().getAttributes();
                AddAnnotationFix fix = new AddAnnotationFix("android.annotation.TargetApi", container, attributes, new String[0]);
                fix.invoke(project, null, container.getContainingFile());
            }
        }
    }
}

