/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.importDependencies;

import com.intellij.CommonBundle;
import com.intellij.ProjectTopics;
import com.intellij.ide.highlighter.ModuleFileType;
import com.intellij.ide.util.newProjectWizard.SourcePathsStep;
import com.intellij.ide.util.projectWizard.importSources.JavaModuleSourceRoot;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.ModuleAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.OrderedSet;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.importDependencies.AddModuleDependencyTask;
import org.jetbrains.android.importDependencies.CreateNewModuleTask;
import org.jetbrains.android.importDependencies.ImportDependenciesDialog;
import org.jetbrains.android.importDependencies.ImportDependenciesTask;
import org.jetbrains.android.importDependencies.ImportModuleTask;
import org.jetbrains.android.importDependencies.ImportSourceRootsDialog;
import org.jetbrains.android.importDependencies.ModuleProvider;
import org.jetbrains.android.importDependencies.ModuleProvidingTask;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;

public class ImportDependenciesUtil {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.importDependencies.ImportDependenciesUtil");
    private static final Key<Boolean> WAIT_FOR_IMPORTING_DEPENDENCIES_KEY = new Key("WAIT_FOR_IMPORTING_DEPENDENCIES_KEY");
    private static final Object LOCK = new Object();

    private ImportDependenciesUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importDependencies(final Module module, final boolean updateBackwardDependencies) {
        Object object = LOCK;
        synchronized (object) {
            final Project project = module.getProject();
            module.putUserData(WAIT_FOR_IMPORTING_DEPENDENCIES_KEY, (Object)Boolean.TRUE);
            if (project.getUserData(WAIT_FOR_IMPORTING_DEPENDENCIES_KEY) != Boolean.TRUE) {
                project.putUserData(WAIT_FOR_IMPORTING_DEPENDENCIES_KEY, (Object)Boolean.TRUE);
                StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(new Runnable(){

                    @Override
                    public void run() {
                        if (module.isLoaded()) {
                            ImportDependenciesUtil.importDependenciesForMarkedModules(project, updateBackwardDependencies);
                        } else {
                            final MessageBusConnection connection = module.getMessageBus().connect();
                            connection.subscribe(ProjectTopics.MODULES, (Object)new ModuleAdapter(){

                                public void moduleAdded(Project project, Module addedModule) {
                                    if (module.equals(addedModule)) {
                                        connection.disconnect();
                                        ImportDependenciesUtil.importDependenciesForMarkedModules(project, updateBackwardDependencies);
                                    }
                                }
                            });
                        }
                    }
                });
            }
        }
    }

    private static void importDependenciesForMarkedModules(final Project project, final boolean updateBackwardDependencies) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ImportDependenciesUtil.doImportDependenciesForMarkedModules(project, updateBackwardDependencies);
            }
        });
    }

    private static void doImportDependenciesForMarkedModules(Project project, boolean updateBackwardDependencies) {
        if (project.getUserData(WAIT_FOR_IMPORTING_DEPENDENCIES_KEY) != Boolean.TRUE) {
            return;
        }
        project.putUserData(WAIT_FOR_IMPORTING_DEPENDENCIES_KEY, null);
        ArrayList<Module> modulesToProcess = new ArrayList<Module>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (module.getUserData(WAIT_FOR_IMPORTING_DEPENDENCIES_KEY) != Boolean.TRUE) continue;
            module.putUserData(WAIT_FOR_IMPORTING_DEPENDENCIES_KEY, null);
            modulesToProcess.add(module);
        }
        ImportDependenciesUtil.doImportDependencies(project, modulesToProcess, updateBackwardDependencies);
    }

    public static void doImportDependencies(Project project, List<Module> modules, boolean updateBackwardDependencies) {
        OrderedSet tasks = new OrderedSet();
        ArrayList<MyUnresolvedDependency> unresolvedDependencies = new ArrayList<MyUnresolvedDependency>();
        for (Module module : modules) {
            ImportDependenciesUtil.importDependencies(module, updateBackwardDependencies, (List<ImportDependenciesTask>)tasks, unresolvedDependencies);
        }
        HashMap libDir2ModuleProvidingTask = new HashMap();
        for (ImportDependenciesTask task : tasks) {
            if (!(task instanceof ModuleProvidingTask)) continue;
            ModuleProvidingTask moduleProvidingTask = (ModuleProvidingTask)task;
            libDir2ModuleProvidingTask.put(moduleProvidingTask.getContentRoot(), moduleProvidingTask);
        }
        for (MyUnresolvedDependency unresolvedDependency : unresolvedDependencies) {
            ModuleProvidingTask taskProvidingDepModule = (ModuleProvidingTask)libDir2ModuleProvidingTask.get(unresolvedDependency.myLibDir);
            if (taskProvidingDepModule == null) continue;
            tasks.add(new AddModuleDependencyTask(unresolvedDependency.myModuleProvider, ModuleProvider.create(taskProvidingDepModule)));
        }
        if (tasks.size() > 0) {
            ImportDependenciesUtil.doImportDependencies(project, (List<ImportDependenciesTask>)tasks);
        }
    }

    private static void importDependencies(Module module, boolean updateBackwardDependencies, List<ImportDependenciesTask> tasks, List<MyUnresolvedDependency> unresolvedDependencies) {
        ImportDependenciesUtil.importDependencies(module, null, tasks, unresolvedDependencies);
        if (updateBackwardDependencies) {
            ImportDependenciesUtil.importBackwardDependencies(module, tasks, unresolvedDependencies);
        }
    }

    private static void doImportDependencies(Project project, List<ImportDependenciesTask> tasks) {
        ImportDependenciesDialog dialog = new ImportDependenciesDialog(project, tasks);
        dialog.show();
        if (dialog.getExitCode() != 0) {
            return;
        }
        List<ImportDependenciesTask> selectedTasks = dialog.getSelectedTasks();
        StringBuilder messageBuilder = new StringBuilder();
        boolean failed = false;
        ArrayList<CreateNewModuleTask> createNewModuleTasks = new ArrayList<CreateNewModuleTask>();
        for (ImportDependenciesTask selectedTask : selectedTasks) {
            Exception error = selectedTask.perform();
            if (error != null) {
                LOG.info((Throwable)error);
                if (messageBuilder.length() > 0) {
                    messageBuilder.append('\n');
                }
                messageBuilder.append(error.getMessage());
                failed = true;
                continue;
            }
            if (!(selectedTask instanceof CreateNewModuleTask)) continue;
            createNewModuleTasks.add((CreateNewModuleTask)selectedTask);
        }
        if (createNewModuleTasks.size() > 0) {
            ArrayList<JavaModuleSourceRoot> sourceRoots = new ArrayList<JavaModuleSourceRoot>();
            for (CreateNewModuleTask task : createNewModuleTasks) {
                String contentRootPath = task.getContentRoot().getPath();
                sourceRoots.addAll(SourcePathsStep.calculateSourceRoots((String)contentRootPath));
            }
            if (sourceRoots.size() > 0) {
                ImportSourceRootsDialog sourceRootsDialog = new ImportSourceRootsDialog(project, sourceRoots);
                sourceRootsDialog.show();
                if (sourceRootsDialog.getExitCode() == 0) {
                    ImportDependenciesUtil.addSourceRoots(project, sourceRootsDialog.getMarkedElements());
                }
            }
        }
        if (failed) {
            Messages.showErrorDialog((Project)project, (String)(AndroidBundle.message("android.import.dependencies.error.message.header", new Object[0]) + "\n" + messageBuilder.toString()), (String)CommonBundle.getErrorTitle());
        }
    }

    private static void addSourceRoots(final Project project, final List<JavaModuleSourceRoot> sourceRoots) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                for (JavaModuleSourceRoot sourceRootTrinity : sourceRoots) {
                    String path = sourceRootTrinity.getDirectory().getPath();
                    VirtualFile sourceRoot = LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.toSystemIndependentName((String)path));
                    if (sourceRoot == null) {
                        LOG.debug((Throwable)new Exception("Cannot find source root " + path));
                        continue;
                    }
                    Module module = ModuleUtil.findModuleForFile((VirtualFile)sourceRoot, (Project)project);
                    if (module == null) {
                        LOG.debug((Throwable)new Exception("Cannot find module for file " + sourceRoot.getPath()));
                        continue;
                    }
                    ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
                    ContentEntry[] entries = model.getContentEntries();
                    if (entries.length > 0) {
                        entries[0].addSourceFolder(sourceRoot, false, sourceRootTrinity.getPackagePrefix());
                    } else {
                        LOG.debug((Throwable)new Exception("Module " + module.getName() + " has no content entries"));
                    }
                    model.commit();
                }
            }
        });
    }

    private static VirtualFile findModuleFileChild(VirtualFile dir) {
        for (VirtualFile child : dir.getChildren()) {
            if (!(child.getFileType() instanceof ModuleFileType)) continue;
            return child;
        }
        return null;
    }

    private static void importDependencies(Module module, Module allowedDepModule, List<ImportDependenciesTask> tasks, List<MyUnresolvedDependency> unresolvedDependencies) {
        Project project = module.getProject();
        ModuleProvider moduleProvider = ModuleProvider.create(module);
        Pair<Properties, VirtualFile> pair = AndroidRootUtil.readProjectPropertyFile(module);
        if (pair != null) {
            ImportDependenciesUtil.doImportDependencies(module, allowedDepModule, tasks, unresolvedDependencies, project, moduleProvider, pair);
        }
    }

    private static void importDependenciesForNewModule(Project project, ModuleProvider newModuleProvider, VirtualFile newModuleContentRoot, List<ImportDependenciesTask> tasks, List<MyUnresolvedDependency> unresolvedDependencies) {
        Pair<Properties, VirtualFile> properties = AndroidRootUtil.readProjectPropertyFile(newModuleContentRoot);
        if (properties != null) {
            ImportDependenciesUtil.doImportDependencies(null, null, tasks, unresolvedDependencies, project, newModuleProvider, properties);
        }
    }

    private static void doImportDependencies(Module module, Module allowedDepModule, List<ImportDependenciesTask> tasks, List<MyUnresolvedDependency> unresolvedDependencies, Project project, ModuleProvider moduleProvider, Pair<Properties, VirtualFile> defaultProperties) {
        for (VirtualFile libDir : ImportDependenciesUtil.getLibDirs(defaultProperties)) {
            CreateNewModuleTask task;
            Module depModule = ModuleUtil.findModuleForFile((VirtualFile)libDir, (Project)project);
            if (depModule != null) {
                if (allowedDepModule != null && allowedDepModule != depModule || ArrayUtil.find((Object[])ModuleRootManager.getInstance((Module)depModule).getContentRoots(), (Object)libDir) < 0 || module != null && ModuleRootManager.getInstance((Module)module).isDependsOn(depModule)) continue;
                tasks.add(new AddModuleDependencyTask(moduleProvider, ModuleProvider.create(depModule)));
                continue;
            }
            VirtualFile libModuleFile = ImportDependenciesUtil.findModuleFileChild(libDir);
            ModuleProvidingTask moduleProvidingTask = task = libModuleFile != null && new File(libModuleFile.getPath()).exists() ? new ImportModuleTask(project, libModuleFile.getPath(), libDir) : new CreateNewModuleTask(project, libDir);
            if (!tasks.contains(task)) {
                tasks.add(task);
                ModuleProvider newModuleProvider = ModuleProvider.create(task);
                tasks.add(new AddModuleDependencyTask(moduleProvider, newModuleProvider));
                ImportDependenciesUtil.importDependenciesForNewModule(project, newModuleProvider, libDir, tasks, unresolvedDependencies);
                continue;
            }
            unresolvedDependencies.add(new MyUnresolvedDependency(moduleProvider, libDir));
        }
    }

    public static Set<VirtualFile> getLibDirs(Pair<Properties, VirtualFile> properties) {
        String libDirPath;
        HashSet resultSet = new HashSet();
        VirtualFile baseDir = ((VirtualFile)properties.second).getParent();
        int i = 1;
        do {
            VirtualFile libDir;
            if ((libDirPath = ((Properties)properties.first).getProperty("android.library.reference." + i)) != null && (libDir = AndroidUtils.findFileByAbsoluteOrRelativePath(baseDir, FileUtil.toSystemIndependentName((String)libDirPath))) != null) {
                resultSet.add(libDir);
            }
            ++i;
        } while (libDirPath != null);
        return resultSet;
    }

    private static void importBackwardDependencies(Module module, List<ImportDependenciesTask> tasks, List<MyUnresolvedDependency> unresolvedDependencies) {
        for (Module module1 : ModuleManager.getInstance((Project)module.getProject()).getModules()) {
            if (module1 == module) continue;
            ImportDependenciesUtil.importDependencies(module1, module, tasks, unresolvedDependencies);
        }
    }

    private static class MyUnresolvedDependency {
        final ModuleProvider myModuleProvider;
        final VirtualFile myLibDir;

        private MyUnresolvedDependency(ModuleProvider moduleProvider, VirtualFile libDir) {
            this.myModuleProvider = moduleProvider;
            this.myLibDir = libDir;
        }
    }
}

