/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.android.tools.idea.rendering.ResourceHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.util.ArrayUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ClassMapConstructor;

public class SimpleClassMapConstructor
implements ClassMapConstructor {
    private SimpleClassMapConstructor() {
    }

    public static SimpleClassMapConstructor getInstance() {
        return SimpleClassMapConstructorHolder.INSTANCE;
    }

    @Override
    public String[] getTagNamesByClass(final PsiClass c, final int apiLevel) {
        return (String[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<String[]>(){

            public String[] compute() {
                String name = c.getName();
                if (name != null) {
                    String qualifiedName = c.getQualifiedName();
                    if (qualifiedName != null) {
                        if (ResourceHelper.isClassPackageNeeded(qualifiedName, c, apiLevel)) {
                            return new String[]{qualifiedName};
                        }
                        return new String[]{name, qualifiedName};
                    }
                    return new String[]{name};
                }
                return ArrayUtil.EMPTY_STRING_ARRAY;
            }
        });
    }

    public static PsiClass findClassByTagName(AndroidFacet facet, String name, PsiClass baseClass) {
        PsiClass[] classes;
        Module module = facet.getModule();
        Project project = module.getProject();
        if (!name.contains(".")) {
            PsiClass[] classes2 = PsiShortNamesCache.getInstance((Project)project).getClassesByName(name, module.getModuleWithLibrariesScope());
            int apiLevel = facet.getModuleMinApi();
            for (PsiClass aClass : classes2) {
                String qualifiedName = aClass.getQualifiedName();
                if (qualifiedName == null || ResourceHelper.isClassPackageNeeded(qualifiedName, baseClass, apiLevel) || !aClass.isInheritor(baseClass, true)) continue;
                return aClass;
            }
            return null;
        }
        for (PsiClass aClass : classes = JavaPsiFacade.getInstance((Project)project).findClasses(name, module.getModuleWithDependenciesAndLibrariesScope(false))) {
            if (!aClass.isInheritor(baseClass, true)) continue;
            return aClass;
        }
        return null;
    }

    public static PsiClass findClassByTagName(AndroidFacet facet, String name, String baseClassQName) {
        PsiClass baseClass = JavaPsiFacade.getInstance((Project)facet.getModule().getProject()).findClass(baseClassQName, facet.getModule().getModuleWithLibrariesScope());
        return baseClass != null ? SimpleClassMapConstructor.findClassByTagName(facet, name, baseClass) : null;
    }

    private static class SimpleClassMapConstructorHolder {
        private static final SimpleClassMapConstructor INSTANCE = new SimpleClassMapConstructor();

        private SimpleClassMapConstructorHolder() {
        }
    }
}

