/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.android.builder.model.SourceProvider;
import com.android.tools.idea.model.AndroidModel;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;

public abstract class IdeaSourceProvider {
    public static Function<IdeaSourceProvider, List<VirtualFile>> MANIFEST_PROVIDER = new Function<IdeaSourceProvider, List<VirtualFile>>(){

        public List<VirtualFile> apply(IdeaSourceProvider provider) {
            VirtualFile manifestFile = provider.getManifestFile();
            return manifestFile == null ? Collections.emptyList() : Collections.singletonList(manifestFile);
        }
    };
    public static Function<IdeaSourceProvider, List<VirtualFile>> RES_PROVIDER = new Function<IdeaSourceProvider, List<VirtualFile>>(){

        public List<VirtualFile> apply(IdeaSourceProvider provider) {
            return Lists.newArrayList(provider.getResDirectories());
        }
    };
    public static Function<IdeaSourceProvider, List<VirtualFile>> JAVA_PROVIDER = new Function<IdeaSourceProvider, List<VirtualFile>>(){

        public List<VirtualFile> apply(IdeaSourceProvider provider) {
            return Lists.newArrayList(provider.getJavaDirectories());
        }
    };
    public static Function<IdeaSourceProvider, List<VirtualFile>> RESOURCES_PROVIDER = new Function<IdeaSourceProvider, List<VirtualFile>>(){

        public List<VirtualFile> apply(IdeaSourceProvider provider) {
            return Lists.newArrayList(provider.getResourcesDirectories());
        }
    };
    public static Function<IdeaSourceProvider, List<VirtualFile>> AIDL_PROVIDER = new Function<IdeaSourceProvider, List<VirtualFile>>(){

        public List<VirtualFile> apply(IdeaSourceProvider provider) {
            return Lists.newArrayList(provider.getAidlDirectories());
        }
    };
    public static Function<IdeaSourceProvider, List<VirtualFile>> JNI_PROVIDER = new Function<IdeaSourceProvider, List<VirtualFile>>(){

        public List<VirtualFile> apply(IdeaSourceProvider provider) {
            return Lists.newArrayList(provider.getJniDirectories());
        }
    };
    public static Function<IdeaSourceProvider, List<VirtualFile>> JNI_LIBS_PROVIDER = new Function<IdeaSourceProvider, List<VirtualFile>>(){

        public List<VirtualFile> apply(IdeaSourceProvider provider) {
            return Lists.newArrayList(provider.getJniLibsDirectories());
        }
    };
    public static Function<IdeaSourceProvider, List<VirtualFile>> ASSETS_PROVIDER = new Function<IdeaSourceProvider, List<VirtualFile>>(){

        public List<VirtualFile> apply(IdeaSourceProvider provider) {
            return Lists.newArrayList(provider.getAssetsDirectories());
        }
    };
    public static Function<IdeaSourceProvider, List<VirtualFile>> RS_PROVIDER = new Function<IdeaSourceProvider, List<VirtualFile>>(){

        public List<VirtualFile> apply(IdeaSourceProvider provider) {
            return Lists.newArrayList(provider.getRenderscriptDirectories());
        }
    };

    private IdeaSourceProvider() {
    }

    public static IdeaSourceProvider create(SourceProvider provider) {
        return new Gradle(provider);
    }

    private static List<IdeaSourceProvider> createAll(List<SourceProvider> providers) {
        ArrayList ideaProviders = Lists.newArrayList();
        for (SourceProvider provider : providers) {
            ideaProviders.add(IdeaSourceProvider.create(provider));
        }
        return ideaProviders;
    }

    public static IdeaSourceProvider create(AndroidFacet facet) {
        return new Legacy(facet);
    }

    public abstract String getName();

    public abstract VirtualFile getManifestFile();

    public abstract Collection<VirtualFile> getJavaDirectories();

    public abstract Collection<VirtualFile> getResourcesDirectories();

    public abstract Collection<VirtualFile> getAidlDirectories();

    public abstract Collection<VirtualFile> getRenderscriptDirectories();

    public abstract Collection<VirtualFile> getJniDirectories();

    public abstract Collection<VirtualFile> getJniLibsDirectories();

    public abstract Collection<VirtualFile> getResDirectories();

    public abstract Collection<VirtualFile> getAssetsDirectories();

    public static List<IdeaSourceProvider> getCurrentSourceProviders(AndroidFacet facet) {
        if (!facet.requiresAndroidModel()) {
            return Collections.singletonList(facet.getMainIdeaSourceProvider());
        }
        AndroidModel androidModel = facet.getAndroidModel();
        if (androidModel != null) {
            return IdeaSourceProvider.createAll(androidModel.getActiveSourceProviders());
        }
        return Collections.emptyList();
    }

    public static List<IdeaSourceProvider> getCurrentTestSourceProviders(AndroidFacet facet) {
        if (!facet.requiresAndroidModel()) {
            return Collections.emptyList();
        }
        AndroidModel androidModel = facet.getAndroidModel();
        if (androidModel != null) {
            return IdeaSourceProvider.createAll(androidModel.getTestSourceProviders());
        }
        return Collections.emptyList();
    }

    private Collection<VirtualFile> getAllSourceFolders() {
        ArrayList srcDirectories = Lists.newArrayList();
        srcDirectories.addAll(this.getJavaDirectories());
        srcDirectories.addAll(this.getResDirectories());
        srcDirectories.addAll(this.getAidlDirectories());
        srcDirectories.addAll(this.getRenderscriptDirectories());
        srcDirectories.addAll(this.getAssetsDirectories());
        srcDirectories.addAll(this.getJniDirectories());
        srcDirectories.addAll(this.getJniLibsDirectories());
        return srcDirectories;
    }

    private static Collection<File> getAllSourceFolders(SourceProvider provider) {
        ArrayList srcDirectories = Lists.newArrayList();
        srcDirectories.addAll(provider.getJavaDirectories());
        srcDirectories.addAll(provider.getResDirectories());
        srcDirectories.addAll(provider.getAidlDirectories());
        srcDirectories.addAll(provider.getRenderscriptDirectories());
        srcDirectories.addAll(provider.getAssetsDirectories());
        srcDirectories.addAll(provider.getCDirectories());
        srcDirectories.addAll(provider.getCppDirectories());
        srcDirectories.addAll(provider.getJniLibsDirectories());
        return srcDirectories;
    }

    public boolean containsFile(VirtualFile file) {
        Collection<VirtualFile> srcDirectories = this.getAllSourceFolders();
        if (file.equals(this.getManifestFile())) {
            return true;
        }
        for (VirtualFile container : srcDirectories) {
            if (!container.exists()) continue;
            if (VfsUtilCore.isAncestor((VirtualFile)container, (VirtualFile)file, (boolean)false)) {
                return true;
            }
            if (!file.equals(container.getParent())) continue;
            return true;
        }
        return false;
    }

    public static boolean isContainedBy(SourceProvider provider, File targetFolder) {
        Collection<File> srcDirectories = IdeaSourceProvider.getAllSourceFolders(provider);
        for (File container : srcDirectories) {
            if (FileUtil.isAncestor((File)targetFolder, (File)container, (boolean)false)) {
                return true;
            }
            if (!container.exists() || !VfsUtilCore.isAncestor((File)targetFolder, (File)container, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsFile(SourceProvider provider, File file) {
        Collection<File> srcDirectories = IdeaSourceProvider.getAllSourceFolders(provider);
        if (FileUtil.filesEqual((File)provider.getManifestFile(), (File)file)) {
            return true;
        }
        for (File container : srcDirectories) {
            File parent = container.getParentFile();
            if (parent != null && parent.isDirectory() && FileUtil.filesEqual((File)parent, (File)file)) {
                return true;
            }
            if (!container.exists() || !VfsUtilCore.isAncestor((File)container, (File)file, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public boolean isContainedBy(VirtualFile targetFolder) {
        Collection<VirtualFile> srcDirectories = this.getAllSourceFolders();
        for (VirtualFile container : srcDirectories) {
            if (!container.exists() || !VfsUtilCore.isAncestor((VirtualFile)targetFolder, (VirtualFile)container, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public static List<SourceProvider> getAllSourceProviders(AndroidFacet facet) {
        if (!facet.requiresAndroidModel() || facet.getAndroidModel() == null) {
            return Collections.singletonList(facet.getMainSourceProvider());
        }
        return facet.getAndroidModel().getAllSourceProviders();
    }

    public static List<IdeaSourceProvider> getAllIdeaSourceProviders(AndroidFacet facet) {
        if (!facet.requiresAndroidModel() || facet.getAndroidModel() == null) {
            return Collections.singletonList(facet.getMainIdeaSourceProvider());
        }
        return IdeaSourceProvider.createAll(IdeaSourceProvider.getAllSourceProviders(facet));
    }

    public static List<IdeaSourceProvider> getIdeaSourceProvidersForFile(AndroidFacet facet, VirtualFile targetFolder, IdeaSourceProvider defaultIdeaSourceProvider) {
        ArrayList sourceProviderList = Lists.newArrayList();
        if (targetFolder != null) {
            for (IdeaSourceProvider provider : IdeaSourceProvider.getAllIdeaSourceProviders(facet)) {
                if (!provider.containsFile(targetFolder) && !provider.isContainedBy(targetFolder)) continue;
                sourceProviderList.add(provider);
            }
        }
        if (sourceProviderList.isEmpty() && defaultIdeaSourceProvider != null) {
            sourceProviderList.add(defaultIdeaSourceProvider);
        }
        return sourceProviderList;
    }

    public static List<SourceProvider> getSourceProvidersForFile(AndroidFacet facet, VirtualFile targetFolder, SourceProvider defaultSourceProvider) {
        ArrayList sourceProviderList = Lists.newArrayList();
        if (targetFolder != null) {
            File targetIoFolder = VfsUtilCore.virtualToIoFile((VirtualFile)targetFolder);
            for (SourceProvider provider : IdeaSourceProvider.getAllSourceProviders(facet)) {
                if (!IdeaSourceProvider.containsFile(provider, targetIoFolder) && !IdeaSourceProvider.isContainedBy(provider, targetIoFolder)) continue;
                sourceProviderList.add(provider);
            }
        }
        if (sourceProviderList.isEmpty() && defaultSourceProvider != null) {
            sourceProviderList.add(defaultSourceProvider);
        }
        return sourceProviderList;
    }

    public static boolean isManifestFile(AndroidFacet facet, VirtualFile candidate) {
        if (candidate == null) {
            return false;
        }
        if (facet.requiresAndroidModel()) {
            for (IdeaSourceProvider provider : IdeaSourceProvider.getCurrentSourceProviders(facet)) {
                if (!candidate.equals(provider.getManifestFile())) continue;
                return true;
            }
            return false;
        }
        return candidate.equals(facet.getMainIdeaSourceProvider().getManifestFile());
    }

    public static List<VirtualFile> getManifestFiles(AndroidFacet facet) {
        VirtualFile main = facet.getMainIdeaSourceProvider().getManifestFile();
        if (!facet.requiresAndroidModel()) {
            return main != null ? Collections.singletonList(main) : Collections.emptyList();
        }
        ArrayList files = Lists.newArrayList();
        if (main != null) {
            files.add(main);
        }
        for (IdeaSourceProvider provider : IdeaSourceProvider.getCurrentSourceProviders(facet)) {
            VirtualFile manifest = provider.getManifestFile();
            if (manifest == null) continue;
            files.add(manifest);
        }
        return files;
    }

    private static class Legacy
    extends IdeaSourceProvider {
        private final AndroidFacet myFacet;

        private Legacy(AndroidFacet facet) {
            this.myFacet = facet;
        }

        @Override
        public String getName() {
            return "";
        }

        @Override
        public VirtualFile getManifestFile() {
            Module module = this.myFacet.getModule();
            VirtualFile file = AndroidRootUtil.getFileByRelativeModulePath(module, this.myFacet.getProperties().MANIFEST_FILE_RELATIVE_PATH, true);
            if (file != null) {
                return file;
            }
            VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
            if (contentRoots.length == 1) {
                return contentRoots[0].findChild("AndroidManifest.xml");
            }
            return null;
        }

        @Override
        public Collection<VirtualFile> getJavaDirectories() {
            Module module = this.myFacet.getModule();
            HashSet dirs = new HashSet();
            Collections.addAll(dirs, ModuleRootManager.getInstance((Module)module).getContentRoots());
            return dirs;
        }

        @Override
        public Collection<VirtualFile> getResourcesDirectories() {
            return Collections.emptySet();
        }

        @Override
        public Collection<VirtualFile> getAidlDirectories() {
            VirtualFile dir = AndroidRootUtil.getAidlGenDir(this.myFacet);
            assert (dir != null);
            return Collections.singleton(dir);
        }

        @Override
        public Collection<VirtualFile> getRenderscriptDirectories() {
            VirtualFile dir = AndroidRootUtil.getRenderscriptGenDir(this.myFacet);
            assert (dir != null);
            return Collections.singleton(dir);
        }

        @Override
        public Collection<VirtualFile> getJniDirectories() {
            return Collections.emptySet();
        }

        @Override
        public Collection<VirtualFile> getJniLibsDirectories() {
            return Collections.emptySet();
        }

        @Override
        public Collection<VirtualFile> getResDirectories() {
            String resRelPath = this.myFacet.getProperties().RES_FOLDER_RELATIVE_PATH;
            VirtualFile dir = AndroidRootUtil.getFileByRelativeModulePath(this.myFacet.getModule(), resRelPath, true);
            if (dir != null) {
                return Collections.singleton(dir);
            }
            return Collections.emptySet();
        }

        @Override
        public Collection<VirtualFile> getAssetsDirectories() {
            VirtualFile dir = AndroidRootUtil.getAssetsDir(this.myFacet);
            assert (dir != null);
            return Collections.singleton(dir);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Legacy that = (Legacy)o;
            return this.myFacet.equals((Object)that.myFacet);
        }

        public int hashCode() {
            return this.myFacet.hashCode();
        }
    }

    private static class Gradle
    extends IdeaSourceProvider {
        private final SourceProvider myProvider;
        private VirtualFile myManifestFile;
        private File myManifestIoFile;

        private Gradle(SourceProvider provider) {
            this.myProvider = provider;
        }

        @Override
        public String getName() {
            return this.myProvider.getName();
        }

        @Override
        public VirtualFile getManifestFile() {
            File manifestFile = this.myProvider.getManifestFile();
            if (this.myManifestFile == null || !FileUtil.filesEqual((File)manifestFile, (File)this.myManifestIoFile)) {
                this.myManifestIoFile = manifestFile;
                this.myManifestFile = VfsUtil.findFileByIoFile((File)manifestFile, (boolean)false);
            }
            return this.myManifestFile;
        }

        private static Collection<VirtualFile> convertFileSet(Collection<File> fileSet) {
            java.util.HashSet result = Sets.newHashSetWithExpectedSize((int)fileSet.size());
            LocalFileSystem fileSystem = LocalFileSystem.getInstance();
            for (File file : fileSet) {
                VirtualFile virtualFile = fileSystem.findFileByIoFile(file);
                if (virtualFile == null) continue;
                result.add(virtualFile);
            }
            return result;
        }

        @Override
        public Collection<VirtualFile> getJavaDirectories() {
            return Gradle.convertFileSet(this.myProvider.getJavaDirectories());
        }

        @Override
        public Collection<VirtualFile> getResourcesDirectories() {
            return Gradle.convertFileSet(this.myProvider.getResourcesDirectories());
        }

        @Override
        public Collection<VirtualFile> getAidlDirectories() {
            return Gradle.convertFileSet(this.myProvider.getAidlDirectories());
        }

        @Override
        public Collection<VirtualFile> getRenderscriptDirectories() {
            return Gradle.convertFileSet(this.myProvider.getRenderscriptDirectories());
        }

        @Override
        public Collection<VirtualFile> getJniDirectories() {
            java.util.HashSet jniDirectories = Sets.newHashSet();
            jniDirectories.addAll(Gradle.convertFileSet(this.myProvider.getCDirectories()));
            jniDirectories.addAll(Gradle.convertFileSet(this.myProvider.getCppDirectories()));
            return jniDirectories;
        }

        @Override
        public Collection<VirtualFile> getJniLibsDirectories() {
            return Gradle.convertFileSet(this.myProvider.getJniLibsDirectories());
        }

        @Override
        public Collection<VirtualFile> getResDirectories() {
            return Gradle.convertFileSet(this.myProvider.getResDirectories());
        }

        @Override
        public Collection<VirtualFile> getAssetsDirectories() {
            return Gradle.convertFileSet(this.myProvider.getAssetsDirectories());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Gradle that = (Gradle)o;
            if (!this.myProvider.getName().equals(that.getName())) {
                return false;
            }
            return this.myProvider.getManifestFile().getPath().equals(that.myProvider.getManifestFile().getPath());
        }

        public int hashCode() {
            return this.myProvider.getManifestFile().getPath().hashCode();
        }
    }
}

