/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.xml;

import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.dom.AndroidDomExtender;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.SimpleClassMapConstructor;

public class AndroidXmlResourcesUtil {
    public static final String APPWIDGET_PROVIDER_TAG_NAME = "appwidget-provider";
    public static final String SEARCHABLE_TAG_NAME = "searchable";
    public static final String KEYBOARD_TAG_NAME = "Keyboard";
    public static final String DEVICE_ADMIN_TAG_NAME = "device-admin";
    public static final String ACCOUNT_AUTHENTICATOR_TAG_NAME = "account-authenticator";
    public static final String PREFERENCE_HEADERS_TAG_NAME = "preference-headers";
    public static final Map<String, String> SPECIAL_STYLEABLE_NAMES = new HashMap();
    public static final String PREFERENCE_CLASS_NAME = "android.preference.Preference";
    private static final String[] ROOT_TAGS = new String[]{"appwidget-provider", "searchable", "Keyboard", "device-admin", "account-authenticator", "preference-headers"};
    private static final Set<String> ROOT_TAGS_SET;

    private AndroidXmlResourcesUtil() {
    }

    public static List<String> getPossibleRoots(AndroidFacet facet) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(AndroidDomUtil.removeUnambiguousNames(AndroidDomExtender.getPreferencesClassMap(facet)));
        result.addAll(Arrays.asList(ROOT_TAGS));
        return result;
    }

    public static boolean isSupportedRootTag(AndroidFacet facet, String rootTagName) {
        return ROOT_TAGS_SET.contains(rootTagName) || SimpleClassMapConstructor.findClassByTagName(facet, rootTagName, PREFERENCE_CLASS_NAME) != null;
    }

    static {
        SPECIAL_STYLEABLE_NAMES.put(APPWIDGET_PROVIDER_TAG_NAME, "AppWidgetProviderInfo");
        SPECIAL_STYLEABLE_NAMES.put(SEARCHABLE_TAG_NAME, "Searchable");
        SPECIAL_STYLEABLE_NAMES.put("actionkey", "SearchableActionKey");
        SPECIAL_STYLEABLE_NAMES.put("intent", "Intent");
        SPECIAL_STYLEABLE_NAMES.put(KEYBOARD_TAG_NAME, KEYBOARD_TAG_NAME);
        SPECIAL_STYLEABLE_NAMES.put("Row", "Keyboard_Row");
        SPECIAL_STYLEABLE_NAMES.put("Key", "Keyboard_Key");
        SPECIAL_STYLEABLE_NAMES.put(DEVICE_ADMIN_TAG_NAME, "DeviceAdmin");
        SPECIAL_STYLEABLE_NAMES.put(ACCOUNT_AUTHENTICATOR_TAG_NAME, "AccountAuthenticator");
        SPECIAL_STYLEABLE_NAMES.put("header", "PreferenceHeader");
        ROOT_TAGS_SET = new HashSet<String>(Arrays.asList(ROOT_TAGS));
    }
}

