/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.wrappers;

import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.IncorrectOperationException;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.android.dom.wrappers.ValueResourceElementWrapper;
import org.jetbrains.android.resourceManagers.ValueResourceInfo;

public class LazyValueResourceElementWrapper
extends RenameableFakePsiElement
implements PsiTarget,
Comparable<LazyValueResourceElementWrapper> {
    private final ValueResourceInfo myResourceInfo;
    private final PsiElement myParent;

    public LazyValueResourceElementWrapper(ValueResourceInfo resourceInfo, PsiElement parent) {
        super(parent);
        this.myParent = parent;
        this.myResourceInfo = resourceInfo;
    }

    public String getName() {
        return this.myResourceInfo.getName();
    }

    public PsiElement setName(String name) throws IncorrectOperationException {
        XmlAttributeValue element = this.computeElement();
        if (element == null) {
            throw new IncorrectOperationException("Cannot find resource '" + this.myResourceInfo.getName() + "' in file " + this.myResourceInfo.getContainingFile().getPath());
        }
        return new ValueResourceElementWrapper(element).setName(name);
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            public String getPresentableText() {
                String name = LazyValueResourceElementWrapper.this.myResourceInfo.getName();
                VirtualFile file = LazyValueResourceElementWrapper.this.myResourceInfo.getContainingFile();
                VirtualFile dir = file.getParent();
                if (dir == null) {
                    return name;
                }
                return name + " (..." + File.separatorChar + dir.getName() + File.separatorChar + file.getName() + ')';
            }

            public String getLocationString() {
                return null;
            }

            public Icon getIcon(boolean open) {
                return null;
            }
        };
    }

    public XmlAttributeValue computeElement() {
        return this.myResourceInfo.computeXmlElement();
    }

    public PsiElement getNavigationElement() {
        XmlAttributeValue element = this.myResourceInfo.computeXmlElement();
        return element != null ? element : this.myParent;
    }

    public ValueResourceInfo getResourceInfo() {
        return this.myResourceInfo;
    }

    public String getTypeName() {
        return "Android Value Resource";
    }

    public Icon getIcon() {
        return null;
    }

    public static PsiElement computeLazyElement(PsiElement element) {
        if (element instanceof LazyValueResourceElementWrapper) {
            element = ((LazyValueResourceElementWrapper)element).computeElement();
        }
        return element;
    }

    @Override
    public int compareTo(LazyValueResourceElementWrapper other) {
        return this.myResourceInfo.compareTo(other.myResourceInfo);
    }
}

