/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class StaticEnumConverter
extends ResolvingConverter<String> {
    private final Set<String> myValues = new HashSet<String>();

    public StaticEnumConverter(String ... values) {
        Collections.addAll(this.myValues, values);
    }

    public Collection<? extends String> getVariants(ConvertContext context) {
        return Collections.unmodifiableCollection(this.myValues);
    }

    public String fromString(String s, ConvertContext context) {
        return this.myValues.contains(s) ? s : null;
    }

    public String toString() {
        return "StaticEnumConverter " + this.myValues.toString();
    }

    public String toString(String s, ConvertContext context) {
        return s;
    }
}

