/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.tools.idea.model.AndroidModel;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PackageReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiPackageReference;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import org.jetbrains.android.AndroidApplicationPackageRenameProcessor;
import org.jetbrains.android.facet.AndroidFacet;

public class AndroidPackageConverter
extends Converter<String>
implements CustomReferenceConverter<String> {
    public String fromString(String s, ConvertContext context) {
        return s;
    }

    public String toString(String s, ConvertContext context) {
        return s;
    }

    public PsiReference[] createReferences(GenericDomValue<String> value, PsiElement element, ConvertContext context) {
        String s = value.getStringValue();
        return s != null ? new MyPackageReferenceSet(s, element).getPsiReferences() : PsiReference.EMPTY_ARRAY;
    }

    private static class MyPsiPackageReference
    extends PsiPackageReference {
        private final MyPackageReferenceSet myReferenceSet;
        private final TextRange myTextRange;

        public MyPsiPackageReference(MyPackageReferenceSet referenceSet, TextRange textRange, int index) {
            super((PackageReferenceSet)referenceSet, textRange, index);
            this.myReferenceSet = referenceSet;
            this.myTextRange = textRange;
        }

        public ResolveResult[] multiResolve(boolean incompleteCode) {
            return PsiElementResolveResult.createResults((PsiElement[])new PsiElement[]{this.myElement});
        }

        public boolean isReferenceTo(PsiElement element) {
            ResolveResult[] results;
            for (ResolveResult result : results = this.doMultiResolve()) {
                if (!this.getElement().getManager().areElementsEquivalent(result.getElement(), element)) continue;
                return true;
            }
            return false;
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            return this.myElement;
        }

        public PsiElement bindToElement(PsiElement element) throws IncorrectOperationException {
            if (!(element instanceof PsiPackage) || !(this.myElement instanceof XmlAttributeValue)) {
                throw new IncorrectOperationException("Cannot bind to " + element);
            }
            String newPackageName = ((PsiPackage)element).getQualifiedName();
            String basePackage = ((XmlAttributeValue)this.myElement).getValue();
            String oldPackageName = this.myElement.getText().substring(this.myReferenceSet.myStartInElement, this.myTextRange.getEndOffset());
            PsiFile file = this.myElement.getContainingFile();
            if (basePackage.length() > 0 && file instanceof XmlFile) {
                AndroidApplicationPackageRenameProcessor.processAllAttributesToUpdate((XmlFile)file, basePackage, oldPackageName, newPackageName, new Processor<Pair<GenericAttributeValue, String>>(){

                    public boolean process(Pair<GenericAttributeValue, String> pair) {
                        ((GenericAttributeValue)pair.getFirst()).setStringValue((String)pair.getSecond());
                        return true;
                    }
                });
            }
            return this.myElement;
        }
    }

    private static class MyPackageReferenceSet
    extends PackageReferenceSet {
        final int myStartInElement;

        public MyPackageReferenceSet(String s, PsiElement element) {
            this(s, element, ElementManipulators.getOffsetInElement((PsiElement)element));
        }

        public MyPackageReferenceSet(String str, PsiElement element, int startInElement) {
            super(str, element, startInElement);
            this.myStartInElement = startInElement;
        }

        protected PsiPackageReference createReference(TextRange range, int index) {
            AndroidModel androidModel;
            AndroidFacet facet = AndroidFacet.getInstance(this.getElement());
            if (facet != null && (androidModel = facet.getAndroidModel()) != null && androidModel.overridesManifestPackage()) {
                return new PsiPackageReference((PackageReferenceSet)this, range, index);
            }
            return new MyPsiPackageReference(this, range, index);
        }
    }
}

