/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.attrs;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.dom.attrs.AttributeFormat;

public class AttributeDefinition {
    private final String myName;
    private final List<String> myParentStyleables = ContainerUtil.newSmartList();
    private final Set<AttributeFormat> myFormats = EnumSet.noneOf(AttributeFormat.class);
    private final List<String> myValues = new ArrayList<String>();
    private final Map<String, String> myStyleable2DocValue = new HashMap<String, String>();
    private final Map<String, String> myValueDoc = new HashMap<String, String>();
    private String myGlobalDocValue;
    private String myAttrGroup;

    public AttributeDefinition(String name) {
        this(name, null, Collections.emptySet());
    }

    public AttributeDefinition(String name, String parentStyleableName, Collection<AttributeFormat> formats) {
        this.myName = name;
        if (parentStyleableName != null && !this.myParentStyleables.contains(parentStyleableName)) {
            this.myParentStyleables.add(parentStyleableName);
        }
        this.myFormats.addAll(formats);
    }

    public void addValue(String name) {
        this.myValues.add(name);
    }

    public String getName() {
        return this.myName;
    }

    public List<String> getParentStyleables() {
        return this.myParentStyleables;
    }

    public Set<AttributeFormat> getFormats() {
        return Collections.unmodifiableSet(this.myFormats);
    }

    public String getAttrGroup() {
        return this.myAttrGroup;
    }

    public void setAttrGroup(String attrGroup) {
        this.myAttrGroup = attrGroup;
    }

    public void addFormats(Collection<AttributeFormat> format) {
        this.myFormats.addAll(format);
    }

    public String[] getValues() {
        return ArrayUtil.toStringArray(this.myValues);
    }

    public String getDocValue(String parentStyleable) {
        if (parentStyleable == null || !this.myStyleable2DocValue.containsKey(parentStyleable)) {
            return this.myGlobalDocValue;
        }
        return this.myStyleable2DocValue.get(parentStyleable);
    }

    public void addDocValue(String docValue, String parentStyleable) {
        if (parentStyleable == null || this.myGlobalDocValue == null) {
            this.myGlobalDocValue = docValue;
        }
        if (parentStyleable != null) {
            this.myStyleable2DocValue.put(parentStyleable, docValue);
        }
    }

    public String toString() {
        return this.myName + " [" + this.myFormats + ']';
    }

    public void addValueDoc(String value, String doc) {
        this.myValueDoc.put(value, doc);
    }

    public String getValueDoc(String value) {
        return this.myValueDoc.get(value);
    }

    public boolean isValueDeprecated(String value) {
        String doc = this.myValueDoc.get(value);
        return doc != null && StringUtil.containsIgnoreCase((String)doc, (String)"deprecated");
    }
}

