/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileDescription;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;

public abstract class AndroidResourceDomFileDescription<T extends DomElement>
extends DomFileDescription<T> {
    private final String[] myResourceTypes;

    public AndroidResourceDomFileDescription(Class<T> rootElementClass, String rootTagName, String ... resourceTypes) {
        super(rootElementClass, rootTagName, new String[0]);
        this.myResourceTypes = resourceTypes;
    }

    public boolean isMyFile(XmlFile file, Module module) {
        return AndroidResourceDomFileDescription.doIsMyFile(file, this.myResourceTypes);
    }

    public static boolean doIsMyFile(final XmlFile file, final String[] resourceTypes) {
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                if (file.getProject().isDisposed()) {
                    return false;
                }
                for (String resourceType : resourceTypes) {
                    if (!AndroidResourceUtil.isInResourceSubdirectory((PsiFile)file, resourceType)) continue;
                    return AndroidFacet.getInstance((PsiElement)file) != null;
                }
                return false;
            }
        });
    }

    protected void initializeFileDescription() {
        this.registerNamespacePolicy("android", new String[]{"http://schemas.android.com/apk/res/android"});
    }

    public String[] getResourceTypes() {
        return this.myResourceTypes;
    }
}

