/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler.tools;

import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineBuilder;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.compiler.tools.AndroidDxRunner;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidCompilerMessageKind;

public class AndroidDxWrapper {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.compiler.tools.AndroidDx");

    private AndroidDxWrapper() {
    }

    public static Map<AndroidCompilerMessageKind, List<String>> execute(Module module, IAndroidTarget target, String outputDir, String[] compileTargets, String additionalVmParams, int maxHeapSize, boolean optimize) {
        Process process;
        BuildToolInfo buildToolInfo = target.getBuildToolInfo();
        if (buildToolInfo == null) {
            return Collections.singletonMap(AndroidCompilerMessageKind.ERROR, Collections.singletonList("No Build Tools in the Android SDK."));
        }
        String outFile = outputDir + File.separatorChar + "classes.dex";
        HashMap messages = new HashMap(2);
        messages.put(AndroidCompilerMessageKind.ERROR, new ArrayList());
        messages.put(AndroidCompilerMessageKind.INFORMATION, new ArrayList());
        messages.put(AndroidCompilerMessageKind.WARNING, new ArrayList());
        String dxJarPath = buildToolInfo.getPath(BuildToolInfo.PathId.DX_JAR);
        File dxJar = new File(dxJarPath);
        if (!dxJar.isFile()) {
            ((List)messages.get(AndroidCompilerMessageKind.ERROR)).add(AndroidBundle.message("android.file.not.exist.error", dxJarPath));
            return messages;
        }
        JavaParameters parameters = new JavaParameters();
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        assert (sdk != null);
        parameters.setJdk(sdk);
        parameters.setMainClass(AndroidDxRunner.class.getName());
        ParametersList programParamList = parameters.getProgramParametersList();
        programParamList.add(dxJarPath);
        programParamList.add(outFile);
        programParamList.add("--optimize", Boolean.toString(optimize));
        programParamList.addAll(compileTargets);
        programParamList.add("--exclude");
        ParametersList vmParamList = parameters.getVMParametersList();
        if (additionalVmParams.length() > 0) {
            vmParamList.addParametersString(additionalVmParams);
        }
        if (!AndroidCommonUtils.hasXmxParam((List)vmParamList.getParameters())) {
            vmParamList.add("-Xmx" + maxHeapSize + "M");
        }
        PathsList classPath = parameters.getClassPath();
        classPath.add(PathUtil.getJarPathForClass(AndroidDxRunner.class));
        classPath.add(PathUtil.getJarPathForClass(FileUtilRt.class));
        if (!new File(outFile).delete()) {
            LOG.info("Cannot delete file " + outFile);
        }
        try {
            GeneralCommandLine commandLine = CommandLineBuilder.createFromJavaParameters((SimpleJavaParameters)parameters, (boolean)true);
            LOG.info(commandLine.getCommandLineString());
            process = commandLine.createProcess();
        }
        catch (ExecutionException e) {
            ((List)messages.get(AndroidCompilerMessageKind.ERROR)).add("ExecutionException: " + e.getMessage());
            LOG.info((Throwable)e);
            return messages;
        }
        AndroidCommonUtils.handleDexCompilationResult((Process)process, (String)outFile, (Map)messages);
        return messages;
    }
}

