/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler;

import com.android.tools.idea.gradle.util.Projects;
import com.intellij.compiler.impl.BuildTargetScopeProvider;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerFilter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.artifacts.ArtifactPropertiesProvider;
import com.intellij.packaging.impl.compiler.ArtifactCompileScope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.compiler.artifact.AndroidApplicationArtifactProperties;
import org.jetbrains.android.compiler.artifact.AndroidApplicationArtifactType;
import org.jetbrains.android.compiler.artifact.AndroidArtifactPropertiesProvider;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.jps.api.CmdlineProtoUtil;
import org.jetbrains.jps.api.CmdlineRemoteProto;

public class AndroidBuildTargetScopeProvider
extends BuildTargetScopeProvider {
    private static boolean isProGuardUsed(Project project, CompileScope scope) {
        for (Module module : scope.getAffectedModules()) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null || !facet.getProperties().RUN_PROGUARD) continue;
            return true;
        }
        String proguardCfgPathsStr = (String)scope.getUserData(AndroidCompileUtil.PROGUARD_CFG_PATHS_KEY);
        if (proguardCfgPathsStr != null && proguardCfgPathsStr.length() > 0) {
            return true;
        }
        Set artifacts = ArtifactCompileScope.getArtifactsToBuild((Project)project, (CompileScope)scope, (boolean)false);
        for (Artifact artifact : artifacts) {
            AndroidApplicationArtifactProperties p;
            ArtifactProperties properties;
            if (!(artifact.getArtifactType() instanceof AndroidApplicationArtifactType) || !((properties = artifact.getProperties((ArtifactPropertiesProvider)AndroidArtifactPropertiesProvider.getInstance())) instanceof AndroidApplicationArtifactProperties) || !(p = (AndroidApplicationArtifactProperties)properties).isRunProGuard()) continue;
            return true;
        }
        return false;
    }

    public List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> getBuildTargetScopes(CompileScope baseScope, CompilerFilter filter, Project project, boolean forceBuild) {
        if (!ProjectFacetManager.getInstance((Project)project).hasFacets(AndroidFacet.ID) || Projects.requiresAndroidModel(project)) {
            return Collections.emptyList();
        }
        ArrayList<String> appTargetIds = new ArrayList<String>();
        ArrayList<String> libTargetIds = new ArrayList<String>();
        ArrayList<String> allTargetIds = new ArrayList<String>();
        ArrayList<String> manifestMergingTargetIds = new ArrayList<String>();
        boolean fullBuild = AndroidCompileUtil.isFullBuild(baseScope);
        for (Module module : baseScope.getAffectedModules()) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null) continue;
            allTargetIds.add(module.getName());
            if (!fullBuild) continue;
            if (facet.isLibraryProject()) {
                libTargetIds.add(module.getName());
                continue;
            }
            if (facet.getProperties().ENABLE_MANIFEST_MERGING) {
                manifestMergingTargetIds.add(module.getName());
            }
            appTargetIds.add(module.getName());
        }
        ArrayList<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> result = new ArrayList<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope>();
        result.add(CmdlineProtoUtil.createTargetsScope((String)"android-manifest-merging", manifestMergingTargetIds, (boolean)forceBuild));
        if (fullBuild && !AndroidBuildTargetScopeProvider.isProGuardUsed(project, baseScope)) {
            result.add(CmdlineProtoUtil.createTargetsScope((String)"android-pre-dex", Collections.singletonList("only"), (boolean)forceBuild));
        }
        result.addAll(Arrays.asList(CmdlineProtoUtil.createTargetsScope((String)"android-aar-deps", appTargetIds, (boolean)forceBuild), CmdlineProtoUtil.createTargetsScope((String)"android-dex", appTargetIds, (boolean)forceBuild), CmdlineProtoUtil.createTargetsScope((String)"android-resource-caching", allTargetIds, (boolean)forceBuild), CmdlineProtoUtil.createTargetsScope((String)"android-resource-packaging", appTargetIds, (boolean)forceBuild), CmdlineProtoUtil.createTargetsScope((String)"android-packaging", appTargetIds, (boolean)forceBuild), CmdlineProtoUtil.createTargetsScope((String)"android-library-packaging", libTargetIds, (boolean)forceBuild)));
        return result;
    }
}

