/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.augment;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.navigation.NavigationItem;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiVariableEx;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.impl.light.LightIdentifier;
import com.intellij.psi.impl.light.LightModifierList;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.ui.RowIcon;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.Icon;

class AndroidLightField
extends LightElement
implements PsiField,
PsiVariableEx,
NavigationItem {
    private final PsiClass myContext;
    private final PsiType myType;
    private final Object myConstantValue;
    private volatile PsiExpression myInitializer;
    private volatile String myName;
    private volatile LightModifierList myModifierList;

    public AndroidLightField(String name, PsiClass context, PsiType type, boolean isFinal, Object constantValue) {
        super(context.getManager(), (Language)JavaLanguage.INSTANCE);
        this.myName = name;
        this.myType = type;
        this.myContext = context;
        this.myConstantValue = constantValue;
        ArrayList<String> modifiers = new ArrayList<String>();
        modifiers.add("public");
        modifiers.add("static");
        if (isFinal) {
            modifiers.add("final");
        }
        this.myModifierList = new LightModifierList(this.getManager(), this.getLanguage(), ArrayUtil.toStringArray(modifiers));
    }

    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isFieldEquivalentTo((PsiField)this, (PsiElement)another);
    }

    public PsiElement getParent() {
        return this.myContext;
    }

    public PsiFile getContainingFile() {
        return this.myContext.getContainingFile();
    }

    public PsiElement setName(String name) throws IncorrectOperationException {
        this.myName = name;
        return this;
    }

    public Object computeConstantValue(Set<PsiVariable> visitedVars) {
        return this.computeConstantValue();
    }

    public Object computeConstantValue() {
        return this.myConstantValue;
    }

    public void setInitializer(PsiExpression initializer) throws IncorrectOperationException {
        this.myInitializer = initializer;
    }

    public PsiExpression getInitializer() {
        return this.myInitializer;
    }

    public PsiDocComment getDocComment() {
        return null;
    }

    public boolean isDeprecated() {
        return false;
    }

    public PsiClass getContainingClass() {
        return this.myContext;
    }

    public String toString() {
        return "AndroidLightField:" + this.getName();
    }

    public PsiType getType() {
        return this.myType;
    }

    public PsiModifierList getModifierList() {
        return this.myModifierList;
    }

    public boolean hasModifierProperty(String name) {
        return this.myModifierList.hasModifierProperty(name);
    }

    public String getName() {
        return this.myName;
    }

    public PsiTypeElement getTypeElement() {
        return null;
    }

    public boolean hasInitializer() {
        return false;
    }

    public void normalizeDeclaration() throws IncorrectOperationException {
    }

    public PsiIdentifier getNameIdentifier() {
        return new LightIdentifier(this.getManager(), this.myName);
    }

    protected boolean isVisibilitySupported() {
        return true;
    }

    public Icon getElementIcon(int flags) {
        RowIcon baseIcon = ElementPresentationUtil.createLayeredIcon((Icon)PlatformIcons.FIELD_ICON, (PsiModifierListOwner)this, (boolean)false);
        return ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)this, (int)flags, (RowIcon)baseIcon);
    }
}

