/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.augment;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.android.augment.AndroidLightClassBase;

public abstract class AndroidLightClass
extends AndroidLightClassBase {
    private final PsiClass myContainingClass;
    protected final String myName;

    protected AndroidLightClass(PsiClass context, String name) {
        super(context.getManager());
        this.myContainingClass = context;
        this.myName = name;
    }

    public String toString() {
        return "AndroidRClass";
    }

    @Override
    public void checkAdd(PsiElement element) throws IncorrectOperationException {
        throw new IncorrectOperationException("Cannot add elements to R class");
    }

    @Override
    public PsiElement add(PsiElement element) throws IncorrectOperationException {
        return this.myContainingClass.add(element);
    }

    @Override
    public PsiElement addBefore(PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        return this.myContainingClass.addBefore(element, anchor);
    }

    @Override
    public PsiElement addAfter(PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        return this.myContainingClass.addAfter(element, anchor);
    }

    public String getQualifiedName() {
        return this.myContainingClass.getQualifiedName() + '.' + this.myName;
    }

    public PsiElement getNavigationElement() {
        return this.myContainingClass;
    }

    public PsiClass getContainingClass() {
        return this.myContainingClass;
    }

    public String getName() {
        return this.myName;
    }

    public PsiElement getParent() {
        return this.myContainingClass;
    }
}

