/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.resources.ResourceType;
import com.intellij.CommonBundle;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.android.actions.CreateXmlResourcePanel;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.dom.resources.Resources;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;

public class CreateXmlResourceDialog
extends DialogWrapper {
    final CreateXmlResourcePanel myPanel;

    public CreateXmlResourceDialog(Module module, ResourceType resourceType, String predefinedName, String predefinedValue, boolean chooseName) {
        this(module, resourceType, predefinedName, predefinedValue, chooseName, null);
    }

    public CreateXmlResourceDialog(Module module, ResourceType resourceType, String predefinedName, String predefinedValue, boolean chooseName, VirtualFile defaultFile) {
        super(module.getProject());
        this.myPanel = new CreateXmlResourcePanel(module, resourceType, predefinedName, predefinedValue, chooseName, defaultFile);
        this.init();
    }

    protected ValidationInfo doValidate() {
        return this.myPanel.doValidate();
    }

    protected void doOKAction() {
        String resourceName = this.myPanel.getResourceName();
        String fileName = this.myPanel.getFileName();
        List<String> dirNames = this.myPanel.getDirNames();
        Module module = this.myPanel.getModule();
        JComponent panel = this.myPanel.getPanel();
        if (resourceName.length() == 0) {
            Messages.showErrorDialog((Component)panel, (String)"Resource name is not specified", (String)CommonBundle.getErrorTitle());
        } else if (!AndroidResourceUtil.isCorrectAndroidResourceName(resourceName)) {
            Messages.showErrorDialog((Component)panel, (String)(resourceName + " is not correct resource name"), (String)CommonBundle.getErrorTitle());
        } else if (fileName.length() == 0) {
            Messages.showErrorDialog((Component)panel, (String)"File name is not specified", (String)CommonBundle.getErrorTitle());
        } else if (dirNames.size() == 0) {
            Messages.showErrorDialog((Component)panel, (String)"Directories are not selected", (String)CommonBundle.getErrorTitle());
        } else if (module == null) {
            Messages.showErrorDialog((Component)panel, (String)"Module is not specified", (String)CommonBundle.getErrorTitle());
        } else {
            super.doOKAction();
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPanel.getPreferredFocusedComponent();
    }

    protected String getDimensionServiceKey() {
        return "AndroidCreateXmlResourceDialog";
    }

    protected JComponent createCenterPanel() {
        return this.myPanel.getPanel();
    }

    public Module getModule() {
        return this.myPanel.getModule();
    }

    public String getResourceName() {
        return this.myPanel.getResourceName();
    }

    public String getFileName() {
        return this.myPanel.getFileName();
    }

    public List<String> getDirNames() {
        return this.myPanel.getDirNames();
    }

    public String getValue() {
        return this.myPanel.getValue();
    }

    public static ValidationInfo checkIfResourceAlreadyExists(Module selectedModule, String resourceName, ResourceType resourceType, List<String> dirNames, String fileName) {
        VirtualFile resourceDir;
        if (resourceName.length() == 0 || dirNames.size() == 0 || fileName.length() == 0) {
            return null;
        }
        AndroidFacet facet = AndroidFacet.getInstance(selectedModule);
        VirtualFile virtualFile = resourceDir = facet != null ? facet.getPrimaryResourceDir() : null;
        if (resourceDir == null) {
            return null;
        }
        for (String directoryName : dirNames) {
            VirtualFile resFile;
            VirtualFile resourceSubdir = resourceDir.findChild(directoryName);
            if (resourceSubdir == null || (resFile = resourceSubdir.findChild(fileName)) == null) continue;
            if (resFile.getFileType() != StdFileTypes.XML) {
                return new ValidationInfo("File " + FileUtil.toSystemDependentName((String)resFile.getPath()) + " is not XML file");
            }
            Resources resources = AndroidUtils.loadDomElement(selectedModule, resFile, Resources.class);
            if (resources == null) {
                return new ValidationInfo(AndroidBundle.message("not.resource.file.error", FileUtil.toSystemDependentName((String)resFile.getPath())));
            }
            for (ResourceElement element : AndroidResourceUtil.getValueResourcesFromElement(resourceType.getName(), resources)) {
                if (!resourceName.equals(element.getName().getValue())) continue;
                return new ValidationInfo("resource '" + resourceName + "' already exists in " + FileUtil.toSystemDependentName((String)resFile.getPath()));
            }
        }
        return null;
    }
}

