/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.propertyTable;

import com.intellij.codeInsight.documentation.DocumentationManager;

public class JavadocParser {
    private static final String[] TAGS = new String[]{"{see ", "{@see ", "{@link "};

    public static String build(String title, String javadoc) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<html><head><style type=\"text/css\">p {margin: 5px 0;}</style></head><body>");
        buffer.append("<p><b>").append(title).append("</b> - ");
        for (String tag : TAGS) {
            javadoc = JavadocParser.convertLink(javadoc, tag);
        }
        javadoc = javadoc.replaceAll("<code>", "<i>");
        javadoc = javadoc.replaceAll("</code>", "</i>");
        buffer.append(javadoc);
        return buffer.append("</body></html>").toString();
    }

    private static String convertLink(String javadoc, String tag) {
        StringBuilder buffer = new StringBuilder();
        int length = javadoc.length();
        int start = 0;
        while (true) {
            String text;
            String href;
            int index;
            if ((index = javadoc.indexOf(tag, start)) == -1) break;
            buffer.append(javadoc.substring(start, index));
            int linkStart = index + tag.length();
            int end = javadoc.indexOf(125, linkStart);
            String linkValue = javadoc.substring(linkStart, end).trim();
            int spaceIndex = linkValue.indexOf(32);
            if (spaceIndex != -1) {
                href = linkValue.substring(0, spaceIndex);
                text = linkValue.substring(spaceIndex + 1);
            } else {
                href = text = linkValue;
            }
            text = text.replace('#', '.');
            DocumentationManager.createHyperlink((StringBuilder)buffer, (String)href, (String)text, (boolean)true);
            start = end + 1;
        }
        buffer.append(javadoc.substring(start, length));
        return buffer.toString();
    }
}

