/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.propertyTable;

import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.propertyTable.IXmlAttributeLocator;
import com.intellij.designer.model.PropertiesContainer;
import com.intellij.designer.model.Property;
import com.intellij.designer.propertyTable.PropertyEditor;
import com.intellij.designer.propertyTable.PropertyRenderer;
import com.intellij.designer.propertyTable.renderers.LabelPropertyRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlAttribute;
import java.util.List;

public class FragmentProperty
extends Property<RadViewComponent>
implements IXmlAttributeLocator {
    private final String myAttribute;
    private final PropertyRenderer myRenderer = new LabelPropertyRenderer(null);
    private final PropertyEditor myEditor;
    private final String myJavadocText;
    private final String myNamespace;

    public FragmentProperty(String name, String namespace, PropertyEditor editor, String javadocText) {
        super(null, name);
        this.myNamespace = namespace;
        this.myEditor = editor;
        this.myJavadocText = javadocText;
        this.setImportant(true);
        this.myAttribute = name;
    }

    public Property<RadViewComponent> createForNewPresentation(Property parent, String name) {
        return null;
    }

    public Object getValue(RadViewComponent component) throws Exception {
        String value = component.getTag().getAttributeValue(this.myAttribute, this.myNamespace);
        return value == null ? "" : value;
    }

    public void setValue(final RadViewComponent component, final Object value) throws Exception {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                if (StringUtil.isEmpty((String)((String)value))) {
                    XmlAttribute attribute = component.getTag().getAttribute(FragmentProperty.this.myAttribute, FragmentProperty.this.myNamespace);
                    if (attribute != null) {
                        attribute.delete();
                    }
                } else {
                    component.getTag().setAttribute(FragmentProperty.this.myAttribute, FragmentProperty.this.myNamespace, (String)value);
                }
            }
        });
    }

    public boolean isDefaultValue(RadViewComponent component) throws Exception {
        return component.getTag().getAttribute(this.myAttribute, this.myNamespace) == null;
    }

    public void setDefaultValue(RadViewComponent component) throws Exception {
        if (component.getTag().getAttribute(this.myAttribute, this.myNamespace) != null) {
            this.setValue(component, null);
        }
    }

    public boolean availableFor(List<PropertiesContainer> components) {
        return false;
    }

    public PropertyRenderer getRenderer() {
        return this.myRenderer;
    }

    public PropertyEditor getEditor() {
        return this.myEditor;
    }

    public String getJavadocText() {
        return this.myJavadocText;
    }

    @Override
    public boolean checkAttribute(RadViewComponent component, XmlAttribute attribute) {
        return component.getTag().getAttribute(this.myAttribute, this.myNamespace) == attribute;
    }
}

