/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model.layout.relative;

import com.intellij.android.designer.designSurface.feedbacks.TextFeedback;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.designer.designSurface.FeedbackLayer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;

public class MultiLineTooltipManager {
    private static final int OFFSET_X = 20;
    private static final int OFFSET_Y = 20;
    private final TextFeedback[] myTextFeedbacks;
    private final Dimension[] mySizes;
    private final boolean[] myVisible;
    private final FeedbackLayer myLayer;

    public MultiLineTooltipManager(FeedbackLayer layer, int maxLines) {
        this.myLayer = layer;
        this.myTextFeedbacks = new TextFeedback[maxLines];
        this.mySizes = new Dimension[maxLines];
        this.myVisible = new boolean[maxLines];
    }

    public TextFeedback getFeedback(int line) {
        assert (line < this.myTextFeedbacks.length);
        TextFeedback feedback = this.myTextFeedbacks[line];
        if (feedback == null) {
            this.myTextFeedbacks[line] = feedback = new TextFeedback();
            this.myLayer.add((Component)((Object)feedback));
        }
        return feedback;
    }

    public void setVisible(int line, boolean visible) {
        this.myVisible[line] = visible;
    }

    public void dispose() {
        for (TextFeedback feedback : this.myTextFeedbacks) {
            if (feedback == null) continue;
            this.myLayer.remove((Component)((Object)feedback));
        }
    }

    private Dimension getPreferredSize() {
        int width = 0;
        int height = 0;
        for (int i = 0; i < this.myTextFeedbacks.length; ++i) {
            TextFeedback feedback = this.myTextFeedbacks[i];
            if (feedback == null || !this.myVisible[i]) continue;
            Dimension preferredSize = feedback.getPreferredSize();
            width = Math.max(width, preferredSize.width);
            height += preferredSize.height;
            this.mySizes[i] = preferredSize;
        }
        return new Dimension(width += 2, height += 2);
    }

    public void update(RadViewComponent container, Point mouseLocation) {
        Rectangle bounds = container.getBounds((Component)this.myLayer);
        Dimension preferredSize = this.getPreferredSize();
        int x = bounds.x + bounds.width / 2 - preferredSize.width / 2;
        int y = bounds.y - 1 - preferredSize.height;
        if (y < 0) {
            y = bounds.y + bounds.height - preferredSize.height - 1;
        }
        for (int i = 0; i < this.myTextFeedbacks.length; ++i) {
            TextFeedback feedback = this.myTextFeedbacks[i];
            if (feedback == null) continue;
            if (this.myVisible[i]) {
                int height = this.mySizes[i].height;
                feedback.setBounds(x, y, preferredSize.width, height);
                y += height;
                feedback.setVisible(true);
                continue;
            }
            feedback.setVisible(false);
        }
    }

    public void update(boolean below, boolean toRightOf, int x, int y) {
        Dimension preferredSize = this.getPreferredSize();
        if (below) {
            y += 20;
        } else {
            y -= 20;
            y -= preferredSize.height;
        }
        if (toRightOf) {
            x += 20;
        } else {
            x -= 20;
            x -= preferredSize.width;
        }
        for (int i = 0; i < this.myTextFeedbacks.length; ++i) {
            TextFeedback feedback = this.myTextFeedbacks[i];
            if (feedback == null) continue;
            if (this.myVisible[i]) {
                int height = this.mySizes[i].height;
                feedback.setBounds(x, y, preferredSize.width, height);
                y += height;
                feedback.setVisible(true);
                continue;
            }
            feedback.setVisible(false);
        }
    }
}

