/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model.layout.relative;

import com.android.tools.lint.detector.api.LintUtils;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.layout.relative.ConstraintType;
import com.intellij.designer.model.RadComponent;
import com.intellij.psi.xml.XmlAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DependencyGraph {
    private static final String KEY = "DependencyGraph";
    private static final String DEPENDENCY_FORMAT = "%1$s %2$s %3$s";
    private final Map<RadViewComponent, ViewData> myNodeToView = new HashMap<RadViewComponent, ViewData>();

    public static DependencyGraph get(RadViewComponent layout) {
        DependencyGraph graph = (DependencyGraph)layout.getClientProperty(KEY);
        if (graph == null) {
            graph = new DependencyGraph(layout);
            layout.setClientProperty(KEY, graph);
        }
        return graph;
    }

    public static void refresh(RadViewComponent layout) {
        layout.extractClientProperty(KEY);
    }

    private DependencyGraph(RadViewComponent layout) {
        List<RadComponent> nodes = layout.getChildren();
        String parentId = layout.getId();
        parentId = parentId != null ? LintUtils.stripIdPrefix((String)parentId) : "RelativeLayout";
        ViewData parentView = new ViewData(layout, parentId);
        this.myNodeToView.put(layout, parentView);
        HashMap<String, ViewData> idToView = new HashMap<String, ViewData>();
        idToView.put(parentId, parentView);
        for (RadViewComponent child : RadViewComponent.getViewComponents(nodes)) {
            String id = child.getId();
            if (id != null) {
                id = LintUtils.stripIdPrefix((String)id);
            }
            ViewData view = new ViewData(child, id);
            this.myNodeToView.put(child, view);
            if (id == null) continue;
            idToView.put(id, view);
        }
        for (ViewData view : this.myNodeToView.values()) {
            for (XmlAttribute attribute : view.node.getTag().getAttributes()) {
                String name = attribute.getLocalName();
                ConstraintType type = ConstraintType.fromAttribute(name);
                if (type == null) continue;
                String value = attribute.getValue();
                if (type.targetParent) {
                    if (!"true".equals(value)) continue;
                    Constraint constraint = new Constraint(type, view, parentView);
                    view.dependsOn.add(constraint);
                    parentView.dependedOnBy.add(constraint);
                    continue;
                }
                String targetId = LintUtils.stripIdPrefix((String)value);
                ViewData target = (ViewData)idToView.get(targetId);
                if (target == view || target == null) continue;
                Constraint constraint = new Constraint(type, view, target);
                view.dependsOn.add(constraint);
                target.dependedOnBy.add(constraint);
            }
        }
    }

    public ViewData getView(RadViewComponent node) {
        return this.myNodeToView.get((Object)node);
    }

    public Set<RadViewComponent> dependsOn(Collection<? extends RadViewComponent> nodes, boolean vertical) {
        ArrayList<ViewData> reachable = new ArrayList<ViewData>();
        HashSet<ViewData> visiting = new HashSet<ViewData>();
        for (RadViewComponent radViewComponent : nodes) {
            ViewData view = this.myNodeToView.get((Object)radViewComponent);
            if (view == null) continue;
            this.findBackwards(view, visiting, reachable, vertical, view);
        }
        HashSet<RadViewComponent> dependents = new HashSet<RadViewComponent>(reachable.size());
        for (ViewData v : reachable) {
            dependents.add(v.node);
        }
        return dependents;
    }

    private void findBackwards(ViewData view, Set<ViewData> visiting, List<ViewData> reachable, boolean vertical, ViewData start) {
        visiting.add(view);
        reachable.add(view);
        for (Constraint constraint : view.dependedOnBy) {
            if (vertical && !constraint.type.verticalEdge || !vertical && !constraint.type.horizontalEdge) continue;
            assert (constraint.to == view);
            ViewData from = constraint.from;
            if (visiting.contains(from)) {
                List<Constraint> path = this.getPathTo(start.node, view.node, vertical);
                if (path == null) continue;
            }
            this.findBackwards(from, visiting, reachable, vertical, start);
        }
        visiting.remove(view);
    }

    public List<Constraint> getPathTo(RadViewComponent from, RadViewComponent to, boolean vertical) {
        HashSet<ViewData> visiting = new HashSet<ViewData>();
        ArrayList<Constraint> path = new ArrayList<Constraint>();
        ViewData view = this.myNodeToView.get((Object)from);
        if (view != null) {
            return DependencyGraph.findForwards(view, visiting, path, vertical, to);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Constraint> findForwards(ViewData view, Set<ViewData> visiting, List<Constraint> path, boolean vertical, RadViewComponent target) {
        visiting.add(view);
        for (Constraint constraint : view.dependsOn) {
            if (vertical && !constraint.type.verticalEdge || !vertical && !constraint.type.horizontalEdge) continue;
            try {
                List<Constraint> chain;
                path.add(constraint);
                if (constraint.to.node == target) {
                    ArrayList<Constraint> arrayList = new ArrayList<Constraint>(path);
                    return arrayList;
                }
                assert (constraint.from == view);
                ViewData to = constraint.to;
                if (visiting.contains(to) || (chain = DependencyGraph.findForwards(to, visiting, path, vertical, target)) == null) continue;
                List<Constraint> list = chain;
                return list;
            }
            finally {
                path.remove(constraint);
            }
        }
        visiting.remove(view);
        return null;
    }

    static class Constraint {
        public final ConstraintType type;
        public final ViewData from;
        public final ViewData to;

        Constraint(ConstraintType type, ViewData from, ViewData to) {
            this.type = type;
            this.from = from;
            this.to = to;
        }

        static String describePath(List<Constraint> path, String newName, String newId) {
            String s = "";
            for (int i = path.size() - 1; i >= 0; --i) {
                Constraint constraint = path.get(i);
                String suffix = i == path.size() - 1 ? constraint.to.id : s;
                s = String.format(DependencyGraph.DEPENDENCY_FORMAT, constraint.from.id, Constraint.stripLayoutAttributePrefix(constraint.type.name), suffix);
            }
            if (newName != null) {
                s = String.format(DependencyGraph.DEPENDENCY_FORMAT, s, Constraint.stripLayoutAttributePrefix(newName), newId != null ? LintUtils.stripIdPrefix((String)newId) : "?");
            }
            return s;
        }

        private static String stripLayoutAttributePrefix(String name) {
            if (name.startsWith("layout_")) {
                return name.substring("layout_".length());
            }
            return name;
        }
    }

    static class ViewData {
        public final RadViewComponent node;
        public final String id;
        public final List<Constraint> dependsOn = new ArrayList<Constraint>(4);
        public final List<Constraint> dependedOnBy = new ArrayList<Constraint>(8);

        ViewData(RadViewComponent node, String id) {
            this.node = node;
            this.id = id;
        }
    }
}

