/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model.layout.actions;

import com.intellij.android.designer.model.RadComponentOperations;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.layout.Gravity;
import com.intellij.android.designer.model.layout.actions.AbstractGravityAction;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.model.RadComponent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Function;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;

public class AllGravityAction
extends AbstractGravityAction<Gravity> {
    private List<Gravity> mySelection;

    public AllGravityAction(DesignerEditorPanel designer, List<? extends RadViewComponent> components) {
        super(designer, components);
        this.setItems(Arrays.asList(Gravity.values()), null);
    }

    @Override
    protected DefaultActionGroup createPopupActionGroup(JComponent button) {
        Iterator iterator = this.myComponents.iterator();
        int flags = 0;
        if (iterator.hasNext()) {
            flags = Gravity.getFlags((RadComponent)iterator.next());
            while (iterator.hasNext()) {
                if (flags == Gravity.getFlags((RadComponent)iterator.next())) continue;
                flags = 0;
                break;
            }
        }
        this.mySelection = Gravity.flagToValues(flags);
        return super.createPopupActionGroup(button);
    }

    @Override
    protected void update(Gravity item, Presentation presentation, boolean popup) {
        if (popup) {
            presentation.setIcon(this.mySelection.contains((Object)item) ? CHECKED : null);
            presentation.setText(item.name());
        }
    }

    @Override
    protected boolean selectionChanged(Gravity item) {
        int index = this.mySelection.indexOf((Object)item);
        if (index == -1) {
            this.mySelection.add(item);
        } else {
            this.mySelection.remove(index);
        }
        this.execute(new Runnable(){

            @Override
            public void run() {
                if (AllGravityAction.this.mySelection.isEmpty()) {
                    for (RadViewComponent component : AllGravityAction.this.myComponents) {
                        RadComponentOperations.deleteAttribute((RadComponent)component, "layout_gravity");
                    }
                } else {
                    String value = StringUtil.join((Collection)AllGravityAction.this.mySelection, (Function)new Function<Gravity, String>(){

                        public String fun(Gravity gravity) {
                            return gravity.name();
                        }
                    }, (String)"|");
                    for (RadViewComponent component : AllGravityAction.this.myComponents) {
                        XmlTag tag = component.getTag();
                        tag.setAttribute("layout_gravity", "http://schemas.android.com/apk/res/android", value);
                    }
                }
            }
        });
        return false;
    }

    @Override
    public void setSelection(Gravity selection) {
    }
}

