/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model.grid;

import com.intellij.designer.model.RadComponent;
import com.intellij.util.ArrayUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;

public class GridInfo {
    public int width;
    public int height;
    public int[] hLines = ArrayUtil.EMPTY_INT_ARRAY;
    public int[] vLines = ArrayUtil.EMPTY_INT_ARRAY;
    public boolean[] emptyColumns = ArrayUtil.EMPTY_BOOLEAN_ARRAY;
    public boolean[] emptyRows = ArrayUtil.EMPTY_BOOLEAN_ARRAY;
    public RadComponent grid;
    public RadComponent[][] components;
    public int rowCount;
    public int columnCount;
    public int lastInsertRow = -1;
    public int lastInsertColumn = -1;
    private static final int NEW_CELL_SIZE = 32;

    public GridInfo(RadComponent grid) {
        this.grid = grid;
    }

    public Dimension getSize(Component target) {
        return this.grid.fromModel(target, new Dimension(this.width, this.height));
    }

    public Point getCellPosition(Component target, int row, int column) {
        Dimension size = this.grid.fromModel(target, new Dimension(this.vLines[column], this.hLines[row]));
        return new Point(size.width, size.height);
    }

    public static int[] addLineInfo(int[] oldLines, int delta) {
        if (delta > 0) {
            int newLength = oldLines.length + delta / 32;
            if (newLength > oldLines.length) {
                int[] newLines = new int[newLength];
                int startIndex = oldLines.length;
                if (oldLines.length > 0) {
                    System.arraycopy(oldLines, 0, newLines, 0, oldLines.length);
                } else {
                    startIndex = 1;
                }
                for (int i = startIndex; i < newLength; ++i) {
                    newLines[i] = newLines[i - 1] + 32;
                }
                return newLines;
            }
            return oldLines;
        }
        return oldLines;
    }

    public static void setNull(RadComponent[][] components1, RadComponent[][] components2, int startRow, int endRow, int startColumn, int endColumn) {
        endRow = Math.min(endRow, components1.length);
        endColumn = Math.min(endColumn, components1[0].length);
        for (int i = startRow; i < endRow; ++i) {
            for (int j = startColumn; j < endColumn; ++j) {
                components1[i][j] = null;
                if (components2 == null) continue;
                components2[i][j] = null;
            }
        }
    }
}

