/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model;

import com.intellij.android.designer.model.PropertyParser;
import com.intellij.android.designer.model.RadModelBuilder;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.morphing.RelativeLayout;
import com.intellij.designer.model.MetaModel;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.model.RadLayout;
import com.intellij.openapi.application.ApplicationManager;
import java.lang.reflect.Method;
import java.util.List;

public class ComponentMorphingTool {
    protected final RadViewComponent myOldComponent;
    protected final RadViewComponent myNewComponent;

    public ComponentMorphingTool(RadViewComponent oldComponent, RadViewComponent newComponent, MetaModel newModel, RadLayout newLayout) throws Exception {
        this.myOldComponent = oldComponent;
        this.myNewComponent = newComponent;
        newComponent.setMetaModel(newModel);
        if (newLayout != null) {
            newComponent.setLayout(newLayout);
        }
        if (newComponent != oldComponent) {
            RadComponent parent = oldComponent.getParent();
            newComponent.setParent(parent);
            List parentChildren = parent.getChildren();
            parentChildren.set(parentChildren.indexOf((Object)oldComponent), newComponent);
            newComponent.setTag(oldComponent.getTag());
            this.convertChildren();
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                ComponentMorphingTool.this.convertTag();
                ComponentMorphingTool.this.myNewComponent.getTag().setName(ComponentMorphingTool.this.myNewComponent.getMetaModel().getTag());
            }
        });
        PropertyParser propertyParser = RadModelBuilder.getPropertyParser((RadComponent)newComponent);
        if (propertyParser != null) {
            propertyParser.load(newComponent);
            this.loadChildProperties(propertyParser);
        }
    }

    protected void convertChildren() throws Exception {
        List<RadComponent> oldChildren = this.myOldComponent.getChildren();
        this.myNewComponent.getChildren().addAll(oldChildren);
        for (RadComponent childComponent : oldChildren) {
            childComponent.setParent((RadComponent)this.myNewComponent);
        }
    }

    protected void convertTag() {
    }

    protected void loadChildProperties(PropertyParser propertyParser) throws Exception {
        for (RadComponent childComponent : this.myNewComponent.getChildren()) {
            propertyParser.load((RadViewComponent)childComponent);
        }
    }

    public RadViewComponent result() {
        return this.myNewComponent;
    }

    public static RadViewComponent convert(RadViewComponent component, MetaModel target) throws Exception {
        ClassLoader classLoader = ComponentMorphingTool.class.getClassLoader();
        Class<?> sourceConverterClass = classLoader.loadClass("com.intellij.android.designer.model.morphing." + component.getMetaModel().getTag());
        Object sourceConverter = sourceConverterClass.newInstance();
        try {
            Method method = sourceConverterClass.getMethod(target.getTag(), RadViewComponent.class, MetaModel.class);
            return (RadViewComponent)((Object)method.invoke(sourceConverter, new Object[]{component, target}));
        }
        catch (NoSuchMethodException e) {
            if ("RelativeLayout".equals(target.getTag())) {
                return RelativeLayout.RelativeLayout(component, target);
            }
            throw e;
        }
    }
}

