/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.designSurface.layout.grid;

import com.intellij.android.designer.designSurface.AbstractEditOperation;
import com.intellij.android.designer.designSurface.feedbacks.TextFeedback;
import com.intellij.android.designer.designSurface.graphics.DesignerGraphics;
import com.intellij.android.designer.designSurface.graphics.DrawingStyle;
import com.intellij.android.designer.designSurface.graphics.InsertFeedback;
import com.intellij.android.designer.model.grid.GridInfo;
import com.intellij.android.designer.model.grid.GridInsertType;
import com.intellij.android.designer.model.grid.IGridProvider;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.FeedbackLayer;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.model.RadComponent;
import com.intellij.ui.IdeBorderFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;

public abstract class GridOperation
extends AbstractEditOperation {
    private GridFeedback myFeedback;
    private InsertFeedback myInsertFeedback;
    private TextFeedback myTextFeedback;
    private Rectangle myBounds;
    protected int myColumn;
    protected int myRow;
    protected GridInsertType myInsertType;
    protected boolean myHasCellComponents;
    private static final int CROSS_SIZE = 10;

    public GridOperation(RadComponent container, OperationContext context) {
        super(container, context);
    }

    protected final GridInfo getGridInfo() {
        return ((IGridProvider)this.myContainer).getVirtualGridInfo();
    }

    private void createFeedback() {
        if (this.myFeedback == null) {
            FeedbackLayer layer = this.myContext.getArea().getFeedbackLayer();
            this.myInsertFeedback = new InsertFeedback(DrawingStyle.DROP_ZONE_ACTIVE);
            layer.add((Component)((Object)this.myInsertFeedback));
            this.myBounds = this.myContainer.getBounds((Component)layer);
            this.myFeedback = new GridFeedback();
            this.myFeedback.setBounds(this.myBounds);
            layer.add((Component)this.myFeedback);
            this.myTextFeedback = new TextFeedback();
            this.myTextFeedback.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)3, (int)2, (int)0));
            layer.add((Component)((Object)this.myTextFeedback));
            layer.repaint();
        }
    }

    public void showFeedback() {
        this.createFeedback();
        this.calculateGridInfo();
        this.configureTextFeedback();
        this.myFeedback.repaint();
    }

    private void configureTextFeedback() {
        this.myTextFeedback.clear();
        int row = this.myRow;
        int column = this.myColumn;
        this.myTextFeedback.append("[");
        if (this.myInsertType == GridInsertType.before_h_cell) {
            this.myTextFeedback.append("before ");
        } else if (this.myInsertType == GridInsertType.after_h_cell) {
            this.myTextFeedback.append("after ");
        } else if (this.myInsertType != GridInsertType.in_cell) {
            this.myTextFeedback.append("insert: ");
            if (this.myInsertType == GridInsertType.corner_top_right) {
                ++column;
            } else if (this.myInsertType == GridInsertType.corner_bottom_left) {
                ++row;
            } else if (this.myInsertType == GridInsertType.corner_bottom_right) {
                ++row;
                ++column;
            }
        }
        this.myTextFeedback.append("row ");
        this.myTextFeedback.bold(Integer.toString(row));
        this.myTextFeedback.append(", ");
        if (this.myInsertType == GridInsertType.before_v_cell) {
            this.myTextFeedback.append("before ");
        } else if (this.myInsertType == GridInsertType.after_v_cell) {
            this.myTextFeedback.append("after ");
        }
        this.myTextFeedback.append("column ");
        this.myTextFeedback.bold(Integer.toString(column));
        this.myTextFeedback.append("]");
        this.myTextFeedback.centerTop(this.myBounds);
    }

    public void eraseFeedback() {
        if (this.myFeedback != null) {
            FeedbackLayer layer = this.myContext.getArea().getFeedbackLayer();
            layer.remove((Component)((Object)this.myInsertFeedback));
            layer.remove((Component)this.myFeedback);
            layer.remove((Component)((Object)this.myTextFeedback));
            layer.repaint();
            this.myFeedback = null;
            this.myInsertFeedback = null;
            this.myTextFeedback = null;
        }
    }

    public boolean canExecute() {
        return this.myComponents.size() == 1 && (this.myInsertType != GridInsertType.in_cell || !this.myHasCellComponents);
    }

    @Override
    public abstract void execute() throws Exception;

    private void updateRowAndColumn(Point location, GridInfo gridInfo) {
        RadComponent grid = gridInfo.grid;
        Point modelLocation = grid.toModel((Component)this.myContext.getArea().getNativeComponent(), location);
        modelLocation.x -= grid.getBounds().x;
        modelLocation.y -= grid.getBounds().y;
        this.myColumn = GridOperation.getLineIndex(gridInfo.vLines, modelLocation.x);
        this.myRow = GridOperation.getLineIndex(gridInfo.hLines, modelLocation.y);
    }

    private void calculateGridInfo() {
        GridInfo gridInfo = this.getGridInfo();
        Point location = this.myContext.getLocation();
        this.updateRowAndColumn(location, gridInfo);
        Rectangle bounds = gridInfo.grid.fromModel((Component)this.myContext.getArea().getNativeComponent(), gridInfo.grid.getBounds());
        location.x -= bounds.x;
        location.y -= bounds.y;
        this.myInsertType = GridInsertType.in_cell;
        if (gridInfo.components == null) {
            this.myHasCellComponents = false;
            this.myInsertFeedback.setVisible(false);
            return;
        }
        this.myHasCellComponents = this.hasComponents(this.myRow, this.myColumn);
        Rectangle cellRect = this.getInsertRect(this.myHasCellComponents);
        Rectangle dropCellRect = GridOperation.getInsertInCellRect(cellRect);
        boolean cellExists = GridOperation.cellExists(gridInfo.components, this.myRow, this.myColumn);
        if (dropCellRect.contains(location)) {
            this.myInsertFeedback.setVisible(false);
            return;
        }
        if (location.x <= dropCellRect.x) {
            if (location.y <= dropCellRect.y) {
                if (cellExists) {
                    this.myInsertType = GridInsertType.corner_top_left;
                    this.myInsertFeedback.cross(this.myBounds.x + cellRect.x, this.myBounds.y + cellRect.y, 10);
                }
            } else if (dropCellRect.y < location.y && (double)location.y < dropCellRect.getMaxY()) {
                if (this.myHasCellComponents && (this.myColumn == 0 || this.hasComponents(this.myRow, this.myColumn - 1))) {
                    boolean insert = true;
                    if (this.isMoveOperation() && (this.myColumn != 0 || this.getMovedIndex(false) == 0)) {
                        boolean bl = insert = !this.isSingleMovedAxis(false);
                    }
                    if (insert) {
                        this.myInsertType = GridInsertType.before_v_cell;
                        cellRect = this.getInsertRect(false);
                        this.myInsertFeedback.vertical(this.myBounds.x + cellRect.x, this.myBounds.y + cellRect.y, cellRect.height);
                    }
                }
            } else if (cellExists) {
                this.myInsertType = GridInsertType.corner_bottom_left;
                this.myInsertFeedback.cross(this.myBounds.x + cellRect.x, this.myBounds.y + cellRect.y + cellRect.height, 10);
            }
        } else if ((double)location.x >= dropCellRect.getMaxX()) {
            if (location.y <= dropCellRect.y) {
                if (cellExists) {
                    this.myInsertType = GridInsertType.corner_top_right;
                    this.myInsertFeedback.cross(this.myBounds.x + cellRect.x + cellRect.width, this.myBounds.y + cellRect.y, 10);
                }
            } else if (dropCellRect.y < location.y && (double)location.y < dropCellRect.getMaxY()) {
                if (!(!this.myHasCellComponents || this.myColumn != gridInfo.lastInsertColumn && !this.hasComponents(this.myRow, this.myColumn + 1) || this.isMoveOperation() && this.isSingleMovedAxis(false))) {
                    this.myInsertType = GridInsertType.after_v_cell;
                    cellRect = this.getInsertRect(false);
                    this.myInsertFeedback.vertical(this.myBounds.x + cellRect.x + cellRect.width, this.myBounds.y + cellRect.y, cellRect.height);
                }
            } else if (cellExists) {
                this.myInsertType = GridInsertType.corner_bottom_right;
                this.myInsertFeedback.cross(this.myBounds.x + cellRect.x + cellRect.width, this.myBounds.y + cellRect.y + cellRect.height, 10);
            }
        } else if (location.y <= dropCellRect.y) {
            if (this.myHasCellComponents && (this.myRow == 0 || this.hasComponents(this.myRow - 1, this.myColumn))) {
                boolean insert = true;
                if (this.isMoveOperation() && (this.myRow != 0 || this.getMovedIndex(true) == 0)) {
                    boolean bl = insert = !this.isSingleMovedAxis(true);
                }
                if (insert) {
                    this.myInsertType = GridInsertType.before_h_cell;
                    cellRect = this.getInsertRect(false);
                    this.myInsertFeedback.horizontal(this.myBounds.x + cellRect.x, this.myBounds.y + cellRect.y, cellRect.width);
                }
            }
        } else if (!(!((double)location.y >= dropCellRect.getMaxY()) || !this.myHasCellComponents || this.myRow != gridInfo.lastInsertRow && !this.hasComponents(this.myRow + 1, this.myColumn) || this.isMoveOperation() && this.isSingleMovedAxis(true))) {
            this.myInsertType = GridInsertType.after_h_cell;
            cellRect = this.getInsertRect(false);
            this.myInsertFeedback.horizontal(this.myBounds.x + cellRect.x, this.myBounds.y + cellRect.y + cellRect.height, cellRect.width);
        }
    }

    protected boolean isMoveOperation() {
        return this.myContext.isMove();
    }

    private static int getLineIndex(int[] line, int location) {
        for (int i = 0; i < line.length - 1; ++i) {
            if (line[i] > location || location > line[i + 1]) continue;
            return i;
        }
        return Math.max(0, line.length - 1);
    }

    protected static boolean rowExists(RadComponent[][] components, int row) {
        return components != null && row >= 0 && components.length > row;
    }

    protected static boolean cellExists(RadComponent[][] components, int row, int column) {
        return components != null && 0 <= row && row < components.length && 0 <= column && column < components[0].length;
    }

    private boolean hasComponents(int row, int column) {
        RadComponent[][] components = this.getGridInfo().components;
        return GridOperation.cellExists(components, row, column) && components[row][column] != null;
    }

    private Rectangle getInsertRect(boolean includeSpans) {
        int startColumn;
        GridInfo gridInfo = this.getGridInfo();
        int endColumn = this.myColumn + 1;
        int startRow = this.myRow;
        int endRow = this.myRow + 1;
        if (includeSpans) {
            RadComponent[] columnComponents = gridInfo.components[this.myRow];
            RadComponent existComponent = columnComponents[startColumn];
            for (startColumn = this.myColumn; startColumn > 0 && columnComponents[startColumn - 1] == existComponent; --startColumn) {
            }
            while (endColumn < columnComponents.length && columnComponents[endColumn] == existComponent) {
                ++endColumn;
            }
            while (startRow > 0 && gridInfo.components[startRow - 1][startColumn] == existComponent) {
                --startRow;
            }
            while (endRow < gridInfo.components.length && gridInfo.components[endRow][startColumn] == existComponent) {
                ++endRow;
            }
        }
        EditableArea area = this.myContext.getArea();
        JComponent target = area.getNativeComponent();
        int x1 = startColumn < gridInfo.vLines.length ? gridInfo.getCellPosition((Component)target, (int)0, (int)startColumn).x : 0;
        int x2 = endColumn < gridInfo.vLines.length ? gridInfo.getCellPosition((Component)target, (int)0, (int)endColumn).x : gridInfo.getSize((Component)target).width;
        int y1 = startRow < gridInfo.hLines.length ? gridInfo.getCellPosition((Component)target, (int)startRow, (int)0).y : 0;
        int y2 = endRow < gridInfo.hLines.length ? gridInfo.getCellPosition((Component)target, (int)endRow, (int)0).y : gridInfo.getSize((Component)target).height;
        return new Rectangle(x1, y1, x2 - x1, y2 - y1);
    }

    private static Rectangle getInsertInCellRect(Rectangle cellRect) {
        int borderWidth = Math.min(cellRect.width / 3, 10);
        int borderHeight = Math.min(cellRect.height / 3, 10);
        return new Rectangle(cellRect.x + borderWidth, cellRect.y + borderHeight, cellRect.width - 2 * borderWidth, cellRect.height - 2 * borderHeight);
    }

    protected abstract int getMovedIndex(boolean var1);

    protected abstract boolean isSingleMovedAxis(boolean var1);

    protected final int getSizeInRow(int rowIndex, RadComponent excludeComponent) {
        int size = 0;
        RadComponent[][] components = this.getGridInfo().components;
        if (rowIndex < components.length) {
            RadComponent[] rowComponents = components[rowIndex];
            for (int j = 0; j < rowComponents.length; ++j) {
                RadComponent cellComponent = rowComponents[j];
                if (cellComponent == null) continue;
                if (cellComponent != excludeComponent) {
                    ++size;
                }
                while (j + 1 < rowComponents.length && cellComponent == rowComponents[j + 1]) {
                    ++j;
                }
            }
        }
        return size;
    }

    protected final int getSizeInColumn(int columnIndex, int columnCount, RadComponent excludeComponent) {
        int size = 0;
        RadComponent[][] components = this.getGridInfo().components;
        if (columnIndex < columnCount) {
            for (int j = 0; j < components.length; ++j) {
                RadComponent cellComponent = components[j][columnIndex];
                if (cellComponent == null) continue;
                if (cellComponent != excludeComponent) {
                    ++size;
                }
                while (j + 1 < components.length && cellComponent == components[j + 1][columnIndex]) {
                    ++j;
                }
            }
        }
        return size;
    }

    private class GridFeedback
    extends JComponent {
        private GridFeedback() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            DesignerGraphics.useStroke(DrawingStyle.DROP_ZONE, g);
            GridInfo gridInfo = GridOperation.this.getGridInfo();
            Dimension size = gridInfo.getSize(this);
            if (gridInfo.vLines.length > 0 && gridInfo.hLines.length > 0) {
                for (int column = 0; column < gridInfo.vLines.length; ++column) {
                    int x = gridInfo.getCellPosition((Component)this, (int)0, (int)column).x;
                    g.drawLine(x, 0, x, size.height);
                }
                for (int row = 0; row < gridInfo.hLines.length; ++row) {
                    int y = gridInfo.getCellPosition((Component)this, (int)row, (int)0).y;
                    g.drawLine(0, y, size.width, y);
                }
            }
            g.drawRect(0, 0, size.width - 1, size.height - 1);
            g.drawRect(1, 1, size.width - 3, size.height - 3);
            DesignerGraphics.drawRect(DrawingStyle.DROP_RECIPIENT, g, 0, 0, size.width, size.height);
            Rectangle cellRect = GridOperation.this.getInsertRect(GridOperation.this.myHasCellComponents);
            if (!GridOperation.this.canExecute()) {
                DesignerGraphics.drawFilledRect(DrawingStyle.INVALID, g, cellRect.x, cellRect.y, cellRect.width + 1, cellRect.height + 1);
                return;
            }
            if (GridOperation.this.myInsertType == GridInsertType.in_cell) {
                DesignerGraphics.drawFilledRect(DrawingStyle.DROP_ZONE_ACTIVE, g, cellRect.x, cellRect.y, cellRect.width + 1, cellRect.height + 1);
            }
        }
    }
}

