/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.designSurface.graphics;

import com.intellij.ui.Gray;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;

public class DrawingStyle {
    public static final boolean SHOW_STATIC_GRID = false;
    public static final boolean SHOW_STATIC_BORDERS = false;
    public static final int MAX_MATCH_DISTANCE = 20;
    private static final BasicStroke SOLID_STROKE = new BasicStroke(1.0f);
    private static final BasicStroke THICK_SOLID_STROKE = new BasicStroke(2.0f);
    private static final BasicStroke DOTTED_STROKE = new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{2.0f, 2.0f}, 0.0f);
    private static final BasicStroke DASHED_STROKE = new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{4.0f, 4.0f}, 0.0f);
    private static final BasicStroke PATTERN_STROKE = new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{8.0f, 4.0f}, 0.0f);
    private static final BasicStroke THICK_PATTERN_STROKE = new BasicStroke(2.0f, 2, 0, 10.0f, new float[]{8.0f, 4.0f}, 0.0f);
    public static final Gray DESIGNER_BACKGROUND_COLOR = Gray._150;
    public static final DrawingStyle SELECTION = new DrawingStyle(new Color(0, 153, 255, 192), new Color(0, 153, 255, 32), SOLID_STROKE);
    public static final DrawingStyle GUIDELINE = new DrawingStyle(new Color(0, 170, 0, 192), SOLID_STROKE);
    public static final DrawingStyle GUIDELINE_SHADOW = new DrawingStyle(new Color(0, 170, 0, 192), SOLID_STROKE);
    public static final DrawingStyle GUIDELINE_DASHED = new DrawingStyle(new Color(0, 170, 0, 192), PATTERN_STROKE);
    public static final DrawingStyle DISTANCE = new DrawingStyle(new Color(255, 0, 0, 160), SOLID_STROKE);
    public static final DrawingStyle GRID = new DrawingStyle(new Color(170, 170, 170, 128), DOTTED_STROKE);
    public static final DrawingStyle HOVER = new DrawingStyle(new Color(127, 127, 127, 100), new Color(255, 255, 255, 40), DOTTED_STROKE);
    public static final DrawingStyle HOVER_SELECTION = new DrawingStyle(new Color(127, 127, 127, 100), new Color(255, 255, 255, 10), DOTTED_STROKE);
    public static final DrawingStyle ANCHOR = new DrawingStyle(new Color(0, 153, 255, 96), SOLID_STROKE);
    public static final DrawingStyle OUTLINE = new DrawingStyle(new Color(136, 255, 136, 160), SOLID_STROKE);
    public static final DrawingStyle DROP_RECIPIENT = new DrawingStyle(new Color(255, 153, 0, 255), new Color(255, 153, 0, 160), THICK_SOLID_STROKE);
    public static final DrawingStyle DROP_ZONE = new DrawingStyle(new Color(0, 170, 0, 220), new Color(85, 170, 0, 64), SOLID_STROKE);
    public static final DrawingStyle DROP_ZONE_ACTIVE = new DrawingStyle(new Color(0, 170, 0, 220), new Color(0, 170, 0, 64), THICK_SOLID_STROKE);
    public static final DrawingStyle DROP_PREVIEW = new DrawingStyle(new Color(255, 153, 0, 255), null, THICK_PATTERN_STROKE);
    public static final DrawingStyle RESIZE_PREVIEW = new DrawingStyle(new Color(255, 153, 0, 255), null, THICK_SOLID_STROKE);
    public static final DrawingStyle RESIZE_FAIL = new DrawingStyle(new Color(255, 153, 0, 255), null, THICK_PATTERN_STROKE);
    public static final DrawingStyle HELP = new DrawingStyle(new Color(255, 255, 255, 255), new Color(0, 0, 0, 128), SOLID_STROKE);
    public static final DrawingStyle INVALID = new DrawingStyle(new Color(255, 255, 255, 192), new Color(255, 0, 0, 64), THICK_SOLID_STROKE);
    public static final DrawingStyle DEPENDENCY = new DrawingStyle(new Color(255, 255, 255, 255), new Color(255, 255, 0, 24), THICK_SOLID_STROKE);
    public static final DrawingStyle CYCLE = new DrawingStyle(new Color(255, 0, 0, 192), null, SOLID_STROKE);
    public static final DrawingStyle DRAGGED = new DrawingStyle(new Color(255, 255, 255, 255), new Color(0, 255, 0, 16), THICK_SOLID_STROKE);
    public static final DrawingStyle EMPTY = new DrawingStyle(new Color(0, 0, 0, 128), new Color(255, 255, 85, 255), DASHED_STROKE);
    public static final DrawingStyle CUSTOM1 = new DrawingStyle(new Color(255, 0, 255, 255), null, SOLID_STROKE);
    public static final DrawingStyle CUSTOM2 = new DrawingStyle(new Color(0, 255, 255, 255), null, DOTTED_STROKE);
    public static final DrawingStyle RESIZE_WRAP = new DrawingStyle(new Color(0, 170, 0, 192), DASHED_STROKE);
    public static final DrawingStyle MARGIN_BOUNDS = new DrawingStyle(new Color(0, 170, 0, 192), new Color(0, 170, 0, 64), DASHED_STROKE);
    public static final DrawingStyle MARGIN_HANDLE = new DrawingStyle(new Color(0, 170, 0, 192), new Color(0, 170, 0, 64), SOLID_STROKE);
    public static final DrawingStyle PADDING_BOUNDS = new DrawingStyle(new Color(255, 153, 0, 255), new Color(255, 153, 0, 160), DASHED_STROKE);
    public static final DrawingStyle GRAVITY = new DrawingStyle(new Color(255, 0, 0, 192), null, THICK_PATTERN_STROKE);
    public static final DrawingStyle RESIZE_WEIGHTS = new DrawingStyle(new Color(0, 255, 255, 192), new Color(0, 255, 255, 64), SOLID_STROKE);
    public static final DrawingStyle RESIZE_SPAN = new DrawingStyle(new Color(0, 255, 255, 192), new Color(0, 255, 255, 64), SOLID_STROKE);
    private final int myLineWidth;
    private final Color myStrokeColor;
    private final Stroke myStroke;
    private final Color myFillColor;

    public DrawingStyle(Color strokeColor, Color fill, BasicStroke stroke) {
        this.myStrokeColor = strokeColor;
        this.myStroke = stroke;
        this.myFillColor = fill;
        this.myLineWidth = (int)stroke.getLineWidth();
    }

    public DrawingStyle(Color strokeColor, BasicStroke stroke) {
        this(strokeColor, null, stroke);
    }

    public int getLineWidth() {
        return this.myLineWidth;
    }

    public Color getStrokeColor() {
        return this.myStrokeColor;
    }

    public Stroke getStroke() {
        return this.myStroke;
    }

    public Color getFillColor() {
        return this.myFillColor;
    }
}

