/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.designSurface;

import com.android.tools.idea.rendering.Overlay;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderedImage;
import com.google.common.collect.Lists;
import com.intellij.android.designer.designSurface.AndroidDesignerEditorPanel;
import com.intellij.android.designer.designSurface.TransformedComponent;
import com.intellij.android.designer.designSurface.graphics.DesignerGraphics;
import com.intellij.android.designer.designSurface.graphics.DrawingStyle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class RootView
extends JComponent
implements TransformedComponent {
    public static final int EMPTY_COMPONENT_SIZE = 5;
    public static final int VISUAL_EMPTY_COMPONENT_SIZE = 14;
    private List<EmptyRegion> myEmptyRegions;
    private final AndroidDesignerEditorPanel myPanel;
    protected int myX;
    protected int myY;
    RenderedImage myRenderedImage;

    public RootView(AndroidDesignerEditorPanel panel, int x, int y, RenderResult renderResult) {
        this.myX = x;
        this.myY = y;
        this.myPanel = panel;
        this.myRenderedImage = renderResult.getImage();
    }

    public AndroidDesignerEditorPanel getPanel() {
        return this.myPanel;
    }

    public BufferedImage getImage() {
        return this.myRenderedImage != null ? this.myRenderedImage.getOriginalImage() : null;
    }

    public RenderedImage getRenderedImage() {
        return this.myRenderedImage;
    }

    public void setRenderedImage(RenderedImage image) {
        this.clearEmptyRegions();
        this.myRenderedImage = image;
        this.updateBounds(true);
        this.repaint();
    }

    public boolean getShowDropShadow() {
        if (this.myRenderedImage != null) {
            return this.myRenderedImage.getShowDropShadow();
        }
        return false;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintImage(g);
    }

    public void updateSize() {
        this.updateBounds(true);
    }

    protected void updateBounds(boolean imageChanged) {
        if (this.myRenderedImage == null) {
            return;
        }
        if (this.myPanel.isZoomToFit()) {
            this.myPanel.zoomToFitIfNecessary();
        }
        double zoom = this.myPanel.getZoom();
        this.myRenderedImage.setScale(zoom);
        Dimension requiredSize = this.myRenderedImage.getRequiredSize();
        int newWidth = requiredSize.width;
        int newHeight = requiredSize.height;
        if (this.getWidth() != newWidth || this.getHeight() != newHeight) {
            this.setSize(newWidth, newHeight);
            this.myRenderedImage.imageChanged();
        } else if (imageChanged) {
            this.myRenderedImage.imageChanged();
        }
    }

    public void clearEmptyRegions() {
        this.myEmptyRegions = null;
    }

    public void addEmptyRegion(int x, int y, int width, int height) {
        if (this.myRenderedImage == null) {
            return;
        }
        BufferedImage image = this.myRenderedImage.getOriginalImage();
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        if (x >= 0 && x <= imageWidth && y >= 0 && y <= imageHeight) {
            EmptyRegion r = new EmptyRegion();
            r.myX = Math.max(0, Math.min(x, imageWidth - 14));
            r.myY = Math.max(0, Math.min(y, imageHeight - 14));
            r.myWidth = width;
            r.myHeight = height;
            r.myColor = new Color(~image.getRGB(r.myX, r.myY));
            if (this.myEmptyRegions == null) {
                this.myEmptyRegions = new ArrayList<EmptyRegion>();
            }
            this.myEmptyRegions.add(r);
        }
    }

    protected void paintImage(Graphics g) {
        if (this.myRenderedImage == null) {
            return;
        }
        Shape clip = g.getClip();
        if (clip != null) {
            Rectangle clipBounds = g.getClipBounds();
            int deltaX = this.getX();
            int deltaY = this.getY();
            g.setClip(clipBounds.x - deltaX, clipBounds.y - deltaY, clipBounds.width += deltaX, clipBounds.height + deltaY);
        }
        double scale = this.myPanel.getZoom();
        this.myRenderedImage.setScale(scale);
        this.myRenderedImage.paint(g, 0, 0);
        if (this.myEmptyRegions != null && !this.myEmptyRegions.isEmpty()) {
            if (scale == 1.0) {
                for (EmptyRegion r : this.myEmptyRegions) {
                    DesignerGraphics.drawFilledRect(DrawingStyle.EMPTY, g, r.myX, r.myY, r.myWidth, r.myHeight);
                }
            } else {
                for (EmptyRegion r : this.myEmptyRegions) {
                    DesignerGraphics.drawFilledRect(DrawingStyle.EMPTY, g, (int)(scale * (double)r.myX), (int)(scale * (double)r.myY), (int)(scale * (double)r.myWidth), (int)(scale * (double)r.myHeight));
                }
            }
        }
        Overlay.paintOverlays(this.myPanel, this, g, 0, 0);
        if (clip != null) {
            g.setClip(clip);
        }
    }

    public int getScaledWidth() {
        if (this.myRenderedImage != null) {
            this.myRenderedImage.setScale(this.myPanel.getZoom());
            return this.myRenderedImage.getScaledWidth();
        }
        return 0;
    }

    public int getScaledHeight() {
        if (this.myRenderedImage != null) {
            this.myRenderedImage.setScale(this.myPanel.getZoom());
            return this.myRenderedImage.getScaledHeight();
        }
        return 0;
    }

    public double getScale() {
        double deviceFrameFactor;
        Rectangle viewBounds;
        double zoom = this.myPanel.getZoom();
        if (this.myRenderedImage != null && (viewBounds = this.myRenderedImage.getImageBounds()) != null && (deviceFrameFactor = viewBounds.getWidth() / (double)this.myRenderedImage.getScaledWidth()) != 1.0) {
            zoom *= deviceFrameFactor;
        }
        return zoom;
    }

    @Override
    public int getShiftX() {
        Rectangle viewBounds;
        if (this.myRenderedImage != null && (viewBounds = this.myRenderedImage.getImageBounds()) != null) {
            return viewBounds.x;
        }
        return 0;
    }

    @Override
    public int getShiftY() {
        Rectangle viewBounds;
        if (this.myRenderedImage != null && (viewBounds = this.myRenderedImage.getImageBounds()) != null) {
            return viewBounds.y;
        }
        return 0;
    }

    public List<Rectangle> getEmptyRegions() {
        ArrayList list = Lists.newArrayList();
        if (this.myEmptyRegions != null) {
            for (EmptyRegion region : this.myEmptyRegions) {
                list.add(new Rectangle(region.myX, region.myY, region.myWidth, region.myHeight));
            }
        }
        return list;
    }

    private static class EmptyRegion {
        public Color myColor;
        public int myX;
        public int myY;
        public int myWidth;
        public int myHeight;

        private EmptyRegion() {
        }
    }
}

