/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.dynamic;

import com.android.tools.idea.wizard.dynamic.AndroidStudioWizardPath;
import com.android.tools.idea.wizard.dynamic.DialogWrapperHost;
import com.android.tools.idea.wizard.dynamic.DynamicWizardHost;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.ide.wizard.Step;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import icons.AndroidIcons;
import java.awt.CardLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public abstract class DynamicWizard
implements ScopedStateStore.ScopedStoreListener {
    public static final int MAX_UPDATE_ATTEMPTS = 42;
    public static Logger LOG = Logger.getInstance(DynamicWizard.class);
    private final MergingUpdateQueue myUpdateQueue;
    private boolean myUpdateInProgress;
    private Project myProject;
    private Module myModule;
    protected final DynamicWizardHost myHost;
    protected String myName;
    protected ArrayList<AndroidStudioWizardPath> myPaths = Lists.newArrayList();
    protected AndroidStudioWizardPath myCurrentPath;
    protected PathIterator myPathListIterator = new PathIterator(this.myPaths);
    private boolean myIsInitialized = false;
    protected ScopedStateStore myState;
    private JPanel myContentPanel = new JPanel(new CardLayout());
    private Map<JComponent, String> myComponentToIdMap = Maps.newHashMap();

    public DynamicWizard(Project project, Module module, String name) {
        this(project, module, name, new DialogWrapperHost(project));
    }

    public DynamicWizard(Project project, Module module, String name, DynamicWizardHost host) {
        this.myHost = host;
        this.myProject = project;
        this.myModule = module;
        this.myName = name;
        this.myHost.setTitle(name);
        Application application = ApplicationManager.getApplication();
        this.myUpdateQueue = application == null || application.isUnitTestMode() ? null : new MergingUpdateQueue("wizard", 100, true, MergingUpdateQueue.ANY_COMPONENT, this.myHost.getDisposable(), null, true);
        this.myState = new ScopedStateStore(ScopedStateStore.Scope.WIZARD, null, this);
    }

    public void init() {
        this.myHost.init(this);
        this.myIsInitialized = true;
        if (this.myUpdateQueue != null) {
            int guard = 0;
            while (!this.myUpdateQueue.isEmpty()) {
                this.myUpdateQueue.flush();
                if (++guard < 42) continue;
                throw new IllegalStateException("Circular dependencies detected. Model state cannot be settled down.");
            }
        }
        Step step = this.showNextStep(null);
        assert (step != null);
    }

    public final MergingUpdateQueue getUpdateQueue() {
        return this.myUpdateQueue;
    }

    @Override
    public <T> void invokeUpdate(ScopedStateStore.Key<T> changedKey) {
        if (this.myUpdateQueue != null) {
            this.myUpdateQueue.queue((Update)new WizardUpdate());
        } else {
            this.update();
        }
    }

    private void update() {
        if (!this.myUpdateInProgress) {
            this.myUpdateInProgress = true;
            this.deriveValues(this.myState.getRecentUpdates());
            this.myUpdateInProgress = false;
        }
    }

    public void deriveValues(Set<ScopedStateStore.Key> modified) {
    }

    public boolean canPerformFinishingActions() {
        return true;
    }

    public abstract void performFinishingActions();

    public Project getProject() {
        return this.myProject;
    }

    protected final Module getModule() {
        return this.myModule;
    }

    public final void setErrorHtml(String errorMessage) {
        if (this.myCurrentPath != null) {
            this.myCurrentPath.setErrorHtml(errorMessage);
        }
    }

    public final void updateButtons(boolean canGoPrev, boolean canGoNext, boolean canCancelCurrentPath, boolean canFinishCurrentPath) {
        if (!this.myIsInitialized) {
            return;
        }
        this.myHost.updateButtons(canGoPrev && this.hasPrevious(), canGoNext && this.hasNext(), canCancelCurrentPath && this.canCancel(), canFinishCurrentPath && this.canFinish());
    }

    public final void addPath(AndroidStudioWizardPath path) {
        this.myPaths.add(path);
        path.attachToWizard(this);
        this.myPathListIterator = new PathIterator(this.myPaths);
    }

    public final ArrayList<AndroidStudioWizardPath> getAllPaths() {
        return this.myPaths;
    }

    public final AndroidStudioWizardPath getCurrentPath() {
        return this.myCurrentPath;
    }

    public final int getVisibleStepCount() {
        int sum = 0;
        for (AndroidStudioWizardPath path : this.myPaths) {
            sum += path.getVisibleStepCount();
        }
        return sum;
    }

    private void showStep(Step step) {
        JComponent component = step.getComponent();
        this.addStepIfNecessary(step);
        Icon icon = step.getIcon();
        this.myHost.setIcon(icon);
        ((CardLayout)this.myContentPanel.getLayout()).show(this.myContentPanel, this.myComponentToIdMap.get(component));
        JComponent focusedComponent = step.getPreferredFocusedComponent();
        if (focusedComponent != null) {
            IdeFocusManager.findInstanceByComponent((Component)focusedComponent).requestFocus((Component)focusedComponent, false);
        }
    }

    protected boolean canGoNext() {
        return this.myCurrentPath != null && this.myCurrentPath.canGoNext();
    }

    protected boolean canGoPrevious() {
        return this.myCurrentPath != null && this.myCurrentPath.canGoPrevious();
    }

    protected boolean hasNext() {
        return this.myCurrentPath != null && this.myCurrentPath.hasNext() || this.myPathListIterator.hasNext();
    }

    protected boolean hasPrevious() {
        return this.myCurrentPath != null && this.myCurrentPath.hasPrevious() || this.myPathListIterator.hasPrevious();
    }

    protected boolean canFinish() {
        if (!(this.myPathListIterator.hasNext() || this.myCurrentPath != null && this.myCurrentPath.hasNext())) {
            return true;
        }
        if (this.myCurrentPath != null && this.myCurrentPath.hasNext()) {
            return false;
        }
        boolean canFinish = true;
        PathIterator remainingPaths = this.myPathListIterator.getFreshCopy();
        while (canFinish && remainingPaths.hasNext()) {
            canFinish = !remainingPaths.next().isPathRequired();
        }
        return canFinish;
    }

    protected final boolean isLastStep() {
        if (this.myCurrentPath != null) {
            return !this.myPathListIterator.hasNext() && !this.myCurrentPath.hasNext();
        }
        return !this.myPathListIterator.hasNext();
    }

    public final void doNextAction() {
        if (!this.canAdvance()) {
            this.myHost.shakeWindow();
            return;
        }
        Step newStep = this.showNextStep(this.myCurrentPath);
        if (newStep == null) {
            this.doFinishAction();
        }
    }

    private Step showNextStep(AndroidStudioWizardPath path) {
        Step newStep = null;
        if (path != null) {
            newStep = path.next();
        }
        if (newStep == null) {
            newStep = null;
            while (this.myPathListIterator.hasNext() && newStep == null) {
                this.myCurrentPath = this.myPathListIterator.next();
                assert (this.myCurrentPath != null);
                this.myCurrentPath.onPathStarted(true);
                newStep = this.myCurrentPath.getCurrentStep();
            }
        }
        if (newStep != null) {
            this.showStep(newStep);
        }
        return newStep;
    }

    private boolean canAdvance() {
        if (this.myCurrentPath == null) {
            return true;
        }
        if (this.myCurrentPath.canGoNext()) {
            return this.myCurrentPath.hasNext() || this.myCurrentPath.readyToLeavePath();
        }
        return false;
    }

    public final void doPreviousAction() {
        assert (this.myCurrentPath != null);
        if (!this.myCurrentPath.canGoPrevious()) {
            this.myHost.shakeWindow();
            return;
        }
        Step newStep = this.myCurrentPath.previous();
        if (newStep == null) {
            while (this.myPathListIterator.hasPrevious() && newStep == null) {
                this.myCurrentPath = this.myPathListIterator.previous();
                assert (this.myCurrentPath != null);
                this.myCurrentPath.onPathStarted(false);
                newStep = this.myCurrentPath.getCurrentStep();
            }
        }
        if (newStep != null) {
            this.showStep(newStep);
        } else {
            LOG.error("Stepped into Path " + this.myCurrentPath + " which returned a null step");
        }
    }

    public void doFinishAction() {
        if (this.myCurrentPath != null && !this.myCurrentPath.readyToLeavePath()) {
            this.myHost.shakeWindow();
            return;
        }
        this.myHost.close(DynamicWizardHost.CloseAction.FINISH);
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                try {
                    ProgressManager.getInstance().getProgressIndicator().setIndeterminate(true);
                    DynamicWizard.this.doFinish();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }, this.getProgressTitle(), false, this.getProject(), this.getProgressParentComponent());
    }

    public JComponent getProgressParentComponent() {
        return null;
    }

    protected abstract String getProgressTitle();

    public void doCancelAction() {
        this.myHost.close(DynamicWizardHost.CloseAction.CANCEL);
    }

    protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
        return UndoConfirmationPolicy.DEFAULT;
    }

    public final JComponent getPreferredFocusedComponent() {
        Step currentStep = this.myCurrentPath.getCurrentStep();
        if (currentStep != null) {
            return currentStep.getPreferredFocusedComponent();
        }
        return null;
    }

    protected abstract String getWizardActionDescription();

    public final ScopedStateStore getState() {
        return this.myState;
    }

    private void prepareForShow() {
        assert (this.myIsInitialized) : "Must call init() before showing!";
        for (AndroidStudioWizardPath path : this.myPaths) {
            for (Step step : path.getAllSteps()) {
                this.addStepIfNecessary(step);
            }
        }
        SwingUtilities.getWindowAncestor(this.myContentPanel).pack();
    }

    private void addStepIfNecessary(Step step) {
        JComponent component = step.getComponent();
        String id = this.myComponentToIdMap.get(component);
        if (id == null) {
            id = String.valueOf(this.myComponentToIdMap.size());
            this.myComponentToIdMap.put(component, id);
            this.myContentPanel.add((Component)component, id);
        }
    }

    public void show() {
        this.prepareForShow();
        this.myHost.show();
    }

    public Disposable getDisposable() {
        return this.myHost.getDisposable();
    }

    public boolean showAndGet() {
        this.prepareForShow();
        return this.myHost.showAndGet();
    }

    public final Component getContentPane() {
        return this.myContentPanel;
    }

    public String getHelpId() {
        return null;
    }

    public void setTitle(String title) {
        this.myHost.setTitle(title);
    }

    public boolean containsStep(String stepName, boolean visibleOnly) {
        for (AndroidStudioWizardPath path : this.myPaths) {
            if (visibleOnly && !path.isPathVisible() || !path.containsStep(stepName, visibleOnly)) continue;
            return true;
        }
        return false;
    }

    public void navigateToNamedStep(String stepName, boolean requireVisible) {
        for (AndroidStudioWizardPath path : this.myPaths) {
            if (requireVisible && !path.isPathVisible() || !path.containsStep(stepName, requireVisible)) continue;
            this.myCurrentPath = path;
            this.myPathListIterator.myCurrentIndex = this.myPathListIterator.myList.indexOf(this.myCurrentPath);
            this.myCurrentPath.navigateToNamedStep(stepName, requireVisible);
            this.showStep(this.myCurrentPath.getCurrentStep());
            return;
        }
    }

    public boolean canCancel() {
        return true;
    }

    public Icon getIcon() {
        return AndroidIcons.Wizards.NewProjectMascotGreen;
    }

    protected void doFinish() throws IOException {
        for (AndroidStudioWizardPath path : this.myPaths) {
            if (!path.isPathVisible() || path.canPerformFinishingActions()) continue;
            return;
        }
        if (!this.canPerformFinishingActions()) {
            return;
        }
        for (AndroidStudioWizardPath path : this.myPaths) {
            if (!path.isPathVisible()) continue;
            path.performFinishingActions();
        }
        this.performFinishingActions();
    }

    private class WizardUpdate
    extends Update {
        public WizardUpdate() {
            super((Object)"Wizard Update");
        }

        public Object[] getEqualityObjects() {
            return new Object[]{DynamicWizard.this};
        }

        public void run() {
            DynamicWizard.this.update();
        }
    }

    protected static class PathIterator {
        private int myCurrentIndex;
        private ArrayList<AndroidStudioWizardPath> myList;

        public PathIterator(ArrayList<AndroidStudioWizardPath> list) {
            this.myList = list;
            this.myCurrentIndex = -1;
        }

        public PathIterator getFreshCopy() {
            PathIterator toReturn = new PathIterator(this.myList);
            toReturn.myCurrentIndex = this.myCurrentIndex;
            return toReturn;
        }

        public boolean hasNext() {
            if (this.myCurrentIndex >= this.myList.size() - 1) {
                return false;
            }
            for (int i = this.myCurrentIndex + 1; i < this.myList.size(); ++i) {
                AndroidStudioWizardPath path = this.myList.get(i);
                if (!path.isPathVisible() || path.getVisibleStepCount() <= 0) continue;
                return true;
            }
            return false;
        }

        public boolean hasPrevious() {
            if (this.myCurrentIndex <= 0) {
                return false;
            }
            for (int i = this.myCurrentIndex - 1; i >= 0; --i) {
                if (!this.myList.get(i).isPathVisible()) continue;
                return true;
            }
            return false;
        }

        public AndroidStudioWizardPath next() {
            while (this.myCurrentIndex < this.myList.size() - 1) {
                AndroidStudioWizardPath next;
                if (!(next = this.myList.get(++this.myCurrentIndex)).isPathVisible()) continue;
                return next;
            }
            return null;
        }

        public AndroidStudioWizardPath previous() {
            do {
                --this.myCurrentIndex;
            } while (this.myCurrentIndex >= 0 && !this.myList.get(this.myCurrentIndex).isPathVisible());
            if (this.myCurrentIndex >= 0) {
                return this.myList.get(this.myCurrentIndex);
            }
            return null;
        }
    }
}

