/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.sdklib.devices.Storage;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.NoPreviewRevision;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.IdDisplay;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.tools.idea.sdk.remote.RemotePkgInfo;
import com.android.tools.idea.welcome.install.FirstRunWizardDefaults;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallableComponent;
import com.android.tools.idea.welcome.install.WizardException;
import com.android.tools.idea.welcome.wizard.HaxmInstallSettingsStep;
import com.android.tools.idea.welcome.wizard.ProgressStep;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStep;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Platform;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingAnsiEscapesAwareProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Haxm
extends InstallableComponent {
    public static final Storage.Unit UI_UNITS = Storage.Unit.MiB;
    public static final Logger LOG = Logger.getInstance(Haxm.class);
    public static final IdDisplay ID_INTEL = new IdDisplay("intel", "");
    public static final String COMPONENT_PATH = "Hardware_Accelerated_Execution_Manager";
    public static final String RUNNING_INTEL_HAXM_INSTALLER_MESSAGE = "Running Intel\u00ae HAXM installer";
    private static final ScopedStateStore.Key<Integer> KEY_EMULATOR_MEMORY_MB = ScopedStateStore.createKey("emulator.memory", ScopedStateStore.Scope.PATH, Integer.class);
    private static long myMemorySize = -1L;
    private final ScopedStateStore.Key<Boolean> myIsCustomInstall;
    private ProgressStep myProgressStep;

    public static FullRevision getInstalledVersion(File sdk) throws WizardException {
        GeneralCommandLine command;
        String path = FileUtil.join((String[])new String[]{"extras", ID_INTEL.getId(), COMPONENT_PATH});
        File sourceLocation = new File(sdk, path);
        if (SystemInfo.isMac) {
            command = Haxm.addVersionParameters(Haxm.getMacHaxmCommandLine(sourceLocation));
        } else if (SystemInfo.isWindows) {
            command = Haxm.addVersionParameters(Haxm.getWindowsHaxmCommandLine(sourceLocation));
        } else {
            assert (!Haxm.canRun());
            throw new IllegalStateException("Unsupported OS");
        }
        try {
            CapturingAnsiEscapesAwareProcessHandler process = new CapturingAnsiEscapesAwareProcessHandler(command);
            return FullRevision.parseRevision((String)process.runProcess().getStdout());
        }
        catch (NumberFormatException e) {
            LOG.warn("Invalid HAXM version found.", (Throwable)e);
            return new FullRevision(0);
        }
        catch (ExecutionException e) {
            throw new WizardException("Failed to get HAXM version", e);
        }
    }

    public static boolean canRun() {
        if ((Boolean.getBoolean("install.haxm") && SystemInfo.isWindows || SystemInfo.isMac) && Haxm.isSupportedProcessor()) {
            return Haxm.getMemorySize() >= Storage.Unit.GiB.getNumberOfBytes();
        }
        return false;
    }

    private static boolean isSupportedProcessor() {
        String id;
        if (SystemInfo.isMac) {
            return true;
        }
        return SystemInfo.isWindows && (id = System.getenv().get("PROCESSOR_IDENTIFIER")) != null && id.contains("GenuineIntel");
    }

    public Haxm(ScopedStateStore store, ScopedStateStore.Key<Boolean> isCustomInstall) {
        super(store, "Performance (Intel \u00ae HAXM)", 0x233333L, "Enables a hardware-assisted virtualization engine (hypervisor) to speed up Android app emulation on your development computer. (Recommended)");
        this.myIsCustomInstall = isCustomInstall;
    }

    private GeneralCommandLine addInstallParameters(GeneralCommandLine cl, int memorySize) {
        cl.addParameters(new String[]{"-m", String.valueOf(memorySize)});
        return cl;
    }

    private static GeneralCommandLine addVersionParameters(GeneralCommandLine cl) {
        cl.addParameters(new String[]{"-v"});
        return cl;
    }

    private static GeneralCommandLine getMacHaxmCommandLine(File path) throws WizardException {
        Haxm.ensureExistsAndIsExecutable(path, "silent_install.sh");
        File executable = Haxm.ensureExistsAndIsExecutable(path, "HAXM installation");
        return new GeneralCommandLine(new String[]{executable.getAbsolutePath()}).withWorkDirectory(path);
    }

    private static File ensureExistsAndIsExecutable(File path, String exeName) throws WizardException {
        File executable = new File(path, exeName);
        if (!executable.isFile()) {
            throw new WizardException("HAXM installer executable is missing: " + executable.getAbsolutePath());
        }
        if (executable.canExecute() || executable.setExecutable(true)) {
            return executable;
        }
        throw new WizardException("Unable to set execute permission bit on HAXM installer executable: " + executable.getAbsolutePath());
    }

    private static GeneralCommandLine getWindowsHaxmCommandLine(File source) {
        File batFile = new File(source, "silent_install.bat");
        return new GeneralCommandLine(new String[]{batFile.getAbsolutePath()}).withWorkDirectory(source);
    }

    private static int getRecommendedMemoryAllocation() {
        return FirstRunWizardDefaults.getRecommendedHaxmMemory(Haxm.getMemorySize());
    }

    public static long getMemorySize() {
        if (myMemorySize < 0L) {
            myMemorySize = Haxm.checkMemorySize();
        }
        return myMemorySize;
    }

    private static long checkMemorySize() {
        OperatingSystemMXBean osMXBean = ManagementFactory.getOperatingSystemMXBean();
        try {
            Class<?> oracleSpecificMXBean = Class.forName("com.sun.management.OperatingSystemMXBean");
            Method getPhysicalMemorySizeMethod = oracleSpecificMXBean.getMethod("getTotalPhysicalMemorySize", new Class[0]);
            Object result = getPhysicalMemorySizeMethod.invoke((Object)osMXBean, new Object[0]);
            if (result instanceof Number) {
                return ((Number)result).longValue();
            }
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (InvocationTargetException e) {
            LOG.error((Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.error((Throwable)e);
        }
        return 32L * Storage.Unit.GiB.getNumberOfBytes();
    }

    private static IPkgDesc createExtra(IdDisplay vendor, String path) {
        return PkgDesc.Builder.newExtra((IdDisplay)vendor, (String)path, (String)"", null, (NoPreviewRevision)new NoPreviewRevision(0)).create();
    }

    @Override
    public void init(ProgressStep progressStep) {
        this.myProgressStep = progressStep;
        this.myStateStore.put(KEY_EMULATOR_MEMORY_MB, Haxm.getRecommendedMemoryAllocation());
    }

    @Override
    public Collection<DynamicWizardStep> createSteps() {
        return Collections.singleton(new HaxmInstallSettingsStep(this.myIsCustomInstall, this.myKey, KEY_EMULATOR_MEMORY_MB));
    }

    @Override
    public void configure(InstallContext installContext, File sdk) {
        if (!Haxm.canRun()) {
            Logger.getInstance(this.getClass()).error(String.format("Tried to install HAXM on %s OS with %s memory size", Platform.current().name(), String.valueOf(Haxm.getMemorySize())));
            installContext.print("Unable to install Intel HAXM\n", ConsoleViewContentType.ERROR_OUTPUT);
            return;
        }
        try {
            GeneralCommandLine commandLine = this.getInstallCommandLine(sdk);
            this.runInstaller(installContext, commandLine);
        }
        catch (WizardException e) {
            String message = e.getMessage();
            if (!StringUtil.endsWithLineBreak((CharSequence)message)) {
                message = message + "\n";
            }
            installContext.print(message, ConsoleViewContentType.ERROR_OUTPUT);
            LOG.error((Throwable)e);
        }
    }

    private void runInstaller(InstallContext installContext, GeneralCommandLine commandLine) {
        try {
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            progressIndicator.setIndeterminate(true);
            progressIndicator.setText(RUNNING_INTEL_HAXM_INSTALLER_MESSAGE);
            installContext.print("Running Intel\u00ae HAXM installer\n", ConsoleViewContentType.SYSTEM_OUTPUT);
            CapturingAnsiEscapesAwareProcessHandler process = new CapturingAnsiEscapesAwareProcessHandler(commandLine);
            final StringBuffer output = new StringBuffer();
            process.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(ProcessEvent event, Key outputType) {
                    output.append(event.getText());
                    super.onTextAvailable(event, outputType);
                }
            });
            this.myProgressStep.attachToProcess((ProcessHandler)process);
            int exitCode = process.runProcess().getExitCode();
            if (exitCode != 0) {
                installContext.print(String.format("HAXM installation failed. To install HAXM follow the instructions found at: %s", SystemInfo.isWindows ? "https://software.intel.com/android/articles/installation-instructions-for-intel-hardware-accelerated-execution-manager-windows" : "https://software.intel.com/android/articles/installation-instructions-for-intel-hardware-accelerated-execution-manager-mac-os-x"), ConsoleViewContentType.ERROR_OUTPUT);
                Matcher m = Pattern.compile("installation log:\\s*\"(.*)\"").matcher(output.toString());
                if (m.find()) {
                    String file = m.group(1);
                    try {
                        installContext.print("Installer log:\n", ConsoleViewContentType.ERROR_OUTPUT);
                        installContext.print(FileUtil.loadFile((File)new File(file), (String)"UTF-16"), ConsoleViewContentType.NORMAL_OUTPUT);
                    }
                    catch (IOException e) {
                        installContext.print("Failed to read installer output log.\n", ConsoleViewContentType.ERROR_OUTPUT);
                    }
                }
            }
            progressIndicator.setFraction(1.0);
        }
        catch (ExecutionException e) {
            installContext.print("Unable to run Intel HAXM installer: " + e.getMessage() + "\n", ConsoleViewContentType.ERROR_OUTPUT);
            LOG.error((Throwable)e);
        }
    }

    private GeneralCommandLine getInstallCommandLine(File sdk) throws WizardException {
        int memorySize = this.myStateStore.getNotNull(KEY_EMULATOR_MEMORY_MB, Haxm.getRecommendedMemoryAllocation());
        String path = FileUtil.join((String[])new String[]{"extras", ID_INTEL.getId(), COMPONENT_PATH});
        File sourceLocation = new File(sdk, path);
        if (SystemInfo.isMac) {
            return this.addInstallParameters(Haxm.getMacHaxmCommandLine(sourceLocation), memorySize);
        }
        if (SystemInfo.isWindows) {
            return this.addInstallParameters(Haxm.getWindowsHaxmCommandLine(sourceLocation), memorySize);
        }
        assert (!Haxm.canRun());
        throw new IllegalStateException("Unsupported OS");
    }

    @Override
    public Collection<IPkgDesc> getRequiredSdkPackages(Multimap<PkgType, RemotePkgInfo> remotePackages) {
        return ImmutableList.of((Object)Haxm.createExtra(ID_INTEL, COMPONENT_PATH));
    }
}

