/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.sdklib.devices.Storage;
import com.android.tools.idea.welcome.config.FirstRunWizardMode;
import com.android.tools.idea.welcome.install.Haxm;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import java.io.File;
import java.util.List;
import org.jetbrains.android.sdk.AndroidSdkUtils;

public class FirstRunWizardDefaults {
    public static final String HAXM_DOCUMENTATION_URL = "https://software.intel.com/android/articles/intel-hardware-accelerated-execution-manager";
    public static final String HAXM_WINDOWS_INSTALL_URL = "https://software.intel.com/android/articles/installation-instructions-for-intel-hardware-accelerated-execution-manager-windows";
    public static final String HAXM_MAC_INSTALL_URL = "https://software.intel.com/android/articles/installation-instructions-for-intel-hardware-accelerated-execution-manager-mac-os-x";
    public static final String KVM_LINUX_INSTALL_URL = "https://software.intel.com/blogs/2012/03/12/how-to-start-intel-hardware-assisted-virtualization-hypervisor-on-linux-to-speed-up-intel-android-x86-emulator";
    public static final JavaSdkVersion MIN_JDK_VERSION = JavaSdkVersion.JDK_1_7;

    private FirstRunWizardDefaults() {
    }

    public static int getRecommendedHaxmMemory(long memorySize) {
        long GB = Storage.Unit.GiB.getNumberOfBytes();
        long defaultMemory = memorySize > 4L * GB ? 2L * GB : (memorySize > 2L * GB ? GB : GB / 2L);
        return (int)(defaultMemory / Haxm.UI_UNITS.getNumberOfBytes());
    }

    public static String getSdkDownloadUrl() {
        String downloadUrl;
        String url = System.getProperty("android.sdkurl");
        if (!StringUtil.isEmptyOrSpaces((String)url)) {
            File file = new File(url);
            if (file.isFile()) {
                return "file://" + PathUtil.toSystemIndependentName((String)file.getAbsolutePath());
            }
            System.err.println("File " + file.getAbsolutePath() + " does not exist.");
        }
        if ((downloadUrl = AndroidSdkUtils.getSdkDownloadUrl()) == null) {
            throw new IllegalStateException("Unsupported OS");
        }
        return downloadUrl;
    }

    private static File getDefaultSdkLocation() {
        String path = System.getenv("ANDROID_HOME");
        if (Strings.isNullOrEmpty((String)path)) {
            String userHome = System.getProperty("user.home");
            if (SystemInfo.isWindows) {
                path = FileUtil.join((String[])new String[]{userHome, "AppData", "Local", "Android", "Sdk"});
            } else if (SystemInfo.isMac) {
                path = FileUtil.join((String[])new String[]{userHome, "Library", "Android", "sdk"});
            } else if (SystemInfo.isLinux) {
                path = FileUtil.join((String[])new String[]{userHome, "Android", "Sdk"});
            } else {
                Messages.showErrorDialog((String)"Your OS is not officially supported.\nYou can continue, but it is likely you will encounter further problems.", (String)"Unsupported OS");
                path = "";
            }
        }
        return new File(path);
    }

    public static File getInitialSdkLocation(FirstRunWizardMode mode) {
        VirtualFile homeDirectory;
        File dest = mode.getSdkLocation();
        if (dest != null) {
            return dest;
        }
        List<Sdk> sdks = AndroidSdkUtils.getAllAndroidSdks();
        Sdk sdk = (Sdk)Iterables.getFirst(sdks, null);
        if (sdk != null && (homeDirectory = sdk.getHomeDirectory()) != null) {
            return VfsUtilCore.virtualToIoFile((VirtualFile)homeDirectory);
        }
        return FirstRunWizardDefaults.getDefaultSdkLocation();
    }
}

